/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ConnectionComboBoxModel;
import ca.sqlpower.architect.swingui.DataSourceRenderer;
import ca.sqlpower.architect.swingui.PLExportPanel;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.architect.swingui.WizardPanel;
import ca.sqlpower.architect.swingui.event.CatalogComboBoxListener;
import ca.sqlpower.architect.swingui.event.DatabaseComboBoxListener;
import ca.sqlpower.architect.swingui.event.NewDatabaseListener;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLSecurityManager;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.util.UnknownFreqCodeException;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class QuickStartPanel3
implements WizardPanel {
    private static final Logger logger = Logger.getLogger(WizardPanel.class);
    private QuickStartWizard wizard;
    public PLExportPanel plExportPanel;
    private JComboBox repositoryConnectionsBox;
    private JPanel panel;
    private JComboBox repositoryCatalogComboBox;
    private JComboBox repositorySchemaComboBox;
    DatabaseComboBoxListener dcl;
    private JTextField plFolderName;
    private JTextField plJobId;
    private JTextField plJobComment;
    private JTextField plJobDescription;
    private JCheckBox runPLEngine;
    private JProgressBar progressBar;
    private ListCellRenderer dataSourceRenderer = new DataSourceRenderer();
    private JLabel label;

    public QuickStartPanel3(QuickStartWizard wizard) {
        this.wizard = wizard;
        FormLayout layout = new FormLayout("10dlu, 80dlu,10dlu, 5dlu,fill:100dlu:grow, 10dlu, 40dlu,30dlu", "15dlu, 16dlu, 2dlu, 16dlu, 2dlu, 16dlu, 20dlu,16dlu, 2dlu,16dlu,2dlu,16dlu,2dlu,16dlu,2dlu,16dlu,5dlu,16dlu, 2dlu");
        PanelBuilder pb = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        this.panel = new JPanel();
        this.repositoryConnectionsBox = new JComboBox(new ConnectionComboBoxModel());
        this.repositoryConnectionsBox.setRenderer(this.dataSourceRenderer);
        this.repositoryCatalogComboBox = new JComboBox();
        this.repositorySchemaComboBox = new JComboBox();
        this.progressBar = ((WizardDialog)wizard.getParentDialog()).getProgressBar();
        this.label = ((WizardDialog)wizard.getParentDialog()).getProgressLabel();
        this.label.setText("Loading Database.....");
        this.dcl = new DatabaseComboBoxListener((JPanel)this.getPanel(), this.repositoryConnectionsBox, this.repositoryCatalogComboBox, this.repositorySchemaComboBox, this.progressBar);
        ArrayList<JComponent> l1 = new ArrayList<JComponent>();
        l1.add(this.label);
        this.dcl.setVisableInvisableList(l1);
        ArrayList<JComponent> l2 = new ArrayList<JComponent>();
        l2.add(((WizardDialog)wizard.getParentDialog()).getNextButton());
        l2.add(((WizardDialog)wizard.getParentDialog()).getBackButton());
        this.dcl.setDisableEnableList(l2);
        this.repositoryConnectionsBox.addActionListener(this.dcl);
        this.repositoryCatalogComboBox.addActionListener(new CatalogComboBoxListener((JPanel)this.getPanel(), this.repositoryConnectionsBox, this.repositoryCatalogComboBox, this.repositorySchemaComboBox));
        JButton newRepositoryButton = new JButton("New");
        newRepositoryButton.addActionListener(new NewDatabaseListener(ArchitectFrame.getMainInstance(), "New Repository Database", this.repositoryConnectionsBox));
        this.plFolderName = new JTextField();
        this.plJobId = new JTextField();
        this.plJobDescription = new JTextField();
        this.plJobComment = new JTextField();
        this.runPLEngine = new JCheckBox("Run PL Engine?");
        this.runPLEngine.setEnabled(false);
        pb.add((Component)new JLabel("Repository Connection"), cc.xy(2, 2, "r,c"));
        pb.add((Component)this.repositoryConnectionsBox, cc.xyw(4, 2, 2));
        pb.add((Component)newRepositoryButton, cc.xy(7, 2));
        pb.add((Component)new JLabel("Repository Catalog"), cc.xy(2, 4, "r,c"));
        pb.add((Component)this.repositoryCatalogComboBox, cc.xyw(4, 4, 2));
        pb.add((Component)new JLabel("Repository Schema"), cc.xy(2, 6, "r,c"));
        pb.add((Component)this.repositorySchemaComboBox, cc.xyw(4, 6, 2));
        pb.add((Component)new JLabel("PL FolderName"), cc.xy(2, 8, "r,c"));
        pb.add((Component)this.plFolderName, cc.xyw(4, 8, 4));
        pb.add((Component)new JLabel("PL Job Id"), cc.xy(2, 10, "r,c"));
        pb.add((Component)this.plJobId, cc.xyw(4, 10, 4));
        pb.add((Component)new JLabel("PL Job Description"), cc.xy(2, 12, "r,c"));
        pb.add((Component)this.plJobDescription, cc.xyw(4, 12, 4));
        pb.add((Component)new JLabel("PL Job Comment"), cc.xy(2, 14, "r,c"));
        pb.add((Component)this.plJobComment, cc.xyw(4, 14, 4));
        pb.add((Component)this.runPLEngine, cc.xyw(4, 16, 2));
        this.panel.add(pb.getPanel());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyChanges() {
        SQLSchema schema;
        SQLCatalog catalog;
        SQLDatabase database;
        PLExport plexp;
        block69: {
            logger.debug((Object)"Applying repository database changes to the PLExport object");
            plexp = this.wizard.getPlExport();
            database = this.dcl.getDatabase();
            catalog = (SQLCatalog)this.repositoryCatalogComboBox.getSelectedItem();
            schema = (SQLSchema)this.repositorySchemaComboBox.getSelectedItem();
            if (database == null || this.repositoryConnectionsBox.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(this.getPanel(), "No Repository Database is selected, cannot continue.", "Database Error", 0);
                return false;
            }
            Connection con = null;
            try {
                con = database.getConnection();
                if (con == null) {
                    JOptionPane.showMessageDialog(this.getPanel(), "Couldn't connect to repository database.", "Repository Database Connection Error", 0);
                    return false;
                }
            }
            catch (PLSecurityException se) {
                JOptionPane.showMessageDialog(this.getPanel(), "Couldn't connect to repository database, " + se.getMessage(), "Repository Database Error", 0);
                return false;
            }
            catch (UnknownFreqCodeException e) {
                JOptionPane.showMessageDialog(this.getPanel(), "Couldn't connect to repository database, Frequence Code Setup error:" + e.getMessage(), "Repository Database Error", 0);
                return false;
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(this.getPanel(), "Couldn't connect to repository database, SQL ERROR:" + e.getMessage(), "Repository Database Error", 0);
                return false;
            }
            catch (ArchitectException e) {
                JOptionPane.showMessageDialog(this.getPanel(), e.getMessage(), "Repository Database Error", 0);
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            {
                PLSecurityManager sm = null;
                sm = new PLSecurityManager(con, database.getDataSource().get("UID"), database.getDataSource().get("PWD"), false);
                if (sm == null) {
                    JOptionPane.showMessageDialog(this.getPanel(), "Couldn't login to repository database.", "Repository Database Login Error", 0);
                    return false;
                }
                StringBuffer sql = new StringBuffer("SELECT SCHEMA_VERSION FROM ");
                sql.append(DDLUtils.toQualifiedName(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), "DEF_PARAM"));
                Statement s = con.createStatement();
                ResultSet rs = null;
                HashSet<String> set = new HashSet<String>();
                try {
                    try {
                        logger.debug((Object)("TRY TO VERTIFY PL SCHEMA EXISTENT: " + sql.toString()));
                        rs = s.executeQuery(sql.toString());
                        while (rs.next()) {
                            set.add(rs.getString(1));
                        }
                    }
                    catch (SQLException e) {
                        JOptionPane.showMessageDialog(this.getPanel(), "This repository database.catalog.schema [" + database.getName() + (catalog == null ? "" : "." + catalog.getName()) + (schema == null ? "" : "." + schema.getName()) + "] Does not contain Power Loader dictionary tables", "Repository Database Error", 0);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close result set", (Throwable)ex);
                        }
                        try {
                            if (s == null) return false;
                            s.close();
                            return false;
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close statement", (Throwable)ex);
                            return false;
                        }
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close result set", (Throwable)ex);
                    }
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close statement", (Throwable)ex);
                    }
                }
                if (set.size() == 0) {
                    JOptionPane.showMessageDialog(this.getPanel(), "This Invalid Power Loader Schema", "Repository Database Error", 0);
                    return false;
                }
                sql = new StringBuffer("SELECT JOB_ID FROM ");
                sql.append(DDLUtils.toQualifiedName(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), "PL_JOB"));
                sql.append(" WHERE JOB_ID=");
                sql.append(SQL.quote((String)this.plJobId.getText().toUpperCase()));
                s = con.createStatement();
                rs = null;
                set = new HashSet();
                try {
                    try {
                        logger.debug((Object)("TRY TO CHECK DUPLICATE JOB_ID: " + sql.toString()));
                        rs = s.executeQuery(sql.toString());
                        while (rs.next()) {
                            set.add(rs.getString(1));
                        }
                    }
                    catch (SQLException e) {
                        JOptionPane.showMessageDialog(this.getPanel(), "This repository database.catalog.schema [" + database.getName() + (catalog == null ? "" : "." + catalog.getName()) + (schema == null ? "" : "." + schema.getName()) + "] Does not contain Power Loader dictionary tables", "Repository Database Error", 0);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close result set", (Throwable)ex);
                        }
                        try {
                            if (s == null) return false;
                            s.close();
                            return false;
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close statement", (Throwable)ex);
                            return false;
                        }
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close result set", (Throwable)ex);
                    }
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close statement", (Throwable)ex);
                    }
                }
                if (set.size() == 0) break block69;
                JOptionPane.showMessageDialog(this.getPanel(), "Duplicate Job Id " + this.plJobId.getText(), "Metadata Error", 0);
                return false;
            }
        }
        try {
            if (database.isCatalogContainer() && database.getChildCount() > 0 && catalog == null) {
                return false;
            }
            if (database.isSchemaContainer() && database.getChildCount() > 0 && schema == null) {
                return false;
            }
            if (catalog != null && catalog.getChildCount() > 0 && catalog.isSchemaContainer() && schema == null) {
                return false;
            }
        }
        catch (ArchitectException e) {
            JOptionPane.showMessageDialog(this.getPanel(), "Database populate Erorr", "Error", 0);
            return false;
        }
        if (this.plJobId.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.getPanel(), "You must enter a Job ID", "Error", 0);
            return false;
        }
        plexp.setRepositoryDataSource((ArchitectDataSource)this.repositoryConnectionsBox.getSelectedItem());
        plexp.setRepositoryCatalog(catalog);
        plexp.setRepositorySchema(schema);
        plexp.setJobComment(this.plJobComment.getText());
        plexp.setJobDescription(this.plJobDescription.getText());
        plexp.setFolderName(this.plFolderName.getText());
        plexp.setJobId(this.plJobId.getText());
        return true;
    }

    public void discardChanges() {
    }

    public String getTitle() {
        return "Architect Quick Start - Step 3 of 5 - Select PL Repository";
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }
}

