/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class PrintPanel
extends JPanel
implements ArchitectPanel,
Pageable,
Printable,
ChangeListener {
    private static final Logger logger = Logger.getLogger(PrintPanel.class);
    protected PlayPen pp;
    protected JComboBox printerBox;
    protected PrinterJob job;
    protected PrintRequestAttributeSet jobAttributes;
    protected PageFormat pageFormat;
    protected JLabel pageFormatLabel;
    protected JButton pageFormatButton;
    protected JLabel zoomLabel;
    protected JSlider zoomSlider;
    protected JLabel pageCountLabel;
    protected JCheckBox printPageNumbersBox;
    protected PrintPreviewPanel previewPanel;
    protected int pagesAcross;
    protected int pagesDown;
    protected double zoom;

    public PrintPanel(PlayPen pp) {
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.pp = new PlayPen(pp);
        this.add(new PrintPreviewPanel());
        this.job = PrinterJob.getPrinterJob();
        this.jobAttributes = new HashPrintRequestAttributeSet();
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(new Paper());
        this.pageFormat.getPaper().setImageableArea(50.0, 50.0, this.pageFormat.getWidth() - 100.0, this.pageFormat.getHeight() - 100.0);
        JPanel formPanel = new JPanel(new FormLayout());
        formPanel.add(new JLabel("Printer"));
        this.printerBox = new JComboBox<PrintService>(PrinterJob.lookupPrintServices());
        formPanel.add(this.printerBox);
        this.printerBox.setSelectedItem(this.getPreferredPrinter());
        formPanel.add(new JLabel("Page Format"));
        String pf = PrintPanel.paperToPrintable(this.pageFormat);
        this.pageFormatLabel = new JLabel(pf.toString());
        formPanel.add(this.pageFormatLabel);
        formPanel.add(new JLabel("Change Page Format"));
        this.pageFormatButton = new JButton("Change Page Format");
        formPanel.add(this.pageFormatButton);
        this.pageFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPanel.this.setPageFormat(PrintPanel.this.job.pageDialog(PrintPanel.this.pageFormat));
            }
        });
        this.zoomLabel = new JLabel("Scaling = 100%");
        formPanel.add(this.zoomLabel);
        this.zoomSlider = new JSlider(0, 1, 300, 100);
        formPanel.add(this.zoomSlider);
        formPanel.add(new JLabel(""));
        this.printPageNumbersBox = new JCheckBox("Print Page Numbers in Top Margin");
        formPanel.add(this.printPageNumbersBox);
        this.printPageNumbersBox.setSelected(true);
        this.setZoom(1.0);
        this.zoomSlider.addChangeListener(this);
        this.pageCountLabel = new JLabel("Page Count: " + this.getNumberOfPages());
        formPanel.add(this.pageCountLabel);
        this.add(formPanel);
    }

    public static String paperToPrintable(PageFormat pageFormat) {
        StringBuffer pf = new StringBuffer();
        Paper paper = pageFormat.getPaper();
        pf.append(String.format("%.1f", paper.getWidth() / 72.0));
        pf.append('x');
        pf.append(String.format("%.1f", paper.getHeight() / 72.0));
        pf.append('-');
        switch (pageFormat.getOrientation()) {
            case 1: {
                pf.append("(portrait)");
                break;
            }
            case 0: {
                pf.append("(landscape)");
                break;
            }
            case 2: {
                pf.append("(rev. landscape)");
                break;
            }
            default: {
                pf.append("(?)");
            }
        }
        return pf.toString();
    }

    PrintService getPreferredPrinter() {
        String defaultPrinterName = ArchitectFrame.getMainInstance().getUserSettings().getPrintUserSettings().getDefaultPrinterName();
        PrintService psRetVal = null;
        Iterator<PrintService> it = Arrays.asList(PrinterJob.lookupPrintServices()).iterator();
        while (it.hasNext() && psRetVal == null) {
            PrintService ps = it.next();
            if (!ps.getName().equals(defaultPrinterName)) continue;
            psRetVal = ps;
        }
        if (psRetVal == null) {
            psRetVal = PrinterJob.getPrinterJob().getPrintService();
        }
        return psRetVal;
    }

    public void setPageFormat(PageFormat pf) {
        PageFormat oldPF = this.pageFormat;
        if (pf != null) {
            this.pageFormat = pf;
            if (pf != oldPF) {
                this.validateLayout();
                this.pageFormatLabel.setText(PrintPanel.paperToPrintable(this.pageFormat));
                this.firePropertyChange("pageFormat", oldPF, this.pageFormat);
            }
        }
    }

    public void validateLayout() {
        Dimension ppSize = this.pp.getPreferredSize();
        double ppWidth = ppSize.width;
        double ppHeight = ppSize.height;
        double paperWidth = this.pageFormat.getImageableWidth();
        double paperHeight = this.pageFormat.getImageableHeight();
        this.pagesAcross = (int)Math.ceil(this.zoom * ppWidth / paperWidth);
        this.pagesDown = (int)Math.ceil(this.zoom * ppHeight / paperHeight);
        this.pageCountLabel.setText("Page Count: " + this.getNumberOfPages());
    }

    public void setZoom(double newZoom) {
        double oldZoom = this.zoom;
        this.zoom = newZoom;
        this.zoomLabel.setText("Scaling = " + (int)(newZoom * 100.0) + "%");
        this.firePropertyChange("zoom", oldZoom, this.zoom);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.zoomSlider) {
            this.setZoom((double)this.zoomSlider.getValue() / 100.0);
        }
    }

    public int getNumberOfPages() {
        return this.pagesAcross * this.pagesDown;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        if (pageIndex < this.pagesAcross * this.pagesDown) {
            double leftMargin = pageFormat.getImageableX();
            double topMargin = pageFormat.getImageableY();
            double width = pageFormat.getImageableWidth();
            double height = pageFormat.getImageableHeight();
            int col = pageIndex % this.pagesAcross;
            int row = pageIndex / this.pagesAcross;
            logger.debug((Object)("Printing page " + (pageIndex + 1) + " of " + this.pagesAcross * this.pagesDown + " at [" + col + "," + row + "]"));
            AffineTransform backupXform = g2.getTransform();
            g2.translate(leftMargin - (double)col * width, topMargin - (double)row * height);
            g2.scale(this.zoom, this.zoom);
            this.pp.print(g2);
            g2.setTransform(backupXform);
            if (this.printPageNumbersBox.isSelected()) {
                g2.drawString("Page " + (pageIndex + 1) + " of " + this.pagesAcross * this.pagesDown, (float)(leftMargin + 10.0), (float)(topMargin + 10.0));
            }
            return 0;
        }
        return 1;
    }

    public boolean applyChanges() {
        try {
            if (this.printerBox.getItemCount() > 0 && this.printerBox.getSelectedItem() instanceof PrintService) {
                ArchitectFrame.getMainInstance().getUserSettings().getPrintUserSettings().setDefaultPrinterName(((PrintService)this.printerBox.getSelectedItem()).getName());
            }
            this.validateLayout();
            this.job.setPrintService((PrintService)this.printerBox.getSelectedItem());
            this.job.setPageable(this);
            this.job.print(this.jobAttributes);
        }
        catch (PrinterException ex) {
            logger.error((Object)"Printing failure", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Printing failed: " + ex.getMessage());
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this;
    }

    public class PrintPreviewPanel
    extends JPanel
    implements PropertyChangeListener {
        public PrintPreviewPanel() {
            this.setDoubleBuffered(false);
            PrintPanel.this.addPropertyChangeListener(this);
            PreviewZoomAdjuster adjuster = new PreviewZoomAdjuster();
            this.addMouseMotionListener(adjuster);
            this.addMouseListener(adjuster);
        }

        public Dimension getPreferredSize() {
            PrintPanel.this.validateLayout();
            double iW = PrintPanel.this.pageFormat.getImageableWidth();
            double iH = PrintPanel.this.pageFormat.getImageableHeight();
            double printoutWidth = (double)PrintPanel.this.pagesAcross * iW;
            double printoutHeight = (double)PrintPanel.this.pagesDown * iH;
            double preferredScale = 500.0 / printoutWidth;
            return new Dimension((int)(printoutWidth * preferredScale), (int)(printoutHeight * preferredScale));
        }

        private double calculateZoom() {
            Dimension ppSize = PrintPanel.this.pp.getPreferredSize();
            double previewZoomX = (double)this.getWidth() / (double)ppSize.width;
            double previewZoomY = (double)this.getHeight() / (double)ppSize.height;
            return Math.min(previewZoomX, previewZoomY);
        }

        public void paintComponent(Graphics g) {
            PrintPanel.this.validateLayout();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(PrintPanel.this.pp.getBackground());
            g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            double zoom = this.calculateZoom();
            int scaledWidth = (int)((double)this.getWidth() / zoom);
            int scaledHeight = (int)((double)this.getHeight() / zoom);
            if (logger.isDebugEnabled()) {
                Dimension ppSize = PrintPanel.this.pp.getPreferredSize();
                logger.debug((Object)("PlayPen preferred size = " + ppSize.width + "x" + ppSize.height));
                logger.debug((Object)("After scaling, preview panel coordinate space is " + scaledWidth + "x" + scaledHeight));
            }
            g2.scale(zoom, zoom);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            int i = 0;
            while (i < PrintPanel.this.pp.getPlayPenContentPane().getComponentCount()) {
                PlayPenComponent ppc = PrintPanel.this.pp.getPlayPenContentPane().getComponent(i);
                g2.translate(ppc.getX(), ppc.getY());
                ppc.paint(g2);
                g2.translate(-ppc.getX(), -ppc.getY());
                ++i;
            }
            double iW = PrintPanel.this.pageFormat.getImageableWidth();
            double iH = PrintPanel.this.pageFormat.getImageableHeight();
            g2.scale(1.0 / PrintPanel.this.zoom, 1.0 / PrintPanel.this.zoom);
            g2.setColor(PrintPanel.this.pp.getForeground());
            int i2 = 0;
            while (i2 <= PrintPanel.this.pagesAcross) {
                g2.drawLine((int)((double)i2 * iW), 0, (int)((double)i2 * iW), (int)((double)scaledHeight * PrintPanel.this.zoom));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Drew page separator at x=" + (double)i2 * iW));
                }
                ++i2;
            }
            i2 = 0;
            while (i2 <= PrintPanel.this.pagesDown) {
                g2.drawLine(0, (int)((double)i2 * iH), (int)((double)scaledWidth * PrintPanel.this.zoom), (int)((double)i2 * iH));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Drew page separator at y=" + (double)i2 * iH));
                }
                ++i2;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null) {
                return;
            }
            if (e.getPropertyName().equals("zoom") || e.getPropertyName().equals("pageFormat")) {
                this.repaint();
            }
        }

        public class PreviewZoomAdjuster
        extends MouseInputAdapter {
            public void mouseDragged(MouseEvent e) {
                PrintPreviewPanel.this.setCursor(Cursor.getPredefinedCursor(11));
                Point p = new Point(e.getPoint());
                double zoom = PrintPreviewPanel.this.calculateZoom();
                p.x = (int)((double)p.x / zoom);
                p.y = (int)((double)p.y / zoom);
                ((PrintPreviewPanel)PrintPreviewPanel.this).PrintPanel.this.zoomSlider.setValue((int)(((PrintPreviewPanel)PrintPreviewPanel.this).PrintPanel.this.pageFormat.getImageableWidth() / (double)p.x * 100.0));
            }

            public void mousePressed(MouseEvent e) {
                this.mouseDragged(e);
            }

            public void mouseReleased(MouseEvent e) {
                PrintPreviewPanel.this.setCursor(null);
            }
        }
    }
}

