/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import ca.sqlpower.architect.swingui.event.PlayPenComponentListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PlayPenContentPane {
    private static final Logger logger = Logger.getLogger(PlayPenContentPane.class);
    protected PlayPen owner;
    private List<PlayPenComponent> children = new ArrayList<PlayPenComponent>();
    private List<Relationship> relations = new ArrayList<Relationship>();
    private List<PlayPenComponentListener> playPenComponentListeners = new ArrayList<PlayPenComponentListener>();
    private PlayPenComponentEventPassthrough playPenComponentEventPassthrough;

    public PlayPenContentPane(PlayPen owner) {
        this.owner = owner;
        this.playPenComponentEventPassthrough = new PlayPenComponentEventPassthrough();
        owner.addPropertyChangeListener("zoom", new ZoomFixer());
    }

    public PlayPen getOwner() {
        return this.owner;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return true;
    }

    public boolean isValidateRoot() {
        logger.debug((Object)"isValidateRoot returning true");
        return true;
    }

    public String getToolTipText(MouseEvent e) {
        String text = null;
        PlayPenComponent c = this.getComponentAt(e.getPoint());
        if (c != null) {
            text = c.getToolTipText();
        }
        logger.debug((Object)("Checking for tooltip component at " + e.getPoint() + " is " + c + ". tooltipText is " + text));
        return text;
    }

    public PlayPenComponent getComponentAt(Point p) {
        for (PlayPenComponent playPenComponent : this.children) {
            if (!playPenComponent.contains(p)) continue;
            return playPenComponent;
        }
        for (Relationship relationship : this.relations) {
            if (!relationship.contains(p)) continue;
            return relationship;
        }
        return null;
    }

    public int getFirstRelationIndex() {
        return this.children.size();
    }

    public int getComponentCount() {
        return this.children.size() + this.relations.size();
    }

    public PlayPenComponent getComponent(int i) {
        if (i < this.children.size()) {
            return this.children.get(i);
        }
        return this.relations.get(i - this.children.size());
    }

    public void add(PlayPenComponent c, int i) {
        if (c instanceof Relationship) {
            this.relations.add(i - this.children.size(), (Relationship)c);
        } else {
            this.children.add(i, c);
        }
        c.addPlayPenComponentListener(this.playPenComponentEventPassthrough);
        c.addSelectionListener(this.getOwner());
        c.revalidate();
    }

    public void remove(int j) {
        PlayPenComponent c = j < this.children.size() ? this.children.get(j) : (PlayPenComponent)this.relations.get(j - this.children.size());
        Rectangle r = c.getBounds();
        c.removePlayPenComponentListener(this.playPenComponentEventPassthrough);
        c.removeSelectionListener(this.getOwner());
        if (j < this.children.size()) {
            this.children.remove(j);
        } else {
            this.relations.remove(j - this.children.size());
        }
        this.getOwner().repaint(r);
    }

    public void remove(PlayPenComponent c) {
        int j = this.children.indexOf(c);
        if (j >= 0) {
            this.remove(j);
        }
        if ((j = this.relations.indexOf(c)) >= 0) {
            this.remove(j + this.children.size());
        }
    }

    public void addPlayPenComponentListener(PlayPenComponentListener l) {
        this.playPenComponentListeners.add(l);
    }

    public void removePlayPenComponentListener(PlayPenComponentListener l) {
        this.playPenComponentListeners.remove(l);
    }

    private void refirePlayPenComponentMoved(PlayPenComponentEvent e) {
        for (PlayPenComponentListener l : this.playPenComponentListeners) {
            l.componentMoved(e);
        }
    }

    private void refirePlayPenComponentResized(PlayPenComponentEvent e) {
        for (PlayPenComponentListener l : this.playPenComponentListeners) {
            l.componentResized(e);
        }
    }

    private class ZoomFixer
    implements PropertyChangeListener {
        private ZoomFixer() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            for (PlayPenComponent ppc : PlayPenContentPane.this.children) {
                if (ppc instanceof Relationship) continue;
                ppc.revalidate();
            }
        }
    }

    private class PlayPenComponentEventPassthrough
    implements PlayPenComponentListener {
        private PlayPenComponentEventPassthrough() {
        }

        public void componentMoved(PlayPenComponentEvent e) {
            PlayPenContentPane.this.refirePlayPenComponentMoved(e);
        }

        public void componentResized(PlayPenComponentEvent e) {
            PlayPenContentPane.this.refirePlayPenComponentResized(e);
        }
    }
}

