/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.DBCSPanel;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DnDTreePathTransferable;
import ca.sqlpower.architect.swingui.Monitorable;
import ca.sqlpower.architect.swingui.MonitorableWorker;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.CancelAction;
import ca.sqlpower.architect.swingui.action.DBCSOkAction;
import ca.sqlpower.architect.swingui.action.SetDataSourceAction;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayPen
extends JPanel
implements Serializable,
SQLObjectListener,
SelectionListener,
Scrollable {
    private static Logger logger = Logger.getLogger(PlayPen.class);
    public static final String KEY_DELETE_SELECTED = "ca.sqlpower.architect.swingui.PlayPen.KEY_DELETE_SELECTED";
    private static MouseModeType mouseMode = MouseModeType.IDLE;
    protected DropTarget dt;
    protected SQLDatabase db;
    protected HashSet tableNames;
    protected JPopupMenu tablePanePopup;
    protected JPopupMenu playPenPopup;
    protected PPMouseListener ppMouseListener;
    protected Rectangle rubberBand;
    protected Color rubberBandColor = Color.black;
    protected double zoom = 1.0;
    protected PlayPenContentPane contentPane;
    protected Action bringToFrontAction;
    protected Action sendToBackAction;
    protected JDialog dbcsDialog;
    protected boolean draggingTablePanes = false;
    private Object antialiasSetting = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
    private Map<SQLObject, PlayPenComponent> removedComponents = new WeakHashMap<SQLObject, PlayPenComponent>();
    private boolean paintingEnabled = true;
    private TablePaneDragGestureListener dgl;
    private DragSource ds;
    private boolean normalizing;
    public Action chooseDBCSAction = new AbstractAction("Target Database Properties..."){

        public void actionPerformed(ActionEvent e) {
            PlayPen.this.showDbcsDialog();
        }
    };
    protected LinkedList selectionListeners = new LinkedList();
    protected LinkedList<CancelableListener> cancelableListeners = new LinkedList();
    protected LinkedList undoEventListeners = new LinkedList();

    public PlayPen() {
        this.setBackground(Color.white);
        this.contentPane = new PlayPenContentPane(this);
        this.setName("Play Pen");
        this.setMinimumSize(new Dimension(1, 1));
        this.dt = new DropTarget(this, new PlayPenDropListener());
        this.bringToFrontAction = new BringToFrontAction(this);
        this.sendToBackAction = new SendToBackAction(this);
        this.setupKeyboardActions();
        this.ppMouseListener = new PPMouseListener();
        this.addMouseListener(this.ppMouseListener);
        this.addMouseMotionListener(this.ppMouseListener);
        this.addMouseWheelListener(this.ppMouseListener);
        this.dgl = new TablePaneDragGestureListener();
        this.ds = new DragSource();
        this.ds.createDefaultDragGestureRecognizer(this, 2, this.dgl);
        logger.debug((Object)("DragGestureRecognizer motion threshold: " + this.getToolkit().getDesktopProperty("DnD.gestureMotionThreshold")));
    }

    public PlayPen(PlayPen pp) {
        this();
        PlayPenComponent ppc;
        int i = 0;
        while (i < pp.getContentPane().getComponentCount()) {
            ppc = pp.getContentPane().getComponent(i);
            if (ppc instanceof TablePane) {
                TablePane tp = (TablePane)ppc;
                this.addImpl(new TablePane(tp, this.contentPane), (Object)ppc.getPreferredLocation(), this.contentPane.getComponentCount());
            }
            ++i;
        }
        i = 0;
        while (i < pp.getContentPane().getComponentCount()) {
            ppc = pp.getContentPane().getComponent(i);
            if (ppc instanceof Relationship) {
                Relationship rel = (Relationship)ppc;
                TablePane pkTable = this.findTablePane(rel.getModel().getPkTable());
                TablePane fkTable = this.findTablePane(rel.getModel().getFkTable());
                this.addImpl(new Relationship(rel, this.contentPane, pkTable, fkTable), (Object)ppc.getPreferredLocation(), this.contentPane.getComponentCount());
            }
            ++i;
        }
        this.setSize(this.getPreferredSize());
    }

    public PlayPen(SQLDatabase db) {
        this();
        this.setDatabase(db);
    }

    public SQLDatabase getDatabase() {
        return this.db;
    }

    public List<SQLTable> getTables() throws ArchitectException {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        ArchitectUtils.extractTables(this.db, tables);
        return tables;
    }

    private final void setDatabase(SQLDatabase newdb) {
        if (newdb == null) {
            throw new NullPointerException("db must be non-null");
        }
        this.db = newdb;
        this.db.setPlayPenDatabase(true);
        if (this.db.getDataSource() == null) {
            ArchitectDataSource dbcs = new ArchitectDataSource();
            dbcs.setName("Not Configured");
            dbcs.setDisplayName("Not Configured");
            this.db.setDataSource(dbcs);
        }
        try {
            ArchitectUtils.listenToHierarchy((SQLObjectListener)this, this.db);
        }
        catch (ArchitectException ex) {
            logger.error((Object)"Couldn't listen to database", (Throwable)ex);
        }
        this.tableNames = new HashSet();
    }

    protected void setDatabaseConnection(ArchitectDataSource dbcs) {
        ArchitectDataSource tSpec = this.db.getDataSource();
        tSpec.setDisplayName(dbcs.getDisplayName());
        tSpec.setDriverClass(dbcs.getDriverClass());
        tSpec.setUrl(dbcs.getUrl());
        tSpec.setUser(dbcs.getUser());
        tSpec.setPass(dbcs.getPass());
        tSpec.setPlSchema(dbcs.getPlSchema());
        tSpec.setPlDbType(dbcs.getPlDbType());
        tSpec.setOdbcDsn(dbcs.getOdbcDsn());
    }

    void setupTablePanePopup() {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        this.tablePanePopup = new JPopupMenu();
        JMenuItem mi = new JMenuItem();
        mi.setAction(af.editColumnAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        mi = new JMenuItem();
        mi.setAction(af.insertColumnAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        this.tablePanePopup.addSeparator();
        mi = new JMenuItem();
        mi.setAction(af.editTableAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        mi = new JMenuItem();
        mi.setAction(this.bringToFrontAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        mi = new JMenuItem();
        mi.setAction(this.sendToBackAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        this.tablePanePopup.addSeparator();
        mi = new JMenuItem();
        mi.setAction(af.deleteSelectedAction);
        mi.setActionCommand("PlayPen");
        this.tablePanePopup.add(mi);
        if (logger.isDebugEnabled()) {
            this.tablePanePopup.addSeparator();
            mi = new JMenuItem("Show listeners");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    List<PlayPenComponent> selection = PlayPen.this.getSelectedItems();
                    if (selection.size() == 1) {
                        TablePane tp = (TablePane)selection.get(0);
                        JOptionPane.showMessageDialog(PlayPen.this, new JScrollPane(new JList<SQLObjectListener>(new Vector<SQLObjectListener>(tp.getModel().getSQLObjectListeners()))));
                    } else {
                        JOptionPane.showMessageDialog(PlayPen.this, "You can only show listeners on one item at a time");
                    }
                }
            });
            this.tablePanePopup.add(mi);
            mi = new JMenuItem("Show Selection List");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    List<PlayPenComponent> selection = PlayPen.this.getSelectedItems();
                    if (selection.size() == 1) {
                        TablePane tp = (TablePane)selection.get(0);
                        JOptionPane.showMessageDialog(PlayPen.this, new JScrollPane(new JList<Boolean>(new Vector<Boolean>(tp.columnSelection))));
                    } else {
                        JOptionPane.showMessageDialog(PlayPen.this, "You can only show selected columns on one item at a time");
                    }
                }
            });
            this.tablePanePopup.add(mi);
        }
    }

    void setupKeyboardActions() {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), KEY_DELETE_SELECTED);
        this.getActionMap().put(KEY_DELETE_SELECTED, af.deleteSelectedAction);
        if (af.deleteSelectedAction == null) {
            logger.warn((Object)"af.deleteSelectedAction is null!");
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.getActionMap().put("CANCEL", new CancelAction(this));
        this.getInputMap(2).put((KeyStroke)af.createTableAction.getValue("AcceleratorKey"), "NEW TABLE");
        this.getActionMap().put("NEW TABLE", af.createTableAction);
        this.getInputMap(2).put((KeyStroke)af.createIdentifyingRelationshipAction.getValue("AcceleratorKey"), "NEW IDENTIFYING RELATION");
        this.getActionMap().put("NEW IDENTIFYING RELATION", af.createIdentifyingRelationshipAction);
        this.getInputMap(2).put((KeyStroke)af.createNonIdentifyingRelationshipAction.getValue("AcceleratorKey"), "NEW NON IDENTIFYING RELATION");
        this.getActionMap().put("NEW NON IDENTIFYING RELATION", af.createNonIdentifyingRelationshipAction);
        String KEY_SELECT_UPWARD = "ca.sqlpower.architect.PlayPen.KEY_SELECT_UPWARD";
        String KEY_SELECT_DOWNWARD = "ca.sqlpower.architect.PlayPen.KEY_SELECT_DOWNWARD";
        String KEY_EDIT_SELECTION = "ca.sqlpower.architect.PlayPen.KEY_EDIT_SELECTION";
        inputMap.put(KeyStroke.getKeyStroke(38, 0), KEY_SELECT_UPWARD);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), KEY_SELECT_DOWNWARD);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), KEY_EDIT_SELECTION);
        this.getActionMap().put(KEY_SELECT_UPWARD, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TablePane tp;
                int oldIndex;
                PlayPenComponent item;
                List<PlayPenComponent> items = PlayPen.this.getSelectedItems();
                if (items.size() == 1 && (item = items.get(0)) instanceof TablePane && (oldIndex = (tp = (TablePane)item).getSelectedColumnIndex()) > 0) {
                    tp.selectNone();
                    tp.selectColumn(oldIndex - 1);
                }
            }
        });
        this.getActionMap().put(KEY_SELECT_DOWNWARD, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PlayPenComponent item;
                List<PlayPenComponent> items = PlayPen.this.getSelectedItems();
                if (items.size() == 1 && (item = items.get(0)) instanceof TablePane) {
                    TablePane tp = (TablePane)item;
                    int oldIndex = tp.getSelectedColumnIndex();
                    try {
                        if (oldIndex < tp.getModel().getColumns().size() - 1) {
                            tp.selectNone();
                            tp.selectColumn(oldIndex + 1);
                        }
                    }
                    catch (ArchitectException e1) {
                        logger.error((Object)("Could not get columns of " + tp.getName()), (Throwable)e1);
                    }
                }
            }
        });
        this.getActionMap().put(KEY_EDIT_SELECTION, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ActionEvent ev = new ActionEvent(e.getSource(), e.getID(), "PlayPen", e.getWhen(), e.getModifiers());
                ArchitectFrame.mainInstance.editColumnAction.actionPerformed(ev);
            }
        });
    }

    public void setChildPosition(PlayPenComponent child, Point p) {
        this.setChildPositionImpl(child, p.x, p.y);
    }

    public void setChildPosition(PlayPenComponent child, int x, int y) {
        this.setChildPositionImpl(child, x, y);
    }

    protected void setChildPositionImpl(PlayPenComponent child, int x, int y) {
        child.setLocation((int)((double)x / this.zoom), (int)((double)y / this.zoom));
    }

    public Point zoomPoint(Point p) {
        p.x = (int)((double)p.x * this.zoom);
        p.y = (int)((double)p.y * this.zoom);
        return p;
    }

    public Point unzoomPoint(Point p) {
        p.x = (int)((double)p.x / this.zoom);
        p.y = (int)((double)p.y / this.zoom);
        return p;
    }

    public Rectangle zoomRect(Rectangle r) {
        r.x = (int)((double)r.x * this.zoom);
        r.y = (int)((double)r.y * this.zoom);
        r.width = (int)((double)r.width * this.zoom);
        r.height = (int)((double)r.height * this.zoom);
        return r;
    }

    public Rectangle unzoomRect(Rectangle r) {
        r.x = (int)((double)r.x / this.zoom);
        r.y = (int)((double)r.y / this.zoom);
        r.width = (int)((double)r.width / this.zoom);
        r.height = (int)((double)r.height / this.zoom);
        return r;
    }

    public void setZoom(double newZoom) {
        if (newZoom != this.zoom) {
            double oldZoom = this.zoom;
            this.zoom = newZoom;
            this.firePropertyChange("zoom", oldZoom, newZoom);
            this.revalidate();
            this.repaint();
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setRenderingAntialiased(boolean v) {
        this.antialiasSetting = v ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.repaint();
    }

    public boolean isRenderingAntialiased() {
        return this.antialiasSetting == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public PlayPenContentPane getContentPane() {
        return this.contentPane;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension usedSpace = this.getUsedArea();
        Dimension vpSize = this.getViewportSize();
        Dimension ppSize = null;
        if (vpSize != null) {
            ppSize = new Dimension(Math.max(usedSpace.width, vpSize.width), Math.max(usedSpace.height, vpSize.height));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("minsize is: " + this.getMinimumSize()));
            logger.debug((Object)("unzoomed userDim is: " + this.unzoomPoint(new Point(usedSpace.width, usedSpace.height))));
            logger.debug((Object)("zoom=" + this.zoom + ",usedSpace size is " + usedSpace));
        }
        if (ppSize != null) {
            logger.debug((Object)("preferred size is ppSize (viewport size was null): " + ppSize));
            return ppSize;
        }
        logger.debug((Object)("preferred size is usedSpace: " + usedSpace));
        return usedSpace;
    }

    public Dimension getUsedArea() {
        Rectangle cbounds = null;
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        int i = 0;
        while (i < this.contentPane.getComponentCount()) {
            PlayPenComponent c = this.contentPane.getComponent(i);
            cbounds = c.getBounds(cbounds);
            minx = Math.min(cbounds.x, minx);
            miny = Math.min(cbounds.y, miny);
            maxx = Math.max(cbounds.x + cbounds.width, maxx);
            maxy = Math.max(cbounds.y + cbounds.height, maxy);
            ++i;
        }
        return new Dimension((int)((double)Math.max(maxx - minx, this.getMinimumSize().width) * this.zoom), (int)((double)Math.max(maxy - miny, this.getMinimumSize().height) * this.zoom));
    }

    public Dimension getViewportSize() {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("viewport size is: " + jvp.getSize()));
            return jvp.getSize();
        }
        logger.debug((Object)"viewport size is NULL");
        return null;
    }

    public void setViewportSize(int width, int height) {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("viewport size set to: " + width + "," + height));
            jvp.setSize(width, height);
        }
    }

    protected void normalize() {
        if (this.normalizing) {
            return;
        }
        this.normalizing = true;
        int minX = 0;
        int minY = 0;
        for (TablePane tp : this.getTablePanes()) {
            minX = Math.min(minX, tp.getX());
            minY = Math.min(minY, tp.getY());
        }
        if (minX < 0 || minY < 0) {
            for (TablePane tp : this.getTablePanes()) {
                tp.setLocation(tp.getX() - minX, tp.getY() - minY);
            }
            this.repaint();
        }
        this.normalizing = false;
    }

    public Point getViewPosition() {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            Point viewPosition = jvp.getViewPosition();
            logger.debug((Object)("view position is: " + viewPosition));
            return viewPosition;
        }
        return null;
    }

    public void setViewPosition(Point p) {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("view position set to: " + p));
            jvp.setViewPosition(p);
        }
    }

    public void setPaintingEnabled(boolean paintingEnabled) {
        this.paintingEnabled = paintingEnabled;
    }

    public boolean isPaintingEnabled() {
        return this.paintingEnabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.paintingEnabled) {
            return;
        }
        logger.debug((Object)("start of paintComponent, width=" + this.getWidth() + ",height=" + this.getHeight()));
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasSetting);
        if (logger.isDebugEnabled()) {
            Rectangle clip = g2.getClipBounds();
            if (clip != null) {
                g2.setColor(Color.green);
                --clip.width;
                --clip.height;
                g2.draw(clip);
                g2.setColor(this.getBackground());
                logger.debug((Object)("Clipping region: " + g2.getClip()));
            } else {
                logger.debug((Object)"Null clipping region");
            }
        }
        Rectangle bounds = new Rectangle();
        AffineTransform backup = g2.getTransform();
        g2.scale(this.zoom, this.zoom);
        AffineTransform zoomedOrigin = g2.getTransform();
        int i = this.contentPane.getComponentCount() - 1;
        while (i >= 0) {
            PlayPenComponent c = this.contentPane.getComponent(i);
            c.getBounds(bounds);
            if (g2.hitClip(bounds.x, bounds.y, bounds.width, bounds.height)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Painting visible component " + c));
                }
                g2.translate(c.getLocation().x, c.getLocation().y);
                c.paint(g2);
                g2.setTransform(zoomedOrigin);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("paint: SKIPPING " + c));
            }
            --i;
        }
        if (this.rubberBand != null && !this.rubberBand.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("painting rubber band " + this.rubberBand));
            }
            g2.setColor(this.rubberBandColor);
            Composite backupComp = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2.fillRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
            g2.setComposite(backupComp);
            g2.drawRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
        }
        g2.setTransform(backup);
        logger.debug((Object)("end of paintComponent, width=" + this.getWidth() + ",height=" + this.getHeight()));
    }

    @Override
    protected void addImpl(Component c, Object constraints, int index) {
        throw new UnsupportedOperationException("You can't add swing component for argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addImpl(PlayPenComponent c, Object constraints, int index) {
        if (c instanceof Relationship) {
            this.contentPane.add(c, this.contentPane.getFirstRelationIndex());
        } else {
            if (!(c instanceof TablePane)) throw new IllegalArgumentException("PlayPen can't contain components of type " + c.getClass().getName());
            if (!(constraints instanceof Point)) throw new IllegalArgumentException("Constraints must be a Point");
            c.setLocation((Point)constraints);
            this.contentPane.add(c, 0);
        }
        Dimension size = c.getPreferredSize();
        c.setSize(size);
        logger.debug((Object)("Set size to " + size));
        logger.debug((Object)("Final state looks like " + c));
    }

    public void addRelationship(Relationship r) {
        this.addImpl(r, null, this.getPPComponentCount());
    }

    public void addTablePane(TablePane tp, Point point) {
        this.addImpl(tp, (Object)point, this.getPPComponentCount());
    }

    @Override
    public int getComponentCount() {
        return super.getComponentCount();
    }

    @Override
    public Component getComponent(int i) {
        return super.getComponent(i);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point zp = this.unzoomPoint(e.getPoint());
        MouseEvent zoomedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), zp.x, zp.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return this.contentPane.getToolTipText(zoomedEvent);
    }

    protected void setupPlayPenPopup() {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        this.playPenPopup = new JPopupMenu();
        JMenuItem mi = new JMenuItem();
        mi.setAction(this.chooseDBCSAction);
        this.playPenPopup.add(mi);
        JMenu connectionsMenu = new JMenu("Set Target Database");
        for (ArchitectDataSource dbcs : ArchitectFrame.getMainInstance().getUserSettings().getConnections()) {
            connectionsMenu.add(new JMenuItem(new SetDataSourceAction(this.db, dbcs)));
        }
        this.playPenPopup.add(connectionsMenu);
        mi = new JMenuItem();
        mi.setAction(af.createTableAction);
        this.playPenPopup.add(mi);
        if (logger.isDebugEnabled()) {
            this.playPenPopup.addSeparator();
            mi = new JMenuItem("Show Relationships");
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JOptionPane.showMessageDialog(PlayPen.this, new JScrollPane(new JList<Relationship>(new Vector<Relationship>(PlayPen.this.getRelationships()))));
                }
            });
            this.playPenPopup.add(mi);
            mi = new JMenuItem("Show PlayPen Components");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    StringBuffer componentList = new StringBuffer();
                    int i = 0;
                    while (i < PlayPen.this.contentPane.getComponentCount()) {
                        PlayPenComponent c = PlayPen.this.contentPane.getComponent(i);
                        componentList.append(c).append("[" + c.getModel() + "]\n");
                        ++i;
                    }
                    JOptionPane.showMessageDialog(PlayPen.this, new JScrollPane(new JTextArea(componentList.toString())));
                }
            });
            this.playPenPopup.add(mi);
            mi = new JMenuItem("Show Undo Vector");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JOptionPane.showMessageDialog(PlayPen.this, new JScrollPane(new JTextArea(ArchitectFrame.getMainInstance().getProject().getUndoManager().printUndoVector())));
                }
            });
            this.playPenPopup.add(mi);
        }
    }

    public void showDbcsDialog() {
        final DBCSPanel dbcsPanel = new DBCSPanel();
        dbcsPanel.setDbcs(this.db.getDataSource());
        DBCSOkAction okAction = new DBCSOkAction(dbcsPanel, false);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                dbcsPanel.discardChanges();
            }
        };
        JDialog d = ArchitectPanelBuilder.createArchitectPanelDialog(dbcsPanel, ArchitectFrame.getMainInstance(), "Target Database Connection", "OK", okAction, cancelAction);
        okAction.setConnectionDialog(d);
        d.pack();
        d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        this.dbcsDialog = d;
        this.dbcsDialog.setVisible(true);
    }

    public TablePane findTablePane(SQLTable t) {
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            PlayPenComponent c = this.contentPane.getComponent(i);
            if (c instanceof TablePane && ((TablePane)c).getModel() == t) {
                return (TablePane)c;
            }
            ++i;
        }
        return null;
    }

    public TablePane findTablePaneByName(String name) {
        name = name.toLowerCase();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            PlayPenComponent c = this.contentPane.getComponent(i);
            if (c instanceof TablePane && ((TablePane)c).getModel().getName().toLowerCase().equals(name)) {
                return (TablePane)c;
            }
            ++i;
        }
        return null;
    }

    public Relationship findRelationship(SQLRelationship r) {
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            PlayPenComponent c = this.contentPane.getComponent(i);
            if (c instanceof Relationship && ((Relationship)c).getModel() == r) {
                return (Relationship)c;
            }
            ++i;
        }
        return null;
    }

    public List<Relationship> getRelationships() {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            if (this.contentPane.getComponent(i) instanceof Relationship) {
                relationships.add((Relationship)this.contentPane.getComponent(i));
            }
            ++i;
        }
        return relationships;
    }

    public List<TablePane> getTablePanes() {
        LinkedList<TablePane> tablePanes = new LinkedList<TablePane>();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            if (this.contentPane.getComponent(i) instanceof TablePane) {
                tablePanes.add((TablePane)this.contentPane.getComponent(i));
            }
            ++i;
        }
        return tablePanes;
    }

    public int getPPComponentCount() {
        return this.contentPane.getComponentCount();
    }

    public synchronized TablePane importTableCopy(SQLTable source, Point preferredLocation) throws ArchitectException {
        SQLTable newTable = SQLTable.getDerivedInstance(source, this.db);
        String key = source.getName().toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("before add: " + this.tableNames));
        }
        if (!this.tableNames.add(key)) {
            boolean done = false;
            int newSuffix = 0;
            while (!done) {
                done = this.tableNames.add(String.valueOf(key) + "_" + ++newSuffix);
            }
            newTable.setName(String.valueOf(source.getName()) + "_" + newSuffix);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after add: " + this.tableNames));
        }
        TablePane tp = new TablePane(newTable, this);
        logger.info((Object)("adding table " + newTable));
        this.addImpl(tp, (Object)preferredLocation, this.getPPComponentCount());
        tp.revalidate();
        this.createRelationshipsFromPP(source, newTable, true);
        this.createRelationshipsFromPP(source, newTable, false);
        return tp;
    }

    private void createRelationshipsFromPP(SQLTable source, SQLTable newTable, boolean isPrimaryKeyTableNew) throws ArchitectException {
        Iterator<SQLRelationship> sourceKeys = null;
        sourceKeys = isPrimaryKeyTableNew ? source.getExportedKeys().iterator() : source.getImportedKeys().iterator();
        while (sourceKeys.hasNext()) {
            SQLRelationship next = sourceKeys.next();
            if (!(next instanceof SQLRelationship)) continue;
            SQLRelationship r = next;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Looking for fk table " + r.getFkTable().getName() + " in playpen"));
            }
            TablePane tablePane = null;
            tablePane = isPrimaryKeyTableNew ? this.findTablePaneByName(r.getFkTable().getName()) : this.findTablePaneByName(r.getPkTable().getName());
            if (tablePane != null) {
                logger.info((Object)"FOUND IT!");
                SQLTable oldTable = tablePane.getModel();
                SQLRelationship newRel = new SQLRelationship();
                newRel.setName(r.getName());
                newRel.setIdentifying(true);
                if (isPrimaryKeyTableNew) {
                    newRel.attachRelationship(newTable, oldTable, false);
                } else {
                    newRel.attachRelationship(oldTable, newTable, false);
                }
                this.addImpl(new Relationship(this, newRel), null, this.getPPComponentCount());
                for (SQLRelationship.ColumnMapping m : r.getChildren()) {
                    this.setupMapping(newTable, oldTable, newRel, m, isPrimaryKeyTableNew);
                }
                continue;
            }
            logger.info((Object)"NOT FOUND");
        }
    }

    private void setupMapping(SQLTable newTable, SQLTable otherTable, SQLRelationship newRel, SQLRelationship.ColumnMapping m, boolean newTableIsPk) throws ArchitectException {
        SQLColumn pkCol = null;
        SQLColumn fkCol = null;
        if (newTableIsPk) {
            pkCol = newTable.getColumnByName(m.getPkColumn().getName());
            fkCol = otherTable.getColumnByName(m.getFkColumn().getName());
            if (pkCol == null) {
                throw new IllegalStateException("Couldn't find pkCol " + m.getPkColumn().getName() + " in new table");
            }
            if (fkCol == null) {
                return;
            }
        } else {
            pkCol = otherTable.getColumnByName(m.getPkColumn().getName());
            fkCol = newTable.getColumnByName(m.getFkColumn().getName());
            if (fkCol == null) {
                throw new IllegalStateException("Couldn't find fkCol " + m.getFkColumn().getName() + " in new table");
            }
            if (pkCol == null) {
                return;
            }
        }
        fkCol.addReference();
        SQLRelationship.ColumnMapping newMapping = new SQLRelationship.ColumnMapping();
        newMapping.setPkColumn(pkCol);
        newMapping.setFkColumn(fkCol);
        newRel.addChild(newMapping);
    }

    public synchronized void addObjects(List list, Point preferredLocation, ArchitectSwingWorker nextProcess) throws ArchitectException {
        ProgressMonitor pm = new ProgressMonitor(this, "Copying objects to the playpen", "...", 0, 100);
        AddObjectsTask t = new AddObjectsTask(list, preferredLocation, pm, null);
        t.setNextProcess(nextProcess);
        new Thread((Runnable)t, "Objects-Adder").start();
    }

    public void addFloating(TablePane tp) {
        new FloatingTableListener(this, tp, this.zoomPoint(new Point(tp.getSize().width / 2, 0)), true);
    }

    private void addHierarcyListeners(SQLObject sqlObject) throws ArchitectException {
        ArchitectUtils.listenToHierarchy((SQLObjectListener)this, sqlObject);
    }

    private void removeHierarcyListeners(SQLObject sqlObject) throws ArchitectException {
        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)this, sqlObject);
    }

    @Override
    public void dbChildrenInserted(SQLObjectEvent e) {
        logger.debug((Object)("SQLObject children got inserted: " + e));
        boolean fireEvent = false;
        SQLObject[] c = e.getChildren();
        int i = 0;
        while (i < c.length) {
            try {
                this.addHierarcyListeners(c[i]);
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't listen to added object", (Throwable)ex);
            }
            if (c[i] instanceof SQLTable || c[i] instanceof SQLRelationship && ((SQLTable.Folder)e.getSource()).getType() == 3) {
                fireEvent = true;
                PlayPenComponent ppc = this.removedComponents.get(c[i]);
                if (ppc != null) {
                    if (ppc instanceof Relationship) {
                        this.contentPane.add(ppc, this.contentPane.getComponentCount());
                    } else {
                        this.contentPane.add(ppc, this.contentPane.getFirstRelationIndex());
                    }
                }
            }
            ++i;
        }
        if (fireEvent) {
            this.firePropertyChange("model.children", null, null);
            this.revalidate();
        }
    }

    @Override
    public void dbChildrenRemoved(SQLObjectEvent e) {
        logger.debug((Object)("SQLObject children got removed: " + e));
        boolean foundRemovedComponent = false;
        SQLObject[] c = e.getChildren();
        int i = 0;
        while (i < c.length) {
            try {
                this.removeHierarcyListeners(c[i]);
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't unlisten to removed object", (Throwable)ex);
            }
            if (c[i] instanceof SQLTable) {
                int j = 0;
                while (j < this.contentPane.getComponentCount()) {
                    TablePane tp;
                    if (this.contentPane.getComponent(j) instanceof TablePane && (tp = (TablePane)this.contentPane.getComponent(j)).getModel() == c[i]) {
                        this.removedComponents.put(tp.getModel(), this.contentPane.getComponent(j));
                        this.contentPane.remove(j);
                        foundRemovedComponent = true;
                    }
                    ++j;
                }
            } else if (c[i] instanceof SQLRelationship) {
                int j = 0;
                while (j < this.contentPane.getComponentCount()) {
                    Relationship r;
                    if (this.contentPane.getComponent(j) instanceof Relationship && (r = (Relationship)this.contentPane.getComponent(j)).getModel() == c[i]) {
                        r.setSelected(false);
                        this.removedComponents.put(r.getModel(), this.contentPane.getComponent(j));
                        this.contentPane.remove(j);
                        foundRemovedComponent = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (foundRemovedComponent) {
            this.firePropertyChange("model.children", null, null);
            this.repaint();
        }
    }

    @Override
    public void dbObjectChanged(SQLObjectEvent e) {
        this.firePropertyChange("model." + e.getPropertyName(), null, null);
        this.revalidate();
    }

    @Override
    public void dbStructureChanged(SQLObjectEvent e) {
        logger.debug((Object)"Playpen has recieved a db structure change this is unsupported at the moment");
    }

    public void selectNone() {
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            if (this.contentPane.getComponent(i) instanceof Selectable) {
                PlayPenComponent s = this.contentPane.getComponent(i);
                s.setSelected(false);
            }
            ++i;
        }
    }

    public void selectAll() {
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            if (this.contentPane.getComponent(i) instanceof Selectable) {
                PlayPenComponent s = this.contentPane.getComponent(i);
                s.setSelected(true);
            }
            ++i;
        }
        mouseMode = MouseModeType.MULTI_SELECT;
    }

    public List<PlayPenComponent> getSelectedItems() {
        ArrayList<PlayPenComponent> selected = new ArrayList<PlayPenComponent>();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            PlayPenComponent s;
            if (this.contentPane.getComponent(i) instanceof Selectable && (s = this.contentPane.getComponent(i)).isSelected()) {
                selected.add(s);
            }
            ++i;
        }
        return Collections.unmodifiableList(selected);
    }

    public List<TablePane> getSelectedTables() {
        ArrayList<TablePane> selected = new ArrayList<TablePane>();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            TablePane tp;
            if (this.contentPane.getComponent(i) instanceof TablePane && (tp = (TablePane)this.contentPane.getComponent(i)).isSelected()) {
                selected.add(tp);
            }
            ++i;
        }
        return Collections.unmodifiableList(selected);
    }

    public List<Relationship> getSelectedRelationShips() {
        ArrayList<Relationship> selected = new ArrayList<Relationship>();
        int i = 0;
        int n = this.contentPane.getComponentCount();
        while (i < n) {
            Relationship r;
            if (this.contentPane.getComponent(i) instanceof Relationship && (r = (Relationship)this.contentPane.getComponent(i)).isSelected()) {
                selected.add(r);
            }
            ++i;
        }
        return Collections.unmodifiableList(selected);
    }

    @Override
    public void itemSelected(SelectionEvent e) {
        this.fireSelectionEvent(e);
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        this.fireSelectionEvent(e);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected void fireSelectionEvent(SelectionEvent e) {
        Iterator it = this.selectionListeners.iterator();
        if (e.getType() == 1) {
            while (it.hasNext()) {
                ((SelectionListener)it.next()).itemSelected(e);
            }
        } else if (e.getType() == 2) {
            while (it.hasNext()) {
                ((SelectionListener)it.next()).itemDeselected(e);
            }
        } else {
            throw new IllegalStateException("Unknown selection event type " + e.getType());
        }
    }

    public void addCancelableListener(CancelableListener l) {
        this.cancelableListeners.add(l);
    }

    public void removeCancelableListener(CancelableListener l) {
        this.cancelableListeners.remove(l);
    }

    public void fireCancel() {
        int i = this.cancelableListeners.size() - 1;
        while (i >= 0) {
            this.cancelableListeners.get(i).cancel();
            --i;
        }
    }

    public void addUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.add(l);
    }

    public void removeSelectionListener(UndoCompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    /*
     * Unable to fully structure code
     */
    private void fireUndoCompoundEvent(UndoCompoundEvent e) {
        block2: {
            it = this.undoEventListeners.iterator();
            if (!e.getType().isStartEvent()) ** GOTO lbl8
            while (it.hasNext()) {
                ((UndoCompoundEventListener)it.next()).compoundEditStart(e);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ((UndoCompoundEventListener)it.next()).compoundEditEnd(e);
lbl8:
                // 2 sources

                ** while (it.hasNext())
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, message));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(800, 600);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width / 5;
        }
        return visibleRect.height / 5;
    }

    public FontRenderContext getFontRenderContext() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        FontRenderContext frc = null;
        if (g2 != null) {
            g2.scale(this.zoom, this.zoom);
            frc = g2.getFontRenderContext();
            g2.dispose();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning frc=" + frc));
        }
        return frc;
    }

    public void selectAndShow(SQLObject selection) {
        Relationship r;
        if (selection instanceof SQLTable) {
            TablePane tp = this.findTablePane((SQLTable)selection);
            if (tp != null) {
                this.selectNone();
                tp.setSelected(true);
                Rectangle scrollTo = tp.getBounds();
                this.zoomRect(scrollTo);
                this.scrollRectToVisible(scrollTo);
            }
        } else if (selection instanceof SQLRelationship && (r = this.findRelationship((SQLRelationship)selection)) != null) {
            this.selectNone();
            r.setSelected(true);
            Rectangle scrollTo = r.getBounds();
            this.zoomRect(scrollTo);
            this.scrollRectToVisible(scrollTo);
        }
    }

    public PlayPenContentPane getPlayPenContentPane() {
        return this.contentPane;
    }

    public static void setMouseMode(MouseModeType mouseMode) {
        PlayPen.mouseMode = mouseMode;
    }

    public static interface CancelableListener {
        public void cancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MouseModeType {
        IDLE,
        CREATING_TABLE,
        CREATING_RELATIONSHIP,
        SELECT_TABLE,
        SELECT_RELATIONSHIP,
        SELECT_COLUMN,
        MULTI_SELECT,
        RUBBERBAND_MOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AddObjectsTask
    extends MonitorableWorker {
        private List<SQLObject> sqlObjects;
        private Point preferredLocation;
        private JDialog parentDialog;
        private boolean hasStarted = false;
        private boolean finished = false;
        private String message = null;
        private int progress = 0;
        private Integer jobSize = null;
        private String errorMessage = null;
        private ProgressMonitor pm;

        public AddObjectsTask(List<SQLObject> sqlObjects, Point preferredLocation, ProgressMonitor pm, JDialog parentDialog) {
            this.sqlObjects = sqlObjects;
            this.preferredLocation = preferredLocation;
            this.parentDialog = parentDialog;
            this.finished = false;
            new ProgressWatcher(pm, (Monitorable)this);
            this.pm = pm;
        }

        @Override
        public int getProgress() {
            return this.progress;
        }

        @Override
        public Integer getJobSize() {
            return this.jobSize;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public synchronized boolean isCanceled() {
            return super.isCanceled() || this.pm.isCanceled();
        }

        @Override
        public void doStuff() {
            logger.info((Object)("AddObjectsTask starting on thread " + Thread.currentThread().getName()));
            try {
                this.hasStarted = true;
                int pmMax = 0;
                Iterator<SQLObject> soIt = this.sqlObjects.iterator();
                while (soIt.hasNext() && !this.isCanceled()) {
                    pmMax += ArchitectUtils.countTablesSnapshot(soIt.next());
                }
                this.jobSize = new Integer(pmMax);
                this.ensurePopulated(this.sqlObjects);
            }
            catch (ArchitectException e) {
                logger.error((Object)"Unexpected exception during populate", (Throwable)e);
                this.errorMessage = "Unexpected exception during populate: " + e.getMessage();
            }
            logger.info((Object)"AddObjectsTask done");
        }

        private void ensurePopulated(List<SQLObject> soList) {
            for (SQLObject so : soList) {
                if (this.isCanceled()) break;
                try {
                    if (so instanceof SQLTable) {
                        ++this.progress;
                    }
                    this.ensurePopulated(so.getChildren());
                }
                catch (ArchitectException e) {
                    logger.error((Object)("Couldn't get children of " + so), (Throwable)e);
                }
            }
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void cleanup() {
            if (this.errorMessage != null) {
                JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, "Error Dropping Tables into Playpen", 0);
                if (this.getNextProcess() != null) {
                    this.setCancelled(true);
                }
            }
            ArchitectFrame.getMainInstance().getProject().getPlayPen().startCompoundEdit("Drag to Playpen");
            try {
                try {
                    soIt = this.sqlObjects.iterator();
                    if (true) ** GOTO lbl63
                    do {
                        block13: {
                            block15: {
                                block14: {
                                    block12: {
                                        someData = soIt.next();
                                        someData.fireDbStructureChanged();
                                        if (!(someData instanceof SQLTable)) break block12;
                                        tp = PlayPen.this.importTableCopy((SQLTable)someData, this.preferredLocation);
                                        this.message = ArchitectUtils.truncateString(((SQLTable)someData).getName());
                                        this.preferredLocation.x += tp.getPreferredSize().width + 5;
                                        ++this.progress;
                                        break block13;
                                    }
                                    if (!(someData instanceof SQLSchema)) break block14;
                                    sourceSchema = (SQLSchema)someData;
                                    it = sourceSchema.getChildren().iterator();
                                    while (it.hasNext() && !this.isCanceled()) {
                                        nextTable = it.next();
                                        if (nextTable instanceof SQLExceptionNode) continue;
                                        sourceTable = (SQLTable)nextTable;
                                        this.message = ArchitectUtils.truncateString(sourceTable.getName());
                                        tp = PlayPen.this.importTableCopy(sourceTable, this.preferredLocation);
                                        this.preferredLocation.x += tp.getPreferredSize().width + 5;
                                        ++this.progress;
                                    }
                                    break block13;
                                }
                                if (!(someData instanceof SQLCatalog)) break block15;
                                sourceCatalog = (SQLCatalog)someData;
                                cit = sourceCatalog.getChildren().iterator();
                                if (!sourceCatalog.isSchemaContainer()) ** GOTO lbl59
                                while (cit.hasNext() && !this.isCanceled()) {
                                    sourceSchema = (SQLSchema)cit.next();
                                    it = sourceSchema.getChildren().iterator();
                                    while (it.hasNext() && !this.isCanceled()) {
                                        nextTable = it.next();
                                        if (nextTable instanceof SQLExceptionNode) continue;
                                        sourceTable = (SQLTable)nextTable;
                                        this.message = ArchitectUtils.truncateString(sourceTable.getName());
                                        tp = PlayPen.this.importTableCopy(sourceTable, this.preferredLocation);
                                        this.preferredLocation.x += tp.getPreferredSize().width + 5;
                                        ++this.progress;
                                    }
                                }
                                break block13;
lbl-1000:
                                // 1 sources

                                {
                                    nextTable = cit.next();
                                    if (nextTable instanceof SQLExceptionNode) continue;
                                    sourceTable = (SQLTable)nextTable;
                                    this.message = ArchitectUtils.truncateString(sourceTable.getName());
                                    tp = PlayPen.this.importTableCopy(sourceTable, this.preferredLocation);
                                    this.preferredLocation.x += tp.getPreferredSize().width + 5;
                                    ++this.progress;
lbl59:
                                    // 3 sources

                                    ** while (cit.hasNext() && !this.isCanceled())
                                }
lbl60:
                                // 1 sources

                                break block13;
                            }
                            PlayPen.access$0().error((Object)("Unknown object dropped in PlayPen: " + someData));
                        }
                        if (!soIt.hasNext()) return;
                    } while (!this.isCanceled());
                    return;
                }
                catch (ArchitectException e) {
                    ASUtils.showExceptionDialog(this.parentDialog, "Unexpected Exception During Import", e, new ArchitectExceptionReportFactory());
                }
                return;
            }
            finally {
                this.finished = true;
                this.hasStarted = false;
                ArchitectFrame.getMainInstance().getProject().getPlayPen().endCompoundEdit("Ending multi-select");
            }
        }

        @Override
        public boolean hasStarted() {
            return this.hasStarted;
        }
    }

    public static class PlayPenDropListener
    implements DropTargetListener {
        protected TablePane tpTarget;

        public void dragEnter(DropTargetDragEvent dtde) {
            logger.debug((Object)"Drag enter");
            this.dragOver(dtde);
        }

        public void dragExit(DropTargetEvent dte) {
            logger.debug((Object)"Drag exit");
            if (this.tpTarget != null) {
                this.tpTarget.getDropTargetListener().dragExit(dte);
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            TablePane tp;
            PlayPen pp = (PlayPen)dtde.getDropTargetContext().getComponent();
            Point sp = pp.unzoomPoint(new Point(dtde.getLocation()));
            PlayPenComponent ppc = pp.contentPane.getComponentAt(sp);
            TablePane tablePane = tp = ppc != null && ppc instanceof TablePane ? (TablePane)ppc : null;
            if (tp != this.tpTarget) {
                if (this.tpTarget != null) {
                    this.tpTarget.getDropTargetListener().dragExit(dtde);
                }
                this.tpTarget = tp;
                if (this.tpTarget != null) {
                    this.tpTarget.getDropTargetListener().dragEnter(dtde);
                }
            }
            if (this.tpTarget != null) {
                this.tpTarget.getDropTargetListener().dragOver(dtde);
            } else {
                dtde.acceptDrag(1);
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            logger.info((Object)("Drop: I am over dtde=" + dtde));
            if (this.tpTarget != null) {
                this.tpTarget.getDropTargetListener().drop(dtde);
                return;
            }
            Transferable t = dtde.getTransferable();
            PlayPen playpen = (PlayPen)dtde.getDropTargetContext().getComponent();
            DataFlavor importFlavor = this.bestImportFlavor(playpen, t.getTransferDataFlavors());
            if (importFlavor == null) {
                dtde.rejectDrop();
            } else {
                try {
                    dtde.acceptDrop(1);
                    Point dropLoc = playpen.unzoomPoint(new Point(dtde.getLocation()));
                    ArrayList paths = (ArrayList)t.getTransferData(importFlavor);
                    Iterator it = paths.iterator();
                    DBTree dbtree = ArchitectFrame.getMainInstance().dbTree;
                    ArrayList<SQLObject> sqlObjects = new ArrayList<SQLObject>();
                    while (it.hasNext()) {
                        SQLObject oo = dbtree.getNodeForDnDPath((int[])it.next());
                        if (oo instanceof SQLObject) {
                            sqlObjects.add(oo);
                            continue;
                        }
                        logger.error((Object)("Unknown object dropped in PlayPen: " + oo));
                    }
                    playpen.addObjects(sqlObjects, dropLoc, null);
                    dtde.dropComplete(true);
                }
                catch (UnsupportedFlavorException ufe) {
                    logger.error((Object)ufe);
                    dtde.rejectDrop();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    dtde.rejectDrop();
                }
                catch (InvalidDnDOperationException ex) {
                    logger.error((Object)ex);
                    dtde.rejectDrop();
                }
                catch (ArchitectException ex) {
                    logger.error((Object)ex);
                    dtde.rejectDrop();
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            logger.debug((Object)"Drop Action Changed");
        }

        public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
            DataFlavor best = null;
            logger.debug((Object)("PlayPenTransferHandler: can I import " + Arrays.asList(flavors)));
            int i = 0;
            while (i < flavors.length) {
                String cls = flavors[i].getDefaultRepresentationClassAsString();
                logger.debug((Object)("representation class = " + cls));
                logger.debug((Object)("mime type = " + flavors[i].getMimeType()));
                logger.debug((Object)("type = " + flavors[i].getPrimaryType()));
                logger.debug((Object)("subtype = " + flavors[i].getSubType()));
                logger.debug((Object)("class = " + flavors[i].getParameter("class")));
                logger.debug((Object)("isSerializedObject = " + flavors[i].isFlavorSerializedObjectType()));
                logger.debug((Object)("isInputStream = " + flavors[i].isRepresentationClassInputStream()));
                logger.debug((Object)("isRemoteObject = " + flavors[i].isFlavorRemoteObjectType()));
                logger.debug((Object)("isLocalObject = " + flavors[i].getMimeType().equals("application/x-java-jvm-local-objectref")));
                if (flavors[i].equals(DnDTreePathTransferable.TREEPATH_ARRAYLIST_FLAVOR)) {
                    logger.debug((Object)"YES");
                    best = flavors[i];
                } else {
                    logger.debug((Object)"NO!");
                }
                ++i;
            }
            return best;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return this.bestImportFlavor(c, flavors) != null;
        }
    }

    public class TablePaneDragGestureListener
    implements DragGestureListener {
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (PlayPen.this.draggingTablePanes) {
                logger.debug((Object)"TablePaneDragGestureListener: ignoring drag event because draggingTablePanes is true");
                return;
            }
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(PlayPen.this.unzoomPoint(((MouseEvent)dge.getTriggerEvent()).getPoint()));
            if (c instanceof TablePane) {
                TablePane tp = (TablePane)c;
                int colIndex = -2;
                Point dragOrigin = tp.getPlayPen().unzoomPoint(new Point(dge.getDragOrigin()));
                dragOrigin.x -= tp.getX();
                dragOrigin.y -= tp.getY();
                if (dge.getTriggerEvent() instanceof MouseEvent && (dge.getTriggerEvent().getModifiers() & 0x10) == 0) {
                    return;
                }
                if (ArchitectFrame.getMainInstance().createRelationshipIsActive()) {
                    logger.debug((Object)"CreateRelationship() is active, short circuiting DnD.");
                    return;
                }
                try {
                    colIndex = tp.pointToColumnIndex(dragOrigin);
                }
                catch (ArchitectException e) {
                    logger.error((Object)"Got exception while translating drag point", (Throwable)e);
                }
                logger.debug((Object)("Recognized drag gesture on " + tp.getName() + "! origin=" + dragOrigin + "; col=" + colIndex));
                try {
                    logger.debug((Object)("DGL: colIndex=" + colIndex + ",columnsSize=" + tp.getModel().getColumns().size()));
                    if (colIndex == -1) {
                        throw new UnsupportedOperationException("We don't use DnD for dragging table panes");
                    }
                    if (colIndex >= 0 && colIndex < tp.getModel().getColumns().size()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Exporting column " + colIndex + " with DnD"));
                        }
                        tp.draggingColumn = tp.getModel().getColumn(colIndex);
                        DBTree tree = ArchitectFrame.getMainInstance().dbTree;
                        ArrayList<int[]> paths = new ArrayList<int[]>();
                        for (SQLColumn column : tp.getSelectedColumns()) {
                            int[] path = tree.getDnDPathToNode(column);
                            if (logger.isDebugEnabled()) {
                                StringBuffer array = new StringBuffer();
                                int i = 0;
                                while (i < path.length) {
                                    array.append(path[i]);
                                    array.append(",");
                                    ++i;
                                }
                                logger.debug((Object)("Path to dragged node: " + array));
                            }
                            paths.add(path);
                        }
                        logger.info((Object)("TablePaneDragGestureListener: exporting " + paths.size() + "-item list of DnD-type tree path"));
                        JLabel label = new JLabel(String.valueOf(tp.getModel().getName()) + "." + tp.draggingColumn.getName());
                        Dimension labelSize = label.getPreferredSize();
                        label.setSize(labelSize);
                        BufferedImage dragImage = new BufferedImage(labelSize.width, labelSize.height, 6);
                        Graphics2D imageGraphics = dragImage.createGraphics();
                        label.repaint();
                        imageGraphics.dispose();
                        dge.getDragSource().startDrag(dge, null, dragImage, new Point(0, 0), new DnDTreePathTransferable(paths), tp);
                    }
                }
                catch (ArchitectException ex) {
                    logger.error((Object)"Couldn't drag column", (Throwable)ex);
                    JOptionPane.showMessageDialog(tp.getPlayPen(), "Can't drag column: " + ex.getMessage());
                }
            } else {
                return;
            }
        }
    }

    protected class PPMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        protected Point rubberBandOrigin;
        private boolean componentPreviouslySelected;

        protected PPMouseListener() {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            PlayPen.this.unzoomPoint(p);
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            if (c != null) {
                p.translate(-c.getX(), -c.getY());
            }
            if (c instanceof Relationship) {
                if (evt.getClickCount() == 2) {
                    ArchitectFrame.getMainInstance().editRelationshipAction.actionPerformed(new ActionEvent(evt.getSource(), 1001, "PlayPen"));
                } else if (evt.getClickCount() == 1 && c.isSelected() && this.componentPreviouslySelected) {
                    c.setSelected(false);
                }
            } else if (c instanceof TablePane) {
                TablePane tp = (TablePane)c;
                if ((evt.getModifiers() & 0x10) != 0) {
                    try {
                        int selectedColIndex = tp.pointToColumnIndex(p);
                        if (evt.getClickCount() == 2) {
                            if (tp.isSelected()) {
                                ArchitectFrame af = ArchitectFrame.getMainInstance();
                                if (selectedColIndex == -1) {
                                    af.editTableAction.actionPerformed(new ActionEvent(tp, 1001, "PlayPen"));
                                } else if (selectedColIndex >= 0) {
                                    af.editColumnAction.actionPerformed(new ActionEvent(tp, 1001, "PlayPen"));
                                }
                            }
                        } else if (evt.getClickCount() == 1) {
                            logger.debug((Object)("Col index " + selectedColIndex));
                            if (selectedColIndex > -1 && this.componentPreviouslySelected) {
                                ((TablePane)c).deselectColumn(selectedColIndex);
                            } else if (c.isSelected() && this.componentPreviouslySelected) {
                                c.setSelected(false);
                            }
                        }
                    }
                    catch (ArchitectException e) {
                        logger.error((Object)"Exception converting point to column", (Throwable)e);
                    }
                }
            } else {
                this.maybeShowPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            this.componentPreviouslySelected = false;
            PlayPen.this.requestFocus();
            this.maybeShowPopup(evt);
            Point p = evt.getPoint();
            PlayPen.this.unzoomPoint(p);
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            if (c != null) {
                p.translate(-c.getX(), -c.getY());
            }
            if (c instanceof Relationship) {
                Relationship r = (Relationship)c;
                PlayPen pp = r.getPlayPen();
                if (mouseMode != MouseModeType.CREATING_RELATIONSHIP) {
                    if ((evt.getModifiersEx() & 0xC0) != 0) {
                        mouseMode = MouseModeType.MULTI_SELECT;
                    } else {
                        mouseMode = MouseModeType.SELECT_RELATIONSHIP;
                        if (!r.isSelected()) {
                            pp.selectNone();
                        }
                    }
                }
                if (r.isSelected()) {
                    this.componentPreviouslySelected = true;
                } else {
                    r.setSelected(true);
                }
                boolean overPkDec = ((RelationshipUI)r.getUI()).isOverPkDecoration(p);
                boolean overFkDec = ((RelationshipUI)r.getUI()).isOverFkDecoration(p);
                if (overPkDec || overFkDec && SwingUtilities.isLeftMouseButton(evt)) {
                    new Relationship.RelationshipDecorationMover(r, overPkDec);
                }
            } else if (c instanceof TablePane) {
                evt.getComponent().requestFocus();
                TablePane tp = (TablePane)c;
                PlayPen pp = tp.getPlayPen();
                try {
                    int clickCol = tp.pointToColumnIndex(p);
                    if (mouseMode != MouseModeType.CREATING_TABLE) {
                        if ((evt.getModifiersEx() & 0xC0) == 0) {
                            if (!tp.isSelected() || mouseMode == MouseModeType.IDLE) {
                                mouseMode = MouseModeType.SELECT_TABLE;
                                pp.selectNone();
                            }
                        } else {
                            mouseMode = MouseModeType.MULTI_SELECT;
                        }
                        if (clickCol > -1 && clickCol < tp.getModel().getColumns().size()) {
                            if ((evt.getModifiersEx() & 0xC0) == 0) {
                                if (!tp.isColumnSelected(clickCol)) {
                                    tp.deSelectEverythingElse(evt);
                                    tp.selectNone();
                                }
                                mouseMode = MouseModeType.SELECT_COLUMN;
                            }
                            if (tp.isColumnSelected(clickCol)) {
                                this.componentPreviouslySelected = true;
                            } else {
                                tp.selectColumn(clickCol);
                            }
                            tp.fireSelectionEvent(new SelectionEvent(tp, 1));
                            tp.repaint();
                        }
                        if (tp.isSelected() && clickCol == -1) {
                            this.componentPreviouslySelected = true;
                        } else {
                            tp.setSelected(true);
                        }
                    }
                    if (clickCol == -1 && !ArchitectFrame.getMainInstance().createRelationshipIsActive()) {
                        Iterator<TablePane> it = pp.getSelectedTables().iterator();
                        logger.debug((Object)("event point: " + p));
                        logger.debug((Object)("zoomed event point: " + pp.zoomPoint(new Point(p))));
                        PlayPen.this.draggingTablePanes = true;
                        while (it.hasNext()) {
                            TablePane t3 = it.next();
                            logger.debug((Object)("(" + t3.getModel().getName() + ") zoomed selected table point: " + t3.getLocationOnScreen()));
                            logger.debug((Object)("(" + t3.getModel().getName() + ") unzoomed selected table point: " + pp.unzoomPoint(t3.getLocationOnScreen())));
                            Point clickedColumn = tp.getLocationOnScreen();
                            Point otherTable = t3.getLocationOnScreen();
                            Point handle = pp.zoomPoint(new Point(p));
                            logger.debug((Object)("(" + t3.getModel().getName() + ") translation x=" + (otherTable.getX() - clickedColumn.getX()) + ",y=" + (otherTable.getY() - clickedColumn.getY())));
                            handle.translate((int)(clickedColumn.getX() - otherTable.getX()), (int)(clickedColumn.getY() - otherTable.getY()));
                            new FloatingTableListener(pp, t3, handle, false);
                        }
                    }
                }
                catch (ArchitectException e) {
                    logger.error((Object)"Exception converting point to column", (Throwable)e);
                }
            } else if ((evt.getModifiersEx() & 0x400) != 0 && !evt.isPopupTrigger()) {
                mouseMode = MouseModeType.IDLE;
                PlayPen.this.selectNone();
                this.rubberBandOrigin = new Point(p);
                PlayPen.this.rubberBand = new Rectangle(this.rubberBandOrigin.x, this.rubberBandOrigin.y, 0, 0);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            PlayPen.this.draggingTablePanes = false;
            if (PlayPen.this.rubberBand != null && evt.getButton() == 1) {
                Rectangle dirtyRegion = PlayPen.this.rubberBand;
                this.rubberBandOrigin = null;
                PlayPen.this.rubberBand = null;
                PlayPen.this.zoomRect(dirtyRegion);
                this.repaintRubberBandRegion(dirtyRegion);
                if (PlayPen.this.getSelectedItems().size() > 0) {
                    mouseMode = MouseModeType.MULTI_SELECT;
                } else {
                    mouseMode = MouseModeType.IDLE;
                }
            }
            this.maybeShowPopup(evt);
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseMoved(MouseEvent evt) {
            if (PlayPen.this.rubberBand != null) {
                Rectangle dirtyRegion = PlayPen.this.zoomRect(new Rectangle(PlayPen.this.rubberBand));
                Point p = PlayPen.this.unzoomPoint(evt.getPoint());
                PlayPen.this.rubberBand.setBounds(this.rubberBandOrigin.x, this.rubberBandOrigin.y, 0, 0);
                PlayPen.this.rubberBand.add(p);
                mouseMode = MouseModeType.RUBBERBAND_MOVE;
                Rectangle temp = new Rectangle();
                int i = 0;
                int n = PlayPen.this.contentPane.getComponentCount();
                while (i < n) {
                    PlayPenComponent c = PlayPen.this.contentPane.getComponent(i);
                    if (c instanceof Relationship) {
                        ((Relationship)c).setSelected(((Relationship)c).intersects(PlayPen.this.rubberBand));
                    } else if (c instanceof Selectable) {
                        c.setSelected(PlayPen.this.rubberBand.intersects(c.getBounds(temp)));
                    }
                    ++i;
                }
                dirtyRegion.add(PlayPen.this.zoomRect(new Rectangle(PlayPen.this.rubberBand)));
                this.repaintRubberBandRegion(dirtyRegion);
            }
        }

        private void repaintRubberBandRegion(Rectangle region) {
            Rectangle dirtyRegion = new Rectangle(region);
            dirtyRegion.x -= 3;
            dirtyRegion.y -= 3;
            dirtyRegion.width += 6;
            dirtyRegion.height += 6;
            PlayPen.this.repaint(dirtyRegion);
        }

        public boolean maybeShowPopup(MouseEvent evt) {
            PlayPen.this.setupTablePanePopup();
            PlayPen.this.setupPlayPenPopup();
            Point p = evt.getPoint();
            PlayPen.this.unzoomPoint(p);
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            if (c != null) {
                p.translate(-c.getX(), -c.getY());
            }
            if (c instanceof Relationship) {
                if (evt.isPopupTrigger() && !evt.isConsumed()) {
                    Relationship r = (Relationship)c;
                    r.setSelected(true);
                    r.showPopup(r.popup, p);
                    return true;
                }
            } else if (c instanceof TablePane) {
                TablePane tp = (TablePane)c;
                if (evt.isPopupTrigger() && !evt.isConsumed()) {
                    PlayPen pp = tp.getPlayPen();
                    try {
                        tp.selectNone();
                        int idx = tp.pointToColumnIndex(p);
                        if (idx >= 0) {
                            tp.selectColumn(idx);
                        }
                    }
                    catch (ArchitectException e) {
                        logger.error((Object)"Exception converting point to column", (Throwable)e);
                        return false;
                    }
                    logger.debug((Object)"about to show playpen tablepane popup...");
                    tp.showPopup(pp.tablePanePopup, p);
                    return true;
                }
            } else {
                PlayPen pp = (PlayPen)evt.getSource();
                if (evt.isPopupTrigger()) {
                    pp.playPenPopup.show(pp, evt.getX(), evt.getY());
                    return true;
                }
            }
            return false;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                if (e.getWheelRotation() > 0) {
                    ArchitectFrame.getMainInstance().getZoomInAction().actionPerformed(null);
                } else {
                    ArchitectFrame.getMainInstance().getZoomOutAction().actionPerformed(null);
                }
            } else {
                MouseWheelListener[] ml;
                MouseWheelListener[] mouseWheelListenerArray = ml = ArchitectFrame.getMainInstance().splitPane.getRightComponent().getMouseWheelListeners();
                int n = 0;
                int n2 = mouseWheelListenerArray.length;
                while (n < n2) {
                    MouseWheelListener m = mouseWheelListenerArray[n];
                    m.mouseWheelMoved(e);
                    ++n;
                }
            }
        }
    }

    public static class FloatingTableListener
    extends MouseInputAdapter
    implements CancelableListener {
        private PlayPen pp;
        private TablePane tp;
        private Point handle;
        private Point p;
        private boolean addToPP;

        public FloatingTableListener(PlayPen pp, TablePane tp, Point handle, boolean addToPP) {
            this.pp = pp;
            this.addToPP = addToPP;
            PointerInfo pi = MouseInfo.getPointerInfo();
            Point startLocation = pi.getLocation();
            SwingUtilities.convertPointFromScreen(startLocation, pp);
            logger.debug((Object)("Adding floating table at:" + startLocation));
            this.p = pp.zoomPoint(startLocation);
            this.tp = tp;
            this.handle = handle;
            pp.addMouseMotionListener(this);
            pp.addMouseListener(this);
            pp.addCancelableListener(this);
            if (addToPP) {
                pp.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                pp.setCursor(Cursor.getPredefinedCursor(13));
                pp.startCompoundEdit("Move" + tp.getName());
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.mouseDragged(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.pp.zoomPoint(e.getPoint());
            this.p = new Point(e.getPoint().x - this.handle.x, e.getPoint().y - this.handle.y);
            this.pp.setChildPosition(this.tp, this.p);
            this.pp.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.cleanup(false);
        }

        public void cancel() {
            this.cleanup(true);
        }

        protected void cleanup(boolean cancelled) {
            block8: {
                try {
                    if (!this.addToPP || cancelled) break block8;
                    this.pp.unzoomPoint(this.p);
                    logger.debug((Object)("Placing table at: " + this.p));
                    this.pp.addImpl(this.tp, (Object)this.p, this.pp.getPPComponentCount());
                    try {
                        this.pp.db.addChild(this.tp.getModel());
                        this.pp.selectNone();
                        this.tp.setSelected(true);
                        mouseMode = MouseModeType.SELECT_TABLE;
                    }
                    catch (ArchitectException e) {
                        logger.error((Object)("Couldn't add table \"" + this.tp.getModel() + "\" to play pen:"), (Throwable)e);
                        JOptionPane.showMessageDialog(null, "Failed to add table:\n" + e.getMessage());
                        if (!this.addToPP) {
                            this.pp.endCompoundEdit("Ending move for table " + this.tp.getName());
                        }
                        return;
                    }
                }
                finally {
                    if (!this.addToPP) {
                        this.pp.endCompoundEdit("Ending move for table " + this.tp.getName());
                    }
                }
            }
            this.pp.setCursor(null);
            this.pp.removeMouseMotionListener(this);
            this.pp.removeMouseListener(this);
            this.pp.removeCancelableListener(this);
            this.pp.normalize();
            this.pp.revalidate();
        }
    }

    public static class BringToFrontAction
    extends AbstractAction {
        protected PlayPen pp;

        public BringToFrontAction(PlayPen pp) {
            super("Bring to Front");
            this.pp = pp;
        }

        public void actionPerformed(ActionEvent e) {
            List<PlayPenComponent> items = this.pp.getSelectedItems();
            for (PlayPenComponent c : items) {
                this.pp.contentPane.remove(c);
                if (c instanceof Relationship) {
                    this.pp.contentPane.add(c, this.pp.contentPane.getFirstRelationIndex());
                    continue;
                }
                this.pp.contentPane.add(c, 0);
            }
            this.pp.repaint();
        }
    }

    public static class SendToBackAction
    extends AbstractAction {
        protected PlayPen pp;

        public SendToBackAction(PlayPen pp) {
            super("Send to Back");
            this.pp = pp;
        }

        public void actionPerformed(ActionEvent e) {
            List<PlayPenComponent> items = this.pp.getSelectedItems();
            for (PlayPenComponent c : items) {
                this.pp.contentPane.remove(c);
                if (c instanceof Relationship) {
                    this.pp.contentPane.add(c, this.pp.contentPane.getComponentCount());
                    continue;
                }
                this.pp.contentPane.add(c, this.pp.contentPane.getFirstRelationIndex());
            }
            this.pp.repaint();
        }
    }
}

