/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.SwingUIProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DDLExportPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(DDLExportPanel.class);
    private JPanel panel = new JPanel();
    private SwingUIProject project;
    private JComboBox dbType;
    private JLabel catalogLabel;
    private JTextField catalogField;
    private JLabel schemaLabel;
    private JTextField schemaField;

    public DDLExportPanel(SwingUIProject project) {
        this.project = project;
        this.setup();
        this.panel.setVisible(true);
    }

    private void setup() {
        GenericDDLGenerator ddlg = this.project.getDDLGenerator();
        this.panel.setLayout(new FormLayout());
        this.panel.add(new JLabel("Create in:"));
        ArchitectDataSource dbcs = this.project.getTargetDatabase().getDataSource();
        this.panel.add(new JLabel(dbcs == null ? "(target connection not set up)" : dbcs.getDisplayName()));
        this.panel.add(new JLabel("Generate DDL for Database Type:"));
        Vector<ASUtils.LabelValueBean> ddlTypes = DDLUtils.getDDLTypes();
        this.dbType = new JComboBox<ASUtils.LabelValueBean>(ddlTypes);
        this.panel.add(this.dbType);
        ASUtils.LabelValueBean unknownGenerator = ASUtils.lvb("Unknown Generator", ddlg.getClass());
        this.dbType.addItem(unknownGenerator);
        this.dbType.setSelectedItem(unknownGenerator);
        for (ASUtils.LabelValueBean lvb : ddlTypes) {
            if (ddlg.getClass() != lvb.getValue() || lvb == unknownGenerator) continue;
            this.dbType.setSelectedItem(lvb);
        }
        if (this.dbType.getSelectedItem() != unknownGenerator) {
            this.dbType.removeItem(unknownGenerator);
        }
        this.dbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DDLExportPanel.this.setUpCatalogAndSchemaFields();
            }
        });
        this.catalogLabel = new JLabel("Target Catalog");
        this.panel.add(this.catalogLabel);
        this.catalogField = new JTextField(ddlg.getTargetCatalog());
        this.panel.add(this.catalogField);
        this.schemaLabel = new JLabel("Target Schema");
        this.panel.add(this.schemaLabel);
        this.schemaField = new JTextField(ddlg.getTargetSchema());
        this.panel.add(this.schemaField);
        this.setUpCatalogAndSchemaFields();
    }

    private void setUpCatalogAndSchemaFields() {
        Class selectedGeneratorClass = null;
        try {
            selectedGeneratorClass = (Class)((ASUtils.LabelValueBean)this.dbType.getSelectedItem()).getValue();
            GenericDDLGenerator newGen = (GenericDDLGenerator)selectedGeneratorClass.newInstance();
            if (newGen.getCatalogTerm() != null) {
                this.catalogLabel.setText(newGen.getCatalogTerm());
                this.catalogLabel.setEnabled(true);
                this.catalogField.setEnabled(true);
            } else {
                this.catalogLabel.setText("(no catalog)");
                this.catalogLabel.setEnabled(false);
                this.catalogField.setText(null);
                this.catalogField.setEnabled(false);
            }
            if (newGen.getSchemaTerm() != null) {
                this.schemaLabel.setText(newGen.getSchemaTerm());
                this.schemaLabel.setEnabled(true);
                this.schemaField.setEnabled(true);
            } else {
                this.schemaLabel.setText("(no schema)");
                this.schemaLabel.setEnabled(false);
                this.schemaField.setText(null);
                this.schemaField.setEnabled(false);
            }
        }
        catch (Exception ex) {
            String message = "Couldn't create a DDL generator of the selected type";
            if (selectedGeneratorClass != null) {
                message = String.valueOf(message) + ":\n" + selectedGeneratorClass.getName();
            }
            logger.error((Object)message, (Throwable)ex);
            JOptionPane.showMessageDialog(this.panel, message, "Error", 0);
        }
    }

    public boolean applyChanges() {
        GenericDDLGenerator ddlg = this.project.getDDLGenerator();
        Class selectedGeneratorClass = (Class)((ASUtils.LabelValueBean)this.dbType.getSelectedItem()).getValue();
        if (ddlg.getClass() != selectedGeneratorClass) {
            try {
                ddlg = (GenericDDLGenerator)selectedGeneratorClass.newInstance();
                this.project.setDDLGenerator(ddlg);
            }
            catch (Exception ex) {
                logger.error((Object)"Problem creating user-selected DDL generator", (Throwable)ex);
                throw new RuntimeException("Couldn't create a DDL generator of the selected type");
            }
        }
        if (selectedGeneratorClass == GenericDDLGenerator.class) {
            ddlg.setAllowConnection(true);
            ArchitectDataSource dbcs = this.project.getTargetDatabase().getDataSource();
            if (dbcs == null || dbcs.getDriverClass() == null || dbcs.getDriverClass().length() == 0) {
                JOptionPane.showMessageDialog(this.panel, "You can't use the Generic JDBC Generator\nuntil you set up the target database connection.");
                ArchitectFrame.getMainInstance().playpen.showDbcsDialog();
                return false;
            }
        } else {
            ddlg.setAllowConnection(false);
        }
        if (this.catalogField.isEnabled()) {
            if (this.catalogField.getText() == null || this.catalogField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.panel, "Please provide a valid database catalog.");
                return false;
            }
            ddlg.setTargetCatalog(this.catalogField.getText());
        }
        if (this.schemaField.isEnabled()) {
            if (this.schemaField.getText() == null || this.schemaField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.panel, "Please provide a valid schema name.");
                return false;
            }
            ddlg.setTargetSchema(this.schemaField.getText());
        }
        return true;
    }

    public void discardChanges() {
    }

    public JTextField getSchemaField() {
        return this.schemaField;
    }

    public void setSchemaField(JTextField schemaField) {
        this.schemaField = schemaField;
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

