/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRelationshipUI
extends RelationshipUI
implements PropertyChangeListener,
Serializable {
    private static Logger logger = Logger.getLogger(BasicRelationshipUI.class);
    protected Relationship relationship;
    protected int orientation;
    protected Rectangle computedBounds;
    protected GeneralPath path;
    protected GeneralPath containmentPath;
    protected Color selectedColor = new Color(204, 204, 255);
    protected Color unselectedColor = Color.black;
    protected BasicStroke nonIdStroke = new BasicStroke(1.0f);
    protected BasicStroke idStroke = new BasicStroke(1.0f);
    protected int radius = 4;
    public static final int NO_FACING_EDGES = 0;
    public static final int PARENT_FACES_RIGHT = 1;
    public static final int PARENT_FACES_LEFT = 2;
    public static final int PARENT_FACES_BOTTOM = 4;
    public static final int PARENT_FACES_TOP = 8;
    public static final int CHILD_FACES_RIGHT = 16;
    public static final int CHILD_FACES_LEFT = 32;
    public static final int CHILD_FACES_BOTTOM = 64;
    public static final int CHILD_FACES_TOP = 128;

    public static PlayPenComponentUI createUI(PlayPenComponent c) {
        logger.debug((Object)("Creating new BasicRelationshipUI for " + c));
        return new BasicRelationshipUI();
    }

    @Override
    public void installUI(PlayPenComponent c) {
        logger.debug((Object)("Installing BasicRelationshipUI on " + c));
        this.relationship = (Relationship)c;
        this.relationship.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(PlayPenComponent c) {
        this.relationship = (Relationship)c;
        this.relationship.removePropertyChangeListener(this);
    }

    @Override
    public void revalidate() {
        Rectangle OldBounds = this.computedBounds;
        Rectangle bounds = this.computeBounds();
        if (!this.computedBounds.equals(OldBounds)) {
            this.relationship.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        this.paint(g2, this.relationship);
    }

    public void paint(Graphics g, PlayPenComponent c) {
        logger.debug((Object)"BasicRelationshipUI is painting");
        Relationship r = (Relationship)c;
        Graphics2D g2 = (Graphics2D)g;
        if (g2 == null) {
            throw new NullPointerException("Graphics g2 is null");
        }
        if (c == null) {
            throw new NullPointerException("Relationship c is null");
        }
        g2.translate(c.getX() * -1, c.getY() * -1);
        if (logger.isDebugEnabled()) {
            g2.setColor(c.getBackground());
            Rectangle bounds = c.getBounds();
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            logger.debug((Object)("Relationship bounds " + bounds));
            g2.setColor(c.getForeground());
        }
        try {
            Point pktloc = this.pkConnectionPoint;
            Point start = new Point(pktloc.x + r.getPkTable().getLocation().x, pktloc.y + r.getPkTable().getLocation().y);
            Point fktloc = this.fkConnectionPoint;
            Point end = new Point(fktloc.x + r.getFkTable().getLocation().x, fktloc.y + r.getFkTable().getLocation().y);
            this.containmentPath = new GeneralPath(1, 10);
            if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(start.x, start.y + this.getTerminationLength() * 2);
                this.containmentPath.lineTo(end.x - this.getTerminationLength() * 2, start.y + this.getTerminationLength() * 2);
                this.containmentPath.lineTo(end.x - this.getTerminationLength() * 2, end.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.containmentPath.lineTo(end.x - this.getTerminationLength() * 2, end.y);
                this.containmentPath.lineTo(end.x - this.getTerminationLength() * 2, start.y + this.getTerminationLength() * 2);
                this.containmentPath.lineTo(start.x, start.y + this.getTerminationLength() * 2);
            } else if ((this.orientation & 3) != 0 && (this.orientation & 0x30) != 0) {
                int midx = Math.abs(end.x - start.x) / 2 + Math.min(start.x, end.x);
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(midx, start.y);
                this.containmentPath.lineTo(midx, end.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.containmentPath.lineTo(midx, end.y);
                this.containmentPath.lineTo(midx, start.y);
                this.containmentPath.moveTo(start.x, start.y);
            } else if ((this.orientation & 0xC) != 0 && (this.orientation & 0xC0) != 0) {
                int midy = Math.abs(end.y - start.y) / 2 + Math.min(start.y, end.y);
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(start.x, midy);
                this.containmentPath.lineTo(end.x, midy);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.containmentPath.lineTo(end.x, midy);
                this.containmentPath.lineTo(start.x, midy);
                this.containmentPath.moveTo(start.x, start.y);
            } else if ((this.orientation & 3) != 0) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(end.x, start.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.containmentPath.lineTo(end.x, start.y);
                this.containmentPath.moveTo(start.x, start.y);
            } else if ((this.orientation & 0xC) != 0) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(start.x, end.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.containmentPath.lineTo(start.x, end.y);
                this.containmentPath.moveTo(start.x, start.y);
            } else {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
            }
            if (r.isSelected()) {
                g2.setColor(this.selectedColor);
            } else {
                g2.setColor(this.unselectedColor);
            }
            Stroke oldStroke = g2.getStroke();
            if (this.relationship.getModel().isIdentifying()) {
                g2.setStroke(this.getIdentifyingStroke());
            } else {
                g2.setStroke(this.getNonIdentifyingStroke());
            }
            g2.draw(this.path);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Drew path " + this.path));
            }
            g2.setStroke(oldStroke);
            this.paintTerminations(g2, start, end, this.orientation);
        }
        finally {
            g2.translate(c.getX(), c.getY());
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(this.relationship, p.x, p.y);
    }

    public boolean contains(PlayPenComponent c, int x, int y) {
        logger.debug((Object)("Contains, Looking for " + x + "," + y + " My bounds are: " + this.relationship.getBounds()));
        if (this.containmentPath == null) {
            return false;
        }
        return this.containmentPath.intersects(x - this.radius, y - this.radius, this.radius * 2, this.radius * 2);
    }

    @Override
    public boolean intersects(Rectangle region) {
        if (this.containmentPath == null) {
            return false;
        }
        return this.containmentPath.intersects(region.x, region.y, region.width, region.height);
    }

    protected void paintTerminations(Graphics2D g2, Point start, Point end, int orientation) {
        Color oldColor = g2.getColor();
        g2.setColor(Color.red);
        g2.fillOval(start.x - 2, start.y - 2, 4, 4);
        g2.fillOval(end.x - 2, end.y - 2, 4, 4);
        g2.setColor(oldColor);
    }

    @Override
    public void bestConnectionPoints() {
        Rectangle pktBounds = this.relationship.getPkTable().getBounds();
        Rectangle fktBounds = this.relationship.getFkTable().getBounds();
        if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
            this.orientation = 36;
            this.pkConnectionPoint.move(pktBounds.width / 2, pktBounds.height);
            this.fkConnectionPoint.move(0, fktBounds.height / 2);
            logger.debug((Object)("Self-referencing table: set connection points pk=" + this.pkConnectionPoint + "; fk=" + this.fkConnectionPoint));
        } else {
            Line2D.Double pkToFkBorderLine = this.calcConnectionPoints(pktBounds, fktBounds);
            this.orientation = this.getFacingEdges(pktBounds, fktBounds);
            if ((this.orientation & 4) != 0 || (this.orientation & 8) != 0) {
                pkToFkBorderLine.x1 = Math.max((double)(pktBounds.x + this.getTerminationWidth()), pkToFkBorderLine.x1);
                pkToFkBorderLine.x1 = Math.min((double)(pktBounds.x + pktBounds.width - this.getTerminationWidth()), pkToFkBorderLine.x1);
            } else if ((this.orientation & 2) != 0 || (this.orientation & 1) != 0) {
                pkToFkBorderLine.y1 = Math.max((double)(pktBounds.y + this.getTerminationWidth()), pkToFkBorderLine.y1);
                pkToFkBorderLine.y1 = Math.min((double)(pktBounds.y + pktBounds.height - this.getTerminationWidth()), pkToFkBorderLine.y1);
            }
            if ((this.orientation & 0x40) != 0 || (this.orientation & 0x80) != 0) {
                pkToFkBorderLine.x2 = Math.max((double)(fktBounds.x + this.getTerminationWidth()), pkToFkBorderLine.x2);
                pkToFkBorderLine.x2 = Math.min((double)(fktBounds.x + fktBounds.width - this.getTerminationWidth()), pkToFkBorderLine.x2);
            } else if ((this.orientation & 0x20) != 0 || (this.orientation & 0x10) != 0) {
                pkToFkBorderLine.y2 = Math.max((double)(fktBounds.y + this.getTerminationWidth()), pkToFkBorderLine.y2);
                pkToFkBorderLine.y2 = Math.min((double)(fktBounds.y + fktBounds.height - this.getTerminationWidth()), pkToFkBorderLine.y2);
            }
            this.pkConnectionPoint.move((int)(pkToFkBorderLine.x1 - (double)pktBounds.x), (int)(pkToFkBorderLine.y1 - (double)pktBounds.y));
            this.fkConnectionPoint.move((int)(pkToFkBorderLine.x2 - (double)fktBounds.x), (int)(pkToFkBorderLine.y2 - (double)fktBounds.y));
        }
    }

    private Line2D.Double calcConnectionPoints(Rectangle pktBounds, Rectangle fktBounds) {
        Line2D.Double centreToCentreLine = new Line2D.Double(pktBounds.getCenterX(), pktBounds.getCenterY(), fktBounds.getCenterX(), fktBounds.getCenterY());
        Line2D.Double retval = new Line2D.Double();
        List<Point2D.Double> pkTableIntersectPoints = ASUtils.getIntersectPoints(pktBounds, centreToCentreLine);
        List<Point2D.Double> fkTableIntersectPoints = ASUtils.getIntersectPoints(fktBounds, centreToCentreLine);
        if (pkTableIntersectPoints.size() == 0) {
            logger.debug((Object)"Could not calculate intersection of pk tablepane bound and center line between pk/fk tablepanes, returning the top left corner");
            retval.x1 = pktBounds.x;
            retval.y1 = pktBounds.y;
        } else {
            retval.x1 = pkTableIntersectPoints.get((int)0).x;
            retval.y1 = pkTableIntersectPoints.get((int)0).y;
        }
        if (fkTableIntersectPoints.size() == 0) {
            logger.debug((Object)"Could not calculate intersection of fk tablepane bound and center line between pk/fk tablepanes, returning the top left corner");
            retval.x2 = fktBounds.x;
            retval.y2 = fktBounds.y;
        } else {
            retval.x2 = fkTableIntersectPoints.get((int)0).x;
            retval.y2 = fkTableIntersectPoints.get((int)0).y;
        }
        return retval;
    }

    @Override
    public Point closestEdgePoint(boolean onPkTable, Point p) {
        Point ep;
        TablePane tp = onPkTable ? this.relationship.getPkTable() : this.relationship.getFkTable();
        Dimension tpsize = tp.getSize();
        if (onPkTable) {
            Point sp = new Point(this.relationship.getFkTable().getLocation());
            this.translatePoint(sp, this.fkConnectionPoint);
            sp.x -= this.relationship.getPkTable().getX();
            sp.y -= this.relationship.getPkTable().getY();
            if ((this.orientation & 2) != 0) {
                ep = new Point(0, Math.max(0, Math.min(tpsize.height, p.y)));
                if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                    ep.y = sp.y;
                }
            } else if ((this.orientation & 1) != 0) {
                ep = new Point(tpsize.width, Math.max(0, Math.min(tpsize.height, p.y)));
                if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                    ep.y = sp.y;
                }
            } else if ((this.orientation & 8) != 0) {
                ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), 0);
                if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                    ep.x = sp.x;
                }
            } else if ((this.orientation & 4) != 0) {
                ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), tpsize.height);
                if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                    ep.x = sp.x;
                }
            } else {
                ep = new Point(p);
            }
        } else {
            Point sp = new Point(this.relationship.getPkTable().getLocation());
            this.translatePoint(sp, this.pkConnectionPoint);
            sp.x -= this.relationship.getFkTable().getX();
            sp.y -= this.relationship.getFkTable().getY();
            if ((this.orientation & 0x20) != 0) {
                ep = new Point(0, Math.max(0, Math.min(tpsize.height, p.y)));
                if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                    ep.y = sp.y;
                }
            } else if ((this.orientation & 0x10) != 0) {
                ep = new Point(tpsize.width, Math.max(0, Math.min(tpsize.height, p.y)));
                if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                    ep.y = sp.y;
                }
            } else if ((this.orientation & 0x80) != 0) {
                ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), 0);
                if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                    ep.x = sp.x;
                }
            } else if ((this.orientation & 0x40) != 0) {
                ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), tpsize.height);
                if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                    ep.x = sp.x;
                }
            } else {
                ep = new Point(p);
            }
        }
        return ep;
    }

    protected void translatePoint(Point modify, Point noModify) {
        modify.x += noModify.x;
        modify.y += noModify.y;
    }

    protected int getFacingEdges(Rectangle pktBounds, Rectangle fktBounds) {
        Line2D.Double intersectionLine = this.calcConnectionPoints(pktBounds, fktBounds);
        Point2D.Double pkIntersectPt = new Point2D.Double(intersectionLine.x1, intersectionLine.y1);
        Point2D.Double fkIntersectPt = new Point2D.Double(intersectionLine.x2, intersectionLine.y2);
        return this.getFacingEdges(pktBounds, fktBounds, pkIntersectPt, fkIntersectPt);
    }

    protected int getFacingEdges(Rectangle pktBounds, Rectangle fktBounds, Point2D.Double pkIntersectPt, Point2D.Double fkIntersectPt) {
        int retval = 0;
        if (pkIntersectPt.x == (double)pktBounds.x) {
            retval |= 2;
        } else if (pkIntersectPt.y == (double)pktBounds.y) {
            retval |= 8;
        } else if (pkIntersectPt.x == (double)(pktBounds.x + pktBounds.width)) {
            retval |= 1;
        } else if (pkIntersectPt.y == (double)(pktBounds.y + pktBounds.height)) {
            retval |= 4;
        } else {
            logger.error((Object)String.format("Unrecognised pktable orientation. pt=(%f,%f); bounds=(%d,%d %dx%d)", pkIntersectPt.x, pkIntersectPt.y, pktBounds.x, pktBounds.y, pktBounds.width, pktBounds.height));
        }
        if (fkIntersectPt.x == (double)fktBounds.x) {
            retval |= 0x20;
        } else if (fkIntersectPt.y == (double)fktBounds.y) {
            retval |= 0x80;
        } else if (fkIntersectPt.x == (double)(fktBounds.x + fktBounds.width)) {
            retval |= 0x10;
        } else if (fkIntersectPt.y == (double)(fktBounds.y + fktBounds.height)) {
            retval |= 0x40;
        } else {
            logger.error((Object)String.format("Unrecognised fktable orientation. pt=(%f,%f); bounds=(%d,%d %dx%d)", fkIntersectPt.x, fkIntersectPt.y, fktBounds.x, fktBounds.y, fktBounds.width, fktBounds.height));
        }
        return retval;
    }

    public int getTerminationLength() {
        return 5;
    }

    public int getTerminationWidth() {
        return 5;
    }

    public Stroke getIdentifyingStroke() {
        return this.idStroke;
    }

    public Stroke getNonIdentifyingStroke() {
        return this.nonIdStroke;
    }

    public boolean isOrientationLegal() {
        boolean answer;
        if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
            answer = this.orientation == 36;
        } else {
            boolean bl = answer = this.orientation == this.getFacingEdges(this.relationship.pkTable.getBounds(), this.relationship.fkTable.getBounds());
        }
        if (!answer) {
            logger.debug((Object)"\u001b[31misOrientationLegal() returning false\u001b[0m");
        }
        return answer;
    }

    protected Rectangle computeBounds() {
        TablePane pkTable = this.relationship.pkTable;
        TablePane fkTable = this.relationship.fkTable;
        if (!this.isOrientationLegal()) {
            this.bestConnectionPoints();
        }
        if (pkTable == fkTable) {
            Point topLeft = new Point(this.fkConnectionPoint.x - this.getTerminationLength() * 2 - this.radius, this.fkConnectionPoint.y - this.getTerminationWidth());
            Point bottomRight = new Point(this.pkConnectionPoint.x + this.getTerminationWidth(), this.pkConnectionPoint.y + this.radius + this.getTerminationLength() * 2);
            this.computedBounds = new Rectangle(topLeft.x + pkTable.getX(), topLeft.y + pkTable.getY(), bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        } else {
            Point pkLimits = new Point(this.pkConnectionPoint);
            pkLimits.translate(pkTable.getX(), pkTable.getY());
            Point fkLimits = new Point(this.fkConnectionPoint);
            fkLimits.translate(fkTable.getX(), fkTable.getY());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Absolute connection points: pk=" + pkLimits + "; fk=" + fkLimits));
            }
            if ((this.orientation & 3) != 0) {
                pkLimits.y = pkLimits.y >= fkLimits.y ? (pkLimits.y += this.getTerminationWidth()) : (pkLimits.y -= this.getTerminationWidth());
            } else {
                pkLimits.x = pkLimits.x >= fkLimits.x ? (pkLimits.x += this.getTerminationWidth()) : (pkLimits.x -= this.getTerminationWidth());
            }
            if ((this.orientation & 0x30) != 0) {
                fkLimits.y = fkLimits.y <= this.pkConnectionPoint.y + pkTable.getY() ? (fkLimits.y -= this.getTerminationWidth()) : (fkLimits.y += this.getTerminationWidth());
            } else {
                fkLimits.x = fkLimits.x <= this.pkConnectionPoint.x + pkTable.getX() ? (fkLimits.x -= this.getTerminationWidth()) : (fkLimits.x += this.getTerminationWidth());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Limits: pk=" + pkLimits + "; fk=" + fkLimits));
            }
            Point topLeft = new Point(Math.min(pkLimits.x, fkLimits.x), Math.min(pkLimits.y, fkLimits.y));
            Point bottomRight = new Point(Math.max(pkLimits.x, fkLimits.x), Math.max(pkLimits.y, fkLimits.y));
            this.computedBounds = new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating bounds to " + this.computedBounds + " (topleft=" + topLeft + "; bottomRight=" + bottomRight + ")"));
            }
        }
        return this.computedBounds;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.relationship);
    }

    public Dimension getPreferredSize(PlayPenComponent c) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u001b[31mComputed size is [" + this.computedBounds.width + "," + this.computedBounds.height + "]\u001b[0m"));
        }
        return new Dimension(this.computedBounds.width, this.computedBounds.height);
    }

    @Override
    public Point getPreferredLocation() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u001b[31mComputed locn is [" + this.computedBounds.x + "," + this.computedBounds.y + "]\u001b[0m"));
        }
        return new Point(this.computedBounds.x, this.computedBounds.y);
    }

    @Override
    public boolean isOverPkDecoration(Point p) {
        Point pkDec = new Point(this.pkConnectionPoint.x + this.relationship.pkTable.getX() - this.relationship.getX(), this.pkConnectionPoint.y + this.relationship.pkTable.getY() - this.relationship.getY());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p=" + p + "; pkDec = " + pkDec + "; width=" + this.relationship.getWidth() + "; height=" + this.relationship.getHeight() + "; orientation=" + this.orientation));
        }
        if ((this.orientation & 0xC) != 0) {
            if (p.x < pkDec.x + 5 && p.x > pkDec.x - 5) {
                if ((this.orientation & 4) != 0) {
                    if ((this.orientation & 0x30) != 0) {
                        return p.y >= pkDec.y && p.y < this.relationship.getHeight();
                    }
                    return p.y >= pkDec.y && p.y < pkDec.y + this.relationship.getHeight() / 2;
                }
                if ((this.orientation & 0x30) != 0) {
                    return p.y <= pkDec.y && p.y > pkDec.y - this.relationship.getHeight();
                }
                return p.y <= pkDec.y && p.y > pkDec.y - this.relationship.getHeight() / 2;
            }
            return false;
        }
        if ((this.orientation & 2 | 1) != 0) {
            if (p.y < pkDec.y + 5 && p.y > pkDec.y - 5) {
                if ((this.orientation & 2) != 0) {
                    if ((this.orientation & 0xC0) != 0) {
                        return p.x <= pkDec.x && p.x >= pkDec.x - this.relationship.getWidth();
                    }
                    return p.x <= pkDec.x && p.x >= pkDec.x - this.relationship.getWidth() / 2;
                }
                if ((this.orientation & 0xC0) != 0) {
                    return p.x >= pkDec.x && p.x <= pkDec.x + this.relationship.getWidth();
                }
                return p.x >= pkDec.x && p.x <= pkDec.x + this.relationship.getWidth() / 2;
            }
            return false;
        }
        return ASUtils.distance(p, pkDec) < (double)Math.max(this.getTerminationWidth(), this.getTerminationLength());
    }

    @Override
    public boolean isOverFkDecoration(Point p) {
        Point fkDec = new Point(this.fkConnectionPoint.x + this.relationship.fkTable.getX() - this.relationship.getX(), this.fkConnectionPoint.y + this.relationship.fkTable.getY() - this.relationship.getY());
        if ((this.orientation & 0xC0) != 0) {
            if (p.x < fkDec.x + 5 && p.x > fkDec.x - 5) {
                if ((this.orientation & 0x40) != 0) {
                    if ((this.orientation & 3) != 0) {
                        return p.y >= fkDec.y && p.y < fkDec.y + this.relationship.getHeight();
                    }
                    return p.y >= fkDec.y && p.y < fkDec.y + this.relationship.getHeight() / 2;
                }
                if ((this.orientation & 3) != 0) {
                    return p.y <= fkDec.y && p.y > fkDec.y - this.relationship.getHeight();
                }
                return p.y <= fkDec.y && p.y > fkDec.y - this.relationship.getHeight() / 2;
            }
            return false;
        }
        if ((this.orientation & 0x20 | 0x10) != 0) {
            if (p.y < fkDec.y + 5 && p.y > fkDec.y - 5) {
                if ((this.orientation & 0x20) != 0) {
                    if ((this.orientation & 0xC) != 0) {
                        return p.x <= fkDec.x && p.x >= fkDec.x - this.relationship.getWidth();
                    }
                    return p.x <= fkDec.x && p.x >= fkDec.x - this.relationship.getWidth() / 2;
                }
                if ((this.orientation & 0xC) != 0) {
                    return p.x >= fkDec.x && p.x <= fkDec.x + this.relationship.getWidth();
                }
                return p.x >= fkDec.x && p.x <= fkDec.x + this.relationship.getWidth() / 2;
            }
            return false;
        }
        return ASUtils.distance(p, fkDec) < (double)Math.max(this.getTerminationWidth(), this.getTerminationLength());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        logger.debug((Object)("BasicRelationshipUI notices change of " + e.getPropertyName() + " from " + e.getOldValue() + " to " + e.getNewValue() + " on " + e.getSource()));
    }

    @Override
    public boolean intersectsShape(Shape s) {
        List<Point2D.Double> list;
        Rectangle myBounds = this.path.getBounds();
        Rectangle otherBounds = s.getBounds();
        if (myBounds.width == 0) {
            myBounds.width = 1;
        }
        if (myBounds.height == 0) {
            myBounds.height = 1;
        }
        if (otherBounds.width == 0) {
            otherBounds.width = 1;
        }
        if (otherBounds.height == 0) {
            otherBounds.height = 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("intersectsShape: my rectangle = " + myBounds));
            logger.debug((Object)("              other rectangle = " + otherBounds));
            logger.debug((Object)("intersectsShape: rectangles overlap? " + myBounds.intersects(otherBounds)));
        }
        if (!myBounds.intersects(otherBounds)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   myPI = " + this.pathIteratorToString(this.path.getPathIterator(null))));
            logger.debug((Object)("otherPI = " + this.pathIteratorToString(s.getPathIterator(null))));
        }
        return (list = this.getIntersectPoints(s)).size() > 0;
    }

    private List<Point2D.Double> getIntersectPoints(Shape s) {
        return ASUtils.getIntersectPoints(this.getShape(), s);
    }

    private String pathIteratorToString(PathIterator pathIterator) {
        StringBuffer sb = new StringBuffer();
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            sb.append("Type: " + type + "; coords: ");
            int i = 0;
            while (i < coords.length) {
                sb.append(coords[i]).append(',');
                ++i;
            }
            sb.append('\n');
            pathIterator.next();
        }
        return sb.toString();
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public int getShapeLength() {
        Rectangle b = this.path.getBounds();
        return b.width + b.height;
    }
}

