/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.BrowserUtil;
import ca.sqlpower.architect.ConfigFile;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.etl.ExportCSV;
import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.layout.FruchtermanReingoldForceLayout;
import ca.sqlpower.architect.qfa.ExceptionHandler;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.MappingReport;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.RecentMenu;
import ca.sqlpower.architect.swingui.SwingUIProject;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.WelcomeScreen;
import ca.sqlpower.architect.swingui.action.AboutAction;
import ca.sqlpower.architect.swingui.action.AutoLayoutAction;
import ca.sqlpower.architect.swingui.action.CompareDMAction;
import ca.sqlpower.architect.swingui.action.CreateRelationshipAction;
import ca.sqlpower.architect.swingui.action.CreateTableAction;
import ca.sqlpower.architect.swingui.action.DataMoverAction;
import ca.sqlpower.architect.swingui.action.DeleteSelectedAction;
import ca.sqlpower.architect.swingui.action.EditColumnAction;
import ca.sqlpower.architect.swingui.action.EditRelationshipAction;
import ca.sqlpower.architect.swingui.action.EditTableAction;
import ca.sqlpower.architect.swingui.action.ExportDDLAction;
import ca.sqlpower.architect.swingui.action.ExportPLJobXMLAction;
import ca.sqlpower.architect.swingui.action.ExportPLTransAction;
import ca.sqlpower.architect.swingui.action.HelpAction;
import ca.sqlpower.architect.swingui.action.InsertColumnAction;
import ca.sqlpower.architect.swingui.action.PreferencesAction;
import ca.sqlpower.architect.swingui.action.PrintAction;
import ca.sqlpower.architect.swingui.action.ProfilePanelAction;
import ca.sqlpower.architect.swingui.action.ProjectSettingsAction;
import ca.sqlpower.architect.swingui.action.QuickStartAction;
import ca.sqlpower.architect.swingui.action.RedoAction;
import ca.sqlpower.architect.swingui.action.SQLRunnerAction;
import ca.sqlpower.architect.swingui.action.SearchReplaceAction;
import ca.sqlpower.architect.swingui.action.SelectAllAction;
import ca.sqlpower.architect.swingui.action.UndoAction;
import ca.sqlpower.architect.swingui.action.ViewProfileAction;
import ca.sqlpower.architect.swingui.action.ZoomAction;
import ca.sqlpower.architect.undo.UndoManager;
import com.darwinsys.util.PrefsUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArchitectFrame
extends JFrame {
    private static Logger logger = Logger.getLogger(ArchitectFrame.class);
    protected static ArchitectFrame mainInstance;
    static final String FORUM_URL = "http://www.sqlpower.ca/forum/";
    static final String DRIVERS_URL = "http://www.sqlpower.ca/forum/posts/list/401.page";
    public static final boolean MAC_OS_X;
    public static final double ZOOM_STEP = 0.25;
    protected final Preferences prefs;
    private boolean lastSaveOpSuccessful;
    protected ArchitectSession architectSession = null;
    protected SwingUIProject project = null;
    protected ConfigFile configFile = null;
    protected UserSettings sprefs = null;
    protected JToolBar projectBar = null;
    protected JToolBar ppBar = null;
    protected JMenuBar menuBar = null;
    protected JSplitPane splitPane = null;
    protected PlayPen playpen = null;
    protected DBTree dbTree = null;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private JMenu connectionsMenu;
    private RecentMenu recent;
    protected AboutAction aboutAction;
    protected Action newProjectAction;
    protected Action openProjectAction;
    protected Action saveProjectAction;
    protected Action saveProjectAsAction;
    protected PreferencesAction prefAction;
    protected ProjectSettingsAction projectSettingsAction;
    protected PrintAction printAction;
    protected ProfilePanelAction profileAction;
    protected ViewProfileAction viewProfileAction;
    protected ZoomAction zoomInAction;
    protected ZoomAction zoomOutAction;
    protected Action zoomNormalAction;
    protected Action zoomAllAction;
    protected JComponent contentPane;
    private AutoLayoutAction autoLayoutAction;
    private ArchitectLayout autoLayout;
    protected EditColumnAction editColumnAction;
    protected InsertColumnAction insertColumnAction;
    protected EditTableAction editTableAction;
    protected DeleteSelectedAction deleteSelectedAction;
    protected CreateTableAction createTableAction;
    protected CreateRelationshipAction createIdentifyingRelationshipAction;
    protected CreateRelationshipAction createNonIdentifyingRelationshipAction;
    protected EditRelationshipAction editRelationshipAction;
    protected SearchReplaceAction searchReplaceAction;
    protected SelectAllAction selectAllAction;
    protected Action exportDDLAction;
    protected Action compareDMAction;
    protected Action dataMoverAction;
    protected ExportPLTransAction exportPLTransAction;
    protected ExportPLJobXMLAction exportPLJobXMLAction;
    protected QuickStartAction quickStartAction;
    protected ArchitectFrameWindowListener afWindowListener;
    protected Action exitAction = new AbstractAction("Exit"){

        public void actionPerformed(ActionEvent e) {
            ArchitectFrame.this.exit();
        }
    };
    protected static Action forumAction;
    protected Action saveSettingsAction = new AbstractAction("Save User Preferences"){

        public void actionPerformed(ActionEvent e) {
            try {
                ArchitectFrame.this.saveSettings();
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't save settings", (Throwable)ex);
            }
        }
    };

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        forumAction = new AbstractAction("Support on the Web", ASUtils.createJLFIcon("development/WebComponent", "New Project", 16)){

            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserUtil.launch(ArchitectFrame.FORUM_URL);
                }
                catch (IOException e) {
                    ASUtils.showExceptionDialog("Could not launch browser for Forum View", e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchitectFrame() throws ArchitectException {
        Class<ArchitectFrame> clazz = ArchitectFrame.class;
        synchronized (ArchitectFrame.class) {
            mainInstance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setIconImage(ASUtils.getFrameIconImage());
            this.setDefaultCloseOperation(0);
            this.architectSession = ArchitectSessionImpl.getInstance();
            this.prefs = PrefsUtils.getUserPrefsNode((Object)this.architectSession);
            this.init();
            return;
        }
    }

    protected boolean promptForUnsavedModifications() {
        if (this.project.isModified()) {
            int response = JOptionPane.showOptionDialog(this, "Your project has unsaved changes", "Unsaved Changes", 1, 3, null, new Object[]{"Don't Save", "Cancel", "Save"}, "Save");
            if (response == 0) {
                return true;
            }
            if (response == -1 || response == 1) {
                return false;
            }
            return this.saveOrSaveAs(false, false);
        }
        return true;
    }

    private void init() throws ArchitectException {
        int accelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.contentPane = (JComponent)this.getContentPane();
        ConfigFile cf = ConfigFile.getDefaultInstance();
        CoreUserSettings us = cf.read(this.getArchitectSession());
        this.architectSession.setUserSettings(us);
        this.sprefs = this.architectSession.getUserSettings().getSwingSettings();
        while (!us.isPlDotIniPathValid()) {
            File newPlIniFile;
            Object[] options = new String[]{"Browse", "Create"};
            String message = us.getPlDotIniPath() == null ? "location is not set" : (new File(us.getPlDotIniPath()).isFile() ? "file \n\n\"" + us.getPlDotIniPath() + "\"\n\n could not be read" : "file \n\n\"" + us.getPlDotIniPath() + "\"\n\n does not exist");
            int choice = JOptionPane.showOptionDialog(null, "The Architect keeps its list of database connections\nin a file called PL.INI.  Your PL.INI " + message + "." + "\n\nYou can browse for an existing PL.INI file on your system" + "\nor allow the Architect to create a new one in your home directory." + "\n\nHint: If you are a Power*Loader Suite user, you should browse for" + "\nan existing PL.INI in your Power*Loader installation directory.", "Missing PL.INI", 0, 1, null, options, null);
            if (choice == -1) {
                throw new ArchitectException("Can't start without a pl.ini file");
            }
            if (choice == 0) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(ASUtils.INI_FILE_FILTER);
                fc.setDialogTitle("Locate your PL.INI file");
                int fcChoice = fc.showOpenDialog(null);
                newPlIniFile = fcChoice == 0 ? fc.getSelectedFile() : null;
            } else if (choice == 1) {
                newPlIniFile = new File(System.getProperty("user.home"), "pl.ini");
            } else {
                throw new ArchitectException("Unexpected return from JOptionPane.showOptionDialog to get pl.ini");
            }
            if (newPlIniFile == null) continue;
            try {
                newPlIniFile.createNewFile();
                us.setPlDotIniPath(newPlIniFile.getPath());
            }
            catch (IOException e1) {
                logger.error((Object)("Caught IO exception while creating empty PL.INI at \"" + newPlIniFile.getPath() + "\""), (Throwable)e1);
                JOptionPane.showMessageDialog(null, "Failed to create file \"" + newPlIniFile.getPath() + "\":\n" + e1.getMessage(), "Error", 0);
            }
        }
        this.aboutAction = new AboutAction();
        HelpAction helpAction = new HelpAction();
        this.newProjectAction = new AbstractAction("New Project", ASUtils.createJLFIcon("general/New", "New Project", this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24))){

            public void actionPerformed(ActionEvent e) {
                if (ArchitectFrame.this.promptForUnsavedModifications()) {
                    try {
                        ArchitectFrame.this.prefs.putInt("SwingUserSettings.DIVIDER_LOCATION", ArchitectFrame.this.splitPane.getDividerLocation());
                        ArchitectFrame.this.closeProject(ArchitectFrame.this.getProject());
                        ArchitectFrame.this.setProject(new SwingUIProject("New Project"), false);
                        logger.debug((Object)("Glass pane is " + ArchitectFrame.this.getGlassPane()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ArchitectFrame.this, "Can't create new project: " + ex.getMessage());
                        logger.error((Object)"Got exception while creating new project", (Throwable)ex);
                    }
                }
            }
        };
        this.newProjectAction.putValue("ShortDescription", "New");
        this.newProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, accelMask));
        this.recent = new RecentMenu(this){

            public void loadFile(String fileName) throws IOException {
                File f = new File(fileName);
                try {
                    LoadFileWorker worker = new LoadFileWorker(f, null);
                    new Thread(worker).start();
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(ArchitectFrame.this, "File not found: " + f.getPath());
                }
                catch (Exception e1) {
                    ASUtils.showExceptionDialog("Error loading file", e1);
                }
            }
        };
        this.openProjectAction = new OpenProjectAction(this.recent);
        this.saveProjectAction = new AbstractAction("Save Project", ASUtils.createJLFIcon("general/Save", "Save Project", this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24))){

            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.saveOrSaveAs(false, true);
            }
        };
        this.saveProjectAction.putValue("ShortDescription", "Save");
        this.saveProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, accelMask));
        this.saveProjectAsAction = new AbstractAction("Save Project As...", ASUtils.createJLFIcon("general/SaveAs", "Save Project As...", this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24))){

            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.saveOrSaveAs(true, true);
            }
        };
        this.saveProjectAsAction.putValue("ShortDescription", "Save As");
        this.prefAction = new PreferencesAction();
        this.projectSettingsAction = new ProjectSettingsAction();
        this.projectSettingsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(44, accelMask));
        this.printAction = new PrintAction();
        this.printAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, accelMask));
        this.zoomInAction = new ZoomAction(0.25);
        this.zoomOutAction = new ZoomAction(-0.25);
        this.zoomNormalAction = new AbstractAction("Reset Zoom", ASUtils.createJLFIcon("general/Zoom", "Reset Zoom", this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24))){

            public void actionPerformed(ActionEvent e) {
                ArchitectFrame.this.playpen.setZoom(1.0);
            }
        };
        this.zoomNormalAction.putValue("ShortDescription", "Reset Zoom");
        this.zoomAllAction = new AbstractAction("Zoom to fit", ASUtils.createJLFIcon("general/Zoom", "Reset Zoom", this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24))){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = null;
                if (ArchitectFrame.this.playpen != null) {
                    int i = 0;
                    while (i < ArchitectFrame.this.playpen.getContentPane().getComponentCount()) {
                        PlayPenComponent ppc = ArchitectFrame.this.playpen.getContentPane().getComponent(i);
                        if (rect == null) {
                            rect = new Rectangle(ppc.getLocation(), ppc.getSize());
                        } else {
                            rect.add(ppc.getBounds());
                        }
                        ++i;
                    }
                }
                if (rect == null) {
                    return;
                }
                double zoom = Math.min(ArchitectFrame.this.playpen.getViewportSize().getHeight() / (double)rect.height, ArchitectFrame.this.playpen.getViewportSize().getWidth() / (double)rect.width);
                ArchitectFrame.this.playpen.setZoom(zoom *= 0.9);
                ArchitectFrame.this.playpen.scrollRectToVisible(ArchitectFrame.this.playpen.zoomRect(rect));
            }
        };
        this.zoomAllAction.putValue("ShortDescription", "Zoom to fit");
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.autoLayoutAction = new AutoLayoutAction();
        this.autoLayout = new FruchtermanReingoldForceLayout();
        this.autoLayoutAction.setLayout(this.autoLayout);
        this.exportDDLAction = new ExportDDLAction();
        this.compareDMAction = new CompareDMAction();
        this.dataMoverAction = new DataMoverAction(this, this.getArchitectSession());
        this.exportPLTransAction = new ExportPLTransAction(this){

            public void actionPerformed(ActionEvent e) {
                try {
                    this.setExportingTables(ArchitectFrame.this.getProject().getTargetDatabase().getTables());
                    super.actionPerformed(e);
                }
                catch (ArchitectException ex) {
                    ASUtils.showExceptionDialog("Error Creating List of Tables to Export", ex);
                }
            }
        };
        this.exportPLJobXMLAction = new ExportPLJobXMLAction();
        this.quickStartAction = new QuickStartAction();
        AbstractAction exportCSVAction = new AbstractAction("Export CSV File"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ExportCSV export = new ExportCSV(ArchitectFrame.this.getProject().getPlayPen().getDatabase().getTables());
                    File file = null;
                    JFileChooser fileDialog = new JFileChooser();
                    fileDialog.setSelectedFile(new File("map.csv"));
                    if (fileDialog.showSaveDialog(ArchitectFrame.getMainInstance()) != 0) {
                        return;
                    }
                    file = fileDialog.getSelectedFile();
                    FileWriter output = null;
                    output = new FileWriter(file);
                    output.write(export.getCSVMapping());
                    output.flush();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                catch (ArchitectException e1) {
                    throw new ArchitectRuntimeException(e1);
                }
            }
        };
        AbstractAction mappingReportAction = new AbstractAction("Visual Mapping Report"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<SQLTable> selectedTables;
                    if (ArchitectFrame.this.playpen.getSelectedTables().size() == 0) {
                        selectedTables = new ArrayList<SQLTable>(ArchitectFrame.this.playpen.getTables());
                    } else if (JOptionPane.showConfirmDialog(ArchitectFrame.getMainInstance(), "View only the " + ArchitectFrame.this.playpen.getSelectedTables().size() + " selected tables", "Show Mapping", 0) == 0) {
                        selectedTables = new ArrayList();
                        for (TablePane tp : ArchitectFrame.this.playpen.getSelectedTables()) {
                            selectedTables.add(tp.getModel());
                        }
                    } else {
                        selectedTables = new ArrayList<SQLTable>(ArchitectFrame.this.playpen.getTables());
                    }
                    final MappingReport mr = new MappingReport(selectedTables);
                    final JFrame f = new JFrame("Mapping Report");
                    f.setIconImage(ASUtils.getFrameIconImage());
                    JPanel mrPanel = new JPanel(){

                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            try {
                                mr.drawHighLevelReport((Graphics2D)g, null);
                            }
                            catch (ArchitectException e1) {
                                logger.error((Object)"ArchitectException while generating mapping diagram", (Throwable)e1);
                                ASUtils.showExceptionDialog("Couldn't generate mapping diagram", e1);
                            }
                        }
                    };
                    mrPanel.setDoubleBuffered(true);
                    mrPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    mrPanel.setPreferredSize(mr.getRequiredSize());
                    mrPanel.setOpaque(true);
                    mrPanel.setBackground(Color.WHITE);
                    ButtonBarBuilder buttonBar = new ButtonBarBuilder();
                    JButton csv = new JButton(new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                ExportCSV export = new ExportCSV(selectedTables);
                                File file = null;
                                JFileChooser fileDialog = new JFileChooser();
                                fileDialog.setSelectedFile(new File("map.csv"));
                                if (fileDialog.showSaveDialog(f) != 0) {
                                    return;
                                }
                                file = fileDialog.getSelectedFile();
                                FileWriter output = null;
                                output = new FileWriter(file);
                                output.write(export.getCSVMapping());
                                output.flush();
                            }
                            catch (IOException e1) {
                                throw new RuntimeException(e1);
                            }
                            catch (ArchitectException e1) {
                                throw new ArchitectRuntimeException(e1);
                            }
                        }
                    });
                    csv.setText("Export CSV");
                    buttonBar.addGriddedGrowing((JComponent)csv);
                    ExportPLTransAction plTransaction = new ExportPLTransAction(f);
                    JButton pl = new JButton(plTransaction);
                    plTransaction.setExportingTables(selectedTables);
                    pl.setText("Export PL Transaction");
                    buttonBar.addRelatedGap();
                    buttonBar.addGriddedGrowing((JComponent)pl);
                    JButton close = new JButton(new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            f.dispose();
                        }
                    });
                    close.setText("Close");
                    buttonBar.addRelatedGap();
                    buttonBar.addGriddedGrowing((JComponent)close);
                    JPanel basePane = new JPanel(new BorderLayout(5, 5));
                    basePane.add((Component)new JScrollPane(mrPanel), "Center");
                    basePane.add((Component)buttonBar.getPanel(), "South");
                    f.setContentPane(basePane);
                    f.pack();
                    f.setLocationRelativeTo(ArchitectFrame.getMainInstance());
                    f.setVisible(true);
                }
                catch (ArchitectException e1) {
                    throw new ArchitectRuntimeException(e1);
                }
            }
        };
        this.deleteSelectedAction = new DeleteSelectedAction();
        this.createIdentifyingRelationshipAction = new CreateRelationshipAction(true);
        this.createNonIdentifyingRelationshipAction = new CreateRelationshipAction(false);
        this.editRelationshipAction = new EditRelationshipAction();
        this.createTableAction = new CreateTableAction();
        this.editColumnAction = new EditColumnAction();
        this.insertColumnAction = new InsertColumnAction();
        this.editTableAction = new EditTableAction();
        this.searchReplaceAction = new SearchReplaceAction();
        this.searchReplaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, accelMask));
        this.selectAllAction = new SelectAllAction();
        this.selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, accelMask));
        this.profileAction = new ProfilePanelAction();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        fileMenu.add(this.newProjectAction);
        fileMenu.add(this.openProjectAction);
        fileMenu.add(this.recent);
        fileMenu.addSeparator();
        fileMenu.add(this.saveProjectAction);
        fileMenu.add(this.saveProjectAsAction);
        fileMenu.add(this.printAction);
        fileMenu.addSeparator();
        if (!MAC_OS_X) {
            fileMenu.add(this.prefAction);
        }
        fileMenu.add(this.saveSettingsAction);
        fileMenu.add(this.projectSettingsAction);
        if (!MAC_OS_X) {
            fileMenu.addSeparator();
            fileMenu.add(this.exitAction);
        }
        this.menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('e');
        editMenu.add(this.undoAction);
        editMenu.add(this.redoAction);
        editMenu.addSeparator();
        editMenu.add(this.selectAllAction);
        editMenu.addSeparator();
        editMenu.add(this.searchReplaceAction);
        this.menuBar.add(editMenu);
        this.connectionsMenu = new JMenu("Connections");
        this.connectionsMenu.setMnemonic('c');
        this.menuBar.add(this.connectionsMenu);
        JMenu etlMenu = new JMenu("ETL");
        etlMenu.setMnemonic('l');
        JMenu etlSubmenuOne = new JMenu("Power*Loader");
        etlSubmenuOne.add(this.exportPLTransAction);
        etlSubmenuOne.add(this.exportPLJobXMLAction);
        etlSubmenuOne.add(this.quickStartAction);
        etlMenu.add(etlSubmenuOne);
        etlMenu.add(exportCSVAction);
        etlMenu.add(mappingReportAction);
        this.menuBar.add(etlMenu);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic('t');
        toolsMenu.add(this.exportDDLAction);
        toolsMenu.add(this.compareDMAction);
        toolsMenu.add(new SQLRunnerAction(ArchitectFrame.getMainInstance()));
        this.menuBar.add(toolsMenu);
        JMenu profileMenu = new JMenu("Profile");
        profileMenu.setMnemonic('p');
        profileMenu.add(this.profileAction);
        this.menuBar.add(profileMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('h');
        if (!MAC_OS_X) {
            helpMenu.add(this.aboutAction);
            helpMenu.addSeparator();
        }
        helpMenu.add(helpAction);
        helpMenu.add(forumAction);
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
        this.projectBar = new JToolBar(0);
        this.ppBar = new JToolBar(1);
        this.projectBar.add(this.newProjectAction);
        this.projectBar.add(this.openProjectAction);
        this.projectBar.add(this.saveProjectAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.printAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.undoAction);
        this.projectBar.add(this.redoAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.exportDDLAction);
        this.projectBar.add(this.compareDMAction);
        this.projectBar.addSeparator();
        this.projectBar.add(this.autoLayoutAction);
        this.projectBar.add(this.profileAction);
        this.projectBar.addSeparator();
        this.projectBar.add(helpAction);
        this.projectBar.setToolTipText("Project Toolbar");
        this.projectBar.setName("Project Toolbar");
        JButton tempButton = null;
        this.ppBar.setToolTipText("PlayPen Toolbar");
        this.ppBar.setName("PlayPen ToolBar");
        this.ppBar.add(this.zoomInAction);
        this.ppBar.add(this.zoomOutAction);
        this.ppBar.add(this.zoomNormalAction);
        this.ppBar.add(this.zoomAllAction);
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.deleteSelectedAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.createTableAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        tempButton = this.ppBar.add(this.insertColumnAction);
        tempButton.setActionCommand("PlayPen");
        tempButton = this.ppBar.add(this.editColumnAction);
        tempButton.setActionCommand("PlayPen");
        this.ppBar.addSeparator();
        this.ppBar.add(this.createNonIdentifyingRelationshipAction);
        this.ppBar.add(this.createIdentifyingRelationshipAction);
        tempButton = this.ppBar.add(this.editRelationshipAction);
        tempButton.setActionCommand("PlayPen");
        Container projectBarPane = this.getContentPane();
        projectBarPane.setLayout(new BorderLayout());
        projectBarPane.add((Component)this.projectBar, "North");
        JPanel cp = new JPanel(new BorderLayout());
        cp.add((Component)this.ppBar, "East");
        projectBarPane.add((Component)cp, "Center");
        this.splitPane = new JSplitPane(1);
        cp.add((Component)this.splitPane, "Center");
        logger.debug((Object)"Added splitpane to content pane");
        this.splitPane.setDividerLocation(this.prefs.getInt("SwingUserSettings.DIVIDER_LOCATION", 150));
        Rectangle bounds = new Rectangle();
        bounds.x = this.prefs.getInt("SwingUserSettings.MAIN_FRAME_X", 40);
        bounds.y = this.prefs.getInt("SwingUserSettings.MAIN_FRAME_Y", 40);
        bounds.width = this.prefs.getInt("SwingUserSettings.MAIN_FRAME_WIDTH", 600);
        bounds.height = this.prefs.getInt("SwingUserSettings.MAIN_FRAME_HEIGHT", 440);
        this.setBounds(bounds);
        this.afWindowListener = new ArchitectFrameWindowListener();
        this.addWindowListener(this.afWindowListener);
        this.getUserSettings().getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", this.prefs.getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true));
        this.setProject(new SwingUIProject("New Project"), true);
    }

    public void setProject(SwingUIProject p, boolean showWelcome) throws ArchitectException {
        this.project = p;
        logger.debug((Object)("Setting project to " + this.project));
        this.setTitle(String.valueOf(this.project.getName()) + " - Power*Architect");
        this.playpen = this.project.getPlayPen();
        this.dbTree = this.project.getSourceDatabases();
        this.setupActions();
        this.setupConnectionsMenu();
        this.splitPane.setLeftComponent(new JScrollPane(this.dbTree));
        this.splitPane.setRightComponent(new JScrollPane(this.playpen));
        if (showWelcome && this.getUserSettings().getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true)) {
            JComponent welcomePanel = WelcomeScreen.getPanel();
            final JDialog d = new JDialog((Frame)this, "Welcome to the Power*Architect");
            d.setLayout(new BorderLayout(12, 12));
            ((JComponent)d.getContentPane()).setBorder(Borders.DIALOG_BORDER);
            final JCheckBox showPrefsAgain = new JCheckBox("Show this Welcome Screen in future");
            showPrefsAgain.setSelected(true);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArchitectFrame.this.getUserSettings().getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", showPrefsAgain.isSelected());
                    d.dispose();
                }
            });
            d.add((Component)welcomePanel, "Center");
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BorderLayout());
            bottomPanel.add((Component)showPrefsAgain, "West");
            bottomPanel.add((Component)closeButton, "East");
            d.add((Component)bottomPanel, "South");
            d.getRootPane().setDefaultButton(closeButton);
            d.pack();
            d.setLocationRelativeTo(this);
            d.setVisible(true);
        }
        this.splitPane.setDividerLocation(this.prefs.getInt("SwingUserSettings.DIVIDER_LOCATION", 150));
    }

    public SwingUIProject getProject() {
        return this.project;
    }

    protected void setupConnectionsMenu() {
        this.connectionsMenu.removeAll();
        this.dbTree.refreshMenu(null);
        this.connectionsMenu.add(this.dbTree.connectionsMenu);
        this.connectionsMenu.add(new JMenuItem(this.dbTree.dbcsPropertiesAction));
        this.connectionsMenu.add(new JMenuItem(this.dbTree.removeDBCSAction));
    }

    protected void setupActions() throws ArchitectException {
        this.aboutAction.setPlayPen(this.playpen);
        this.printAction.setPlayPen(this.playpen);
        this.deleteSelectedAction.setPlayPen(this.playpen);
        this.editColumnAction.setPlayPen(this.playpen);
        this.insertColumnAction.setPlayPen(this.playpen);
        this.editTableAction.setPlayPen(this.playpen);
        this.searchReplaceAction.setPlayPen(this.playpen);
        this.selectAllAction.setPlayPen(this.playpen);
        this.createTableAction.setPlayPen(this.playpen);
        this.createIdentifyingRelationshipAction.setPlayPen(this.playpen);
        this.createNonIdentifyingRelationshipAction.setPlayPen(this.playpen);
        this.editRelationshipAction.setPlayPen(this.playpen);
        this.exportPLTransAction.setExportingTables(this.playpen.getTables());
        this.exportPLJobXMLAction.setPlayPen(this.playpen);
        this.zoomInAction.setPlayPen(this.playpen);
        this.zoomOutAction.setPlayPen(this.playpen);
        this.autoLayoutAction.setPlayPen(this.playpen);
        this.undoAction.setManager(this.project.getUndoManager());
        this.redoAction.setManager(this.project.getUndoManager());
        this.editColumnAction.setDBTree(this.dbTree);
        this.insertColumnAction.setDBTree(this.dbTree);
        this.editRelationshipAction.setDBTree(this.dbTree);
        this.deleteSelectedAction.setDBTree(this.dbTree);
        this.editTableAction.setDBTree(this.dbTree);
        this.searchReplaceAction.setDBTree(this.dbTree);
        this.profileAction.setDBTree(this.dbTree);
        this.profileAction.setProfileManager(this.project.getProfileManager());
        this.profileAction.setDialog(this.project.getProfileDialog());
        this.prefAction.setArchitectFrame(this);
        this.projectSettingsAction.setArchitectFrame(this);
    }

    public static synchronized ArchitectFrame getMainInstance() {
        if (mainInstance == null) {
            try {
                new ArchitectFrame();
            }
            catch (ArchitectException e) {
                throw new RuntimeException("Couldn't create ArchitectFrame instance!");
            }
        }
        return mainInstance;
    }

    public CoreUserSettings getUserSettings() {
        return this.architectSession.getUserSettings();
    }

    public ArchitectSession getArchitectSession() {
        return this.architectSession;
    }

    public boolean createRelationshipIsActive() {
        if (this.createIdentifyingRelationshipAction.isActive()) {
            return true;
        }
        return this.createNonIdentifyingRelationshipAction.isActive();
    }

    public void saveSettings() throws ArchitectException {
        if (this.configFile == null) {
            this.configFile = ConfigFile.getDefaultInstance();
        }
        CoreUserSettings us = this.getUserSettings();
        this.prefs.putInt("SwingUserSettings.DIVIDER_LOCATION", this.splitPane.getDividerLocation());
        this.prefs.putInt("SwingUserSettings.MAIN_FRAME_X", this.getLocation().x);
        this.prefs.putInt("SwingUserSettings.MAIN_FRAME_Y", this.getLocation().y);
        this.prefs.putInt("SwingUserSettings.MAIN_FRAME_WIDTH", this.getWidth());
        this.prefs.putInt("SwingUserSettings.MAIN_FRAME_HEIGHT", this.getHeight());
        this.prefs.putBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", us.getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true));
        this.configFile.write(this.getArchitectSession());
        try {
            us.getPlDotIni().write(new File(us.getPlDotIniPath()));
        }
        catch (IOException e) {
            logger.error((Object)"Couldn't save PL.INI file!", (Throwable)e);
        }
    }

    public void exit() {
        if (this.getProject().isSaveInProgress()) {
            JOptionPane.showMessageDialog(this, "Project is saving, cannot exit the Power Architect.  Please wait for the save to finish, and then try again.", "Warning", 2);
            return;
        }
        if (this.promptForUnsavedModifications()) {
            try {
                this.closeProject(this.getProject());
                this.saveSettings();
            }
            catch (ArchitectException e) {
                logger.error((Object)("Couldn't save settings: " + e));
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws ArchitectException {
        File openFile;
        ArchitectUtils.startup();
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ArchitectUtils.configureLog4j();
        String architectFileArg = null;
        if (args.length > 0) {
            architectFileArg = args[0];
            openFile = new File(architectFileArg);
        } else {
            openFile = null;
        }
        ArchitectFrame.getMainInstance();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
                logger.debug((Object)("current motion threshold is: " + System.getProperty("awt.dnd.drag.threshold")));
                System.setProperty("awt.dnd.drag.threshold", "10");
                logger.debug((Object)("new motion threshold is: " + System.getProperty("awt.dnd.drag.threshold")));
                ArchitectFrame.getMainInstance().macOSXRegistration();
                ArchitectFrame.getMainInstance().setVisible(true);
                if (openFile != null) {
                    try {
                        ArchitectFrame architectFrame = ArchitectFrame.getMainInstance();
                        architectFrame.getClass();
                        LoadFileWorker worker = architectFrame.new LoadFileWorker(openFile, ArchitectFrame.getMainInstance().recent);
                        new Thread(worker).start();
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(ArchitectFrame.getMainInstance(), "File not found: " + openFile.getPath());
                    }
                    catch (Exception e1) {
                        ASUtils.showExceptionDialog("Error loading file", e1);
                    }
                }
            }
        });
    }

    private void macOSXRegistration() {
        if (MAC_OS_X) {
            try {
                Method prefsEnableMethod;
                Class<?> osxAdapter = ClassLoader.getSystemClassLoader().loadClass("ca.sqlpower.architect.swingui.OSXAdapter");
                Class[] defArgs = new Class[]{Action.class, Action.class, Action.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this.exitAction, this.prefAction, this.aboutAction};
                    registerMethod.invoke(osxAdapter, args);
                }
                if ((prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs = new Class[]{Boolean.TYPE})) != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public boolean saveOrSaveAs(boolean showChooser, boolean separateThread) {
        if (this.project.getFile() == null || showChooser) {
            JFileChooser chooser = new JFileChooser(this.project.getFile());
            chooser.addChoosableFileFilter(ASUtils.ARCHITECT_FILE_FILTER);
            int response = chooser.showSaveDialog(this);
            if (response != 0) {
                return false;
            }
            File file = chooser.getSelectedFile();
            if (!file.getPath().endsWith(".architect")) {
                file = new File(String.valueOf(file.getPath()) + ".architect");
            }
            if (file.exists() && (response = JOptionPane.showConfirmDialog(this, "The file\n\n" + file.getPath() + "\n\nalready exists. Do you want to overwrite it?", "File Exists", 0)) == 1) {
                return this.saveOrSaveAs(true, separateThread);
            }
            this.project.setFile(file);
            String projName = file.getName().substring(0, file.getName().length() - ".architect".length());
            this.project.setName(projName);
            this.setTitle(projName);
        }
        final boolean finalSeparateThread = separateThread;
        final ProgressMonitor pm = new ProgressMonitor(this, "Saving Project", "", 0, 100);
        Runnable saveTask = new Runnable(){

            public void run() {
                try {
                    try {
                        ArchitectFrame.this.lastSaveOpSuccessful = false;
                        ArchitectFrame.this.project.setSaveInProgress(true);
                        ArchitectFrame.this.project.save(finalSeparateThread ? pm : null);
                        ArchitectFrame.this.lastSaveOpSuccessful = true;
                        JOptionPane.showMessageDialog(ArchitectFrame.this, "Save successful");
                    }
                    catch (Exception ex) {
                        ArchitectFrame.this.lastSaveOpSuccessful = false;
                        JOptionPane.showMessageDialog(ArchitectFrame.this, "Can't save project: " + ex.getMessage());
                        logger.error((Object)"Got exception while saving project", (Throwable)ex);
                    }
                }
                finally {
                    ArchitectFrame.this.project.setSaveInProgress(false);
                }
            }
        };
        if (separateThread) {
            new Thread(saveTask).start();
            return true;
        }
        saveTask.run();
        return this.lastSaveOpSuccessful;
    }

    protected void closeProject(SwingUIProject project) {
        for (SQLDatabase db : project.getSourceDatabases().getDatabaseList()) {
            logger.debug((Object)("closing connection: " + db.getName()));
            db.disconnect();
        }
    }

    public AutoLayoutAction getAutoLayoutAction() {
        return this.autoLayoutAction;
    }

    public JToolBar getProjectToolBar() {
        return this.projectBar;
    }

    public JToolBar getPlayPenToolBar() {
        return this.ppBar;
    }

    public UndoManager getUndoManager() {
        return this.getProject().getUndoManager();
    }

    public UserSettings getSwingUserSettings() {
        return this.sprefs;
    }

    public UserSettings getSprefs() {
        return this.sprefs;
    }

    public void setSprefs(UserSettings sprefs) {
        this.sprefs = sprefs;
    }

    public Action getNewProjectAction() {
        return this.newProjectAction;
    }

    public void setNewProjectAction(Action newProjectAction) {
        this.newProjectAction = newProjectAction;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public ZoomAction getZoomInAction() {
        return this.zoomInAction;
    }

    public ZoomAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    private class LoadFileWorker
    extends ArchitectSwingWorker {
        InputStream in;
        SwingUIProject project;
        File file;
        RecentMenu recent;

        public LoadFileWorker(File file, RecentMenu recent) throws ArchitectException, FileNotFoundException {
            ArchitectFrame.this.closeProject(ArchitectFrame.this.getProject());
            this.project = new SwingUIProject("Loading...");
            this.project.setFile(file);
            this.file = file;
            this.recent = recent;
            this.in = new BufferedInputStream(new ProgressMonitorInputStream(ArchitectFrame.this, "Reading " + file.getName(), new FileInputStream(file)));
        }

        public void doStuff() throws IOException, ArchitectException {
            this.project.load(this.in);
            if (this.recent != null) {
                this.recent.putRecentFileName(this.file.getAbsolutePath());
            }
        }

        public void cleanup() throws ArchitectException {
            ArchitectFrame.this.setProject(this.project, false);
            ((SQLObject)this.project.getSourceDatabases().getModel().getRoot()).fireDbStructureChanged();
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"got exception while closing project file", (Throwable)ie);
            }
        }
    }

    private class OpenProjectAction
    extends AbstractAction {
        RecentMenu recent;

        private OpenProjectAction(RecentMenu recent) {
            super("Open Project...", ASUtils.createJLFIcon("general/Open", "Open Project", ArchitectFrame.this.sprefs.getInt("SwingUserSettings.ICON_SIZE", 24)));
            this.recent = recent;
            this.putValue("ShortDescription", "Open");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            if (ArchitectFrame.this.promptForUnsavedModifications()) {
                ArchitectFrame.this.prefs.putInt("SwingUserSettings.DIVIDER_LOCATION", ArchitectFrame.this.splitPane.getDividerLocation());
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(ASUtils.ARCHITECT_FILE_FILTER);
                int returnVal = chooser.showOpenDialog(ArchitectFrame.this);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        LoadFileWorker worker = new LoadFileWorker(f, this.recent);
                        new Thread(worker).start();
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(ArchitectFrame.this, "File not found: " + f.getPath());
                    }
                    catch (Exception e1) {
                        ASUtils.showExceptionDialog("Error loading file", e1);
                    }
                }
            }
        }
    }

    class ArchitectFrameWindowListener
    extends WindowAdapter {
        ArchitectFrameWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            ArchitectFrame.this.exit();
        }
    }
}

