/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.sqlrunner;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.sqlrunner.OutputMode;
import ca.sqlpower.architect.sqlrunner.SQLRunner;
import ca.sqlpower.architect.sqlrunner.Verbosity;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import com.darwinsys.io.TextAreaWriter;
import com.darwinsys.swingui.UtilGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class SQLRunnerGUI {
    private static final int DISPLAY_COLUMNS = 70;
    final Preferences p = Preferences.userNodeForPackage(SQLRunnerGUI.class);
    final JComponent bar = new JComponent(){

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    };
    final JFrame mainWindow = new JFrame("Power*Architect: SQLRunner");
    final JTextArea inputTextArea;
    final JTextArea outputTextArea;
    final JButton runButton;
    final PrintWriter out;

    public SQLRunnerGUI() {
        JPanel controlsArea = new JPanel();
        this.mainWindow.add((Component)controlsArea, "North");
        List<ArchitectDataSource> connections = ArchitectFrame.getMainInstance().getUserSettings().getConnections();
        final JComboBox<ArchitectDataSource> connectionsList = new JComboBox<ArchitectDataSource>(connections.toArray(new ArchitectDataSource[connections.size()]));
        controlsArea.add(new JLabel("Connection"));
        controlsArea.add(connectionsList);
        final JComboBox<String> inTemplateChoice = new JComboBox<String>();
        inTemplateChoice.addItem("Input Template:");
        inTemplateChoice.addItem("SELECT * from TABLE where x = y");
        inTemplateChoice.addItem("INSERT into TABLE(col,col) VALUES(val,val)");
        inTemplateChoice.addItem("UPDATE TABLE set x = y where x = y");
        controlsArea.add(inTemplateChoice);
        JButton inTemplateButton = new JButton("Apply Template");
        controlsArea.add(inTemplateButton);
        final JComboBox<OutputMode> modeList = new JComboBox<OutputMode>();
        OutputMode[] outputModeArray = OutputMode.values();
        int n = 0;
        int n2 = outputModeArray.length;
        while (n < n2) {
            OutputMode mode = outputModeArray[n];
            modeList.addItem(mode);
            ++n;
        }
        controlsArea.add(new JLabel("Output Format:"));
        controlsArea.add(modeList);
        this.runButton = new JButton("Run");
        controlsArea.add(this.runButton);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new Thread(){
                    Connection conn;

                    public void run() {
                        try {
                            try {
                                (this).SQLRunnerGUI.this.runButton.setEnabled(false);
                                ArchitectDataSource ds = (ArchitectDataSource)connectionsList.getSelectedItem();
                                SQLDatabase db = new SQLDatabase(ds);
                                this.conn = db.getConnection();
                                SQLRunner.setVerbosity(Verbosity.QUIET);
                                SQLRunner prog = new SQLRunner(this.conn, null, "t");
                                prog.setOutputFile((this).SQLRunnerGUI.this.out);
                                prog.setOutputMode((OutputMode)((Object)modeList.getSelectedItem()));
                                SQLRunnerGUI.this.setNeutral();
                                prog.runStatement((this).SQLRunnerGUI.this.inputTextArea.getText());
                                SQLRunnerGUI.this.setSuccess();
                            }
                            catch (Exception e) {
                                SQLRunnerGUI.this.setFailure();
                                SQLRunnerGUI.this.error("<html><p>Error: <font color='red'>" + e);
                                e.printStackTrace();
                            }
                        }
                        finally {
                            if (this.conn != null) {
                                try {
                                    this.conn.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            (this).SQLRunnerGUI.this.runButton.setEnabled(true);
                        }
                    }
                }.start();
            }
        });
        this.inputTextArea = new JTextArea(6, 70);
        JScrollPane inputAreaScrollPane = new JScrollPane(this.inputTextArea);
        inputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("SQL Command"));
        this.setNeutral();
        this.outputTextArea = new JTextArea(20, 70);
        JScrollPane outputAreaScrollPane = new JScrollPane(this.outputTextArea);
        outputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("SQL Results"));
        inTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (inTemplateChoice.getSelectedIndex() == 0) {
                    return;
                }
                SQLRunnerGUI.this.inputTextArea.setText((String)inTemplateChoice.getSelectedItem());
            }
        });
        JButton clearOutput = new JButton("Clear Output");
        clearOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SQLRunnerGUI.this.outputTextArea.setText("");
                SQLRunnerGUI.this.setNeutral();
            }
        });
        controlsArea.add(clearOutput);
        this.mainWindow.add((Component)new JSplitPane(0, inputAreaScrollPane, outputAreaScrollPane), "Center");
        this.mainWindow.add((Component)this.bar, "South");
        this.out = new PrintWriter((Writer)new TextAreaWriter(this.outputTextArea));
        this.bar.setPreferredSize(new Dimension(400, 20));
        this.mainWindow.pack();
        UtilGUI.centre((Window)this.mainWindow);
        this.mainWindow.setVisible(true);
    }

    void setSuccess() {
        this.bar.setBackground(Color.GREEN);
        this.bar.repaint();
    }

    void setFailure() {
        this.bar.setBackground(Color.RED);
        this.bar.repaint();
    }

    void setNeutral() {
        this.bar.setBackground(this.mainWindow.getBackground());
        this.bar.repaint();
    }

    void error(String mesg) {
        this.setFailure();
        JOptionPane.showMessageDialog(this.mainWindow, mesg, "Oops", 0);
    }
}

