/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.sqlrunner;

import ca.sqlpower.architect.sqlrunner.ResultsDecorator;
import ca.sqlpower.architect.sqlrunner.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.WebRowSet;

public class ResultsDecoratorXML
extends ResultsDecorator {
    private static final String SUN_WEBROWSET_IMPL_CLASS = "com.sun.rowset.WebRowSetImpl";
    WebRowSet results;

    public ResultsDecoratorXML(PrintWriter out, Verbosity v) {
        super(out, v);
        try {
            Class<?> c = Class.forName(SUN_WEBROWSET_IMPL_CLASS);
            this.results = (WebRowSet)c.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("can't load com.sun.rowset.WebRowSetImpl, check CLASSPATH");
        }
    }

    public int write(ResultSet rs) throws SQLException {
        this.results.writeXml(rs, this.out);
        return this.results.getRow();
    }

    public void printRowCount(int rowCount) throws IOException {
        System.err.println("RowCount: " + rowCount);
    }

    public String getName() {
        return "XML";
    }
}

