/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.layout.FruchtermanReingoldForceLayout;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Point;
import java.awt.Rectangle;
import junit.framework.TestCase;

public class TestFruchtermanReingoldForceLayout
extends TestCase {
    private PlayPen pp;
    private TablePane tp;
    private SQLTable table1;
    private SQLDatabase db;
    private Rectangle frame;
    private FruchtermanReingoldForceLayout layout;

    public void setUp() throws ArchitectException {
        this.db = new SQLDatabase();
        this.pp = new PlayPen();
        this.table1 = new SQLTable(this.db, true);
        this.tp = new TablePane(this.table1, this.pp);
        this.pp.addTablePane(this.tp, new Point(10, 10));
        this.layout = new FruchtermanReingoldForceLayout();
        this.frame = new Rectangle(new Point(), this.layout.getNewArea(this.pp.getTablePanes()));
    }

    public void testMagnitude() {
        TestFruchtermanReingoldForceLayout.assertEquals((String)"Incorrect magnitude", (Object)5.0, (Object)this.layout.magnitude(new Point(3, 4)));
        TestFruchtermanReingoldForceLayout.assertEquals((String)"Incorrect magnitude", (Object)13.0, (Object)this.layout.magnitude(new Point(12, 5)));
    }

    public void testIsDoneNoElem() {
        PlayPen p = new PlayPen();
        this.layout.setup(p.getTablePanes(), p.getRelationships(), this.frame);
        TestFruchtermanReingoldForceLayout.assertTrue((boolean)this.layout.isDone());
    }

    public void testIsDoneOneElem() {
        this.layout.setup(this.pp.getTablePanes(), this.pp.getRelationships(), this.frame);
        TestFruchtermanReingoldForceLayout.assertTrue((boolean)this.layout.isDone());
    }

    public void testDone() throws ArchitectException {
        SQLTable sqlTable2 = new SQLTable(this.db, true);
        TablePane t2 = new TablePane(sqlTable2, this.pp);
        this.pp.addTablePane(t2, new Point(23, 243));
        this.layout.setup(this.pp.getTablePanes(), this.pp.getRelationships(), this.frame);
        TestFruchtermanReingoldForceLayout.assertFalse((boolean)this.layout.isDone());
        this.layout.done();
        TestFruchtermanReingoldForceLayout.assertTrue((boolean)this.layout.isDone());
    }
}

