/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.antbuild;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AddLicenseToDMGTask
extends Task {
    private File hdiutilExecutable = new File("/usr/bin/hdiutil");
    private File rezExecutable = new File("/Developer/Tools/Rez");
    private File licenseFile;
    private File dmgFile;
    private File resourceTemplateFile;
    boolean debug = false;

    public void execute() throws BuildException {
        if (!this.rezExecutable.exists()) {
            throw new BuildException("Rez executable not found at \"" + this.rezExecutable.getPath() + "\". " + "You need to install the OS X Developer Tools.");
        }
        File tempFile = null;
        try {
            try {
                this.execv(this.hdiutilExecutable.getPath(), "unflatten", this.dmgFile.getPath());
                tempFile = File.createTempFile("dmgLicenseResource", "tmp");
                if (this.debug) {
                    System.out.println("Temporary file path: " + tempFile.getPath());
                }
                this.execv("cp", this.resourceTemplateFile.getPath(), tempFile.getPath());
                this.appendLicenseToTemplate(tempFile);
                this.execv(this.rezExecutable.getPath(), "-a", tempFile.getPath(), "-o", this.dmgFile.getPath());
                this.execv(this.hdiutilExecutable.getPath(), "flatten", this.dmgFile.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (tempFile != null && !this.debug) {
                tempFile.delete();
            }
        }
    }

    public void setDmgFile(File dmgFile) {
        this.dmgFile = dmgFile;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setRezExecutable(File rezExecutable) {
        this.rezExecutable = rezExecutable;
    }

    public void setResourceTemplateFile(File resourceTemplateFile) {
        this.resourceTemplateFile = resourceTemplateFile;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void execv(String ... args) throws IOException {
        StringBuilder command = new StringBuilder();
        String[] stringArray = args;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String arg = stringArray[n];
            command.append(" \"").append(arg).append("\"");
            ++n;
        }
        if (this.debug) {
            System.out.println("Executing:" + command);
        }
        long startTime = System.currentTimeMillis();
        Process proc = Runtime.getRuntime().exec(args);
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            System.out.println("Warning: interrupted during proc.wait()");
        }
        int exitVal = proc.exitValue();
        if (this.debug) {
            long finshTime = System.currentTimeMillis();
            System.out.println("Completed in " + (finshTime - startTime) + "ms with exit code " + exitVal);
        }
        if (exitVal != 0) {
            throw new RuntimeException("Command failed with exit code " + exitVal + ":" + command);
        }
    }

    private void appendLicenseToTemplate(File outFile) throws IOException {
        int nextByte;
        PrintWriter out = new PrintWriter(new FileWriter(outFile, true));
        FileReader in = new FileReader(this.licenseFile);
        out.println("data 'TEXT' (5000, \"English SLA\") {");
        int count = 0;
        while ((nextByte = ((Reader)in).read()) >= 0) {
            if (count % 16 == 0) {
                out.print("        $\"");
            }
            out.format("%02X", nextByte & 0xFF);
            if (++count % 16 == 0) {
                out.println("\"");
                continue;
            }
            if (count % 2 != 0) continue;
            out.print(" ");
        }
        if (count % 16 != 0) {
            out.println("\"");
        }
        out.println("};");
        out.flush();
        out.close();
    }
}

