/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import ca.sqlpower.architect.TestSQLColumn;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSQLDatabase
extends SQLTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestSQLDatabase.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TestSQLDatabase.oneTimeSetUp();
            }

            protected void tearDown() throws Exception {
                TestSQLDatabase.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    public static void oneTimeSetUp() throws Exception {
        System.out.println("TestSQLDatabase.oneTimeSetUp()");
        SQLDatabase mydb = new SQLDatabase(TestSQLDatabase.getDataSource());
        Connection con = null;
        Statement stmt = null;
        try {
            con = mydb.getConnection();
            stmt = con.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE REGRESSION_TEST1");
                stmt.executeUpdate("DROP TABLE REGRESSION_TEST2");
            }
            catch (SQLException sqle) {
                System.out.println("+++ TestSQLDatabase exception should be for dropping a non-existant table");
                sqle.printStackTrace();
            }
            stmt.executeUpdate("CREATE TABLE REGRESSION_TEST1 (t1_c1 numeric(10))");
            stmt.executeUpdate("CREATE TABLE REGRESSION_TEST2 (t2_c1 char(10))");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close statement");
                ex.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close connection");
                ex.printStackTrace();
            }
            mydb.disconnect();
        }
    }

    public static void oneTimeTearDown() {
        System.out.println("TestSQLDatabase.oneTimeTearDown()");
    }

    public TestSQLDatabase(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.db;
    }

    public void testGetName() {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLDatabase.assertEquals((String)"PlayPen Database", (String)db1.getName());
        TestSQLDatabase.assertEquals((String)"PlayPen Database", (String)db1.getShortDisplayName());
        TestSQLDatabase.assertEquals((String)db1.getName(), (String)db1.getPhysicalName());
        TestSQLDatabase.assertEquals((String)this.db.getName(), (String)this.db.getDataSource().getDisplayName());
        TestSQLDatabase.assertEquals((String)this.db.getDataSource().getDisplayName(), (String)this.db.getShortDisplayName());
        TestSQLDatabase.assertEquals((String)this.db.getName(), (String)this.db.getPhysicalName());
    }

    public void testGetParent() {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLDatabase.assertNull((Object)db1.getParent());
        TestSQLDatabase.assertNull((Object)this.db.getParent());
    }

    public void testGoodConnect() throws ArchitectException, SQLException {
        TestSQLDatabase.assertFalse((String)"db shouldn't have been connected yet", (boolean)this.db.isConnected());
        Connection con = this.db.getConnection();
        TestSQLDatabase.assertNotNull((String)"db gave back a null connection", (Object)con);
        TestSQLDatabase.assertTrue((String)"db should have said it is connected", (boolean)this.db.isConnected());
        con.close();
    }

    public void testPopulate() throws ArchitectException, SQLException {
        Connection con = this.db.getConnection();
        TestSQLDatabase.assertFalse((String)"even though connected, should not be populated yet", (boolean)this.db.isPopulated());
        this.db.populate();
        TestSQLDatabase.assertTrue((String)"should be populated now", (boolean)this.db.isPopulated());
        this.db.populate();
        con.close();
    }

    public void testAllowsChildren() {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLDatabase.assertTrue((boolean)db1.allowsChildren());
        TestSQLDatabase.assertTrue((boolean)this.db.allowsChildren());
    }

    public void testGetTableByName() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        TestSQLDatabase.assertNotNull((Object)table1);
        TestSQLDatabase.assertNotNull((Object)this.db.getTableByName("REGRESSION_TEST2"));
        TestSQLDatabase.assertNull((String)"should get null for nonexistant table", (Object)this.db.getTableByName("no_such_table"));
        SQLTable table3 = new SQLTable(this.db, "xyz", "", "TABLE", true);
        SQLCatalog cat1 = null;
        SQLSchema sch1 = null;
        if (this.db.isCatalogContainer()) {
            cat1 = new SQLCatalog(this.db, "cat1");
            cat1.addChild(table3);
            this.db.addChild(cat1);
        } else if (this.db.isSchemaContainer()) {
            sch1 = new SQLSchema(this.db, "sch1", true);
            sch1.addChild(table3);
            this.db.addChild(sch1);
        } else {
            this.db.addChild(table3);
        }
        table1 = this.db.getTableByName(table3.getName());
        TestSQLDatabase.assertEquals((Object)table1, (Object)table3);
        table1 = null;
        table1 = cat1 != null ? this.db.getTableByName(cat1.getName(), null, table3.getName()) : (sch1 != null ? this.db.getTableByName(null, sch1.getName(), table3.getName()) : this.db.getTableByName(null, null, table3.getName()));
        TestSQLDatabase.assertNotNull((Object)table1);
        TestSQLDatabase.assertEquals((Object)table1, (Object)table3);
    }

    public void testGetTables() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        TestSQLDatabase.assertNotNull((Object)table1);
        SQLTable table2 = this.db.getTableByName("REGRESSION_TEST2");
        TestSQLDatabase.assertNotNull((Object)table2);
        TestSQLDatabase.assertNull((String)"should get null for nonexistant table", (Object)this.db.getTableByName("no_such_table"));
        SQLTable table3 = new SQLTable(this.db, "xyz", "", "TABLE", true);
        SQLCatalog cat1 = null;
        SQLSchema sch1 = null;
        if (this.db.isCatalogContainer()) {
            cat1 = new SQLCatalog(this.db, "cat1");
            cat1.addChild(table3);
            this.db.addChild(cat1);
        } else if (this.db.isSchemaContainer()) {
            sch1 = new SQLSchema(this.db, "sch1", true);
            sch1.addChild(table3);
            this.db.addChild(sch1);
        } else {
            this.db.addChild(table3);
        }
        List getTablesTest = this.db.getTables();
        TestSQLDatabase.assertTrue((boolean)getTablesTest.contains(table1));
        TestSQLDatabase.assertTrue((boolean)getTablesTest.contains(table2));
        TestSQLDatabase.assertTrue((boolean)getTablesTest.contains(table3));
    }

    public void testGetDataSource() {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLDatabase.assertNull((Object)db1.getDataSource());
        ArchitectDataSource data = this.db.getDataSource();
        db1.setDataSource(data);
        TestSQLDatabase.assertEquals((Object)this.db.getDataSource(), (Object)db1.getDataSource());
        db1 = new SQLDatabase(data);
        TestSQLDatabase.assertEquals((Object)this.db.getDataSource(), (Object)db1.getDataSource());
    }

    public void testGetSchemaByName() throws Exception {
        SQLDatabase db1;
        this.db.populate();
        if (this.db.isSchemaContainer()) {
            SQLSchema s = new SQLSchema(this.db, "a schema name should not exist in database", true);
            this.db.addChild(s);
            this.db.addChild(new SQLSchema(true));
            this.db.addChild(new SQLSchema(false));
            TestSQLDatabase.assertEquals((Object)this.db.getSchemaByName("a schema name should not exist in database"), (Object)s);
            TestSQLDatabase.assertNull((Object)this.db.getSchemaByName("a schema name should not exist in database xx2"));
        }
        if ((db1 = new SQLDatabase()).isSchemaContainer()) {
            SQLSchema s = new SQLSchema(db1, "a schema name should not exist in database", true);
            db1.addChild(s);
            db1.addChild(new SQLSchema(true));
            db1.addChild(new SQLSchema(false));
            TestSQLDatabase.assertEquals((Object)db1.getSchemaByName("a schema name should not exist in database"), (Object)s);
            TestSQLDatabase.assertNull((Object)db1.getSchemaByName("a schema name should not exist in database xx2"));
        }
    }

    public void testGetCatalogByName() throws Exception {
        SQLCatalog cat;
        block3: {
            cat = new SQLCatalog(this.db, "a catalog name should not exist in database");
            try {
                this.db.populate();
                this.db.addChild(cat);
                TestSQLDatabase.assertEquals((Object)this.db.getCatalogByName("a catalog name should not exist in database"), (Object)cat);
                TestSQLDatabase.assertNull((Object)this.db.getCatalogByName("a catalog name should not exist in database xx2"));
            }
            catch (ArchitectException e) {
                if (!this.db.isCatalogContainer()) break block3;
                throw e;
            }
        }
        SQLDatabase db1 = new SQLDatabase();
        if (db1.isCatalogContainer()) {
            db1.addChild(cat);
            TestSQLDatabase.assertEquals((Object)db1.getCatalogByName("a catalog name should not exist in database"), (Object)cat);
            TestSQLDatabase.assertNull((Object)db1.getCatalogByName("a catalog name should not exist in database xx2"));
        }
    }

    public void testIsPlayPen() throws ArchitectException {
        this.db.getChild(0);
        this.db.setPlayPenDatabase(true);
        TestSQLDatabase.assertTrue((boolean)this.db.isPlayPenDatabase());
        this.db.setDataSource(this.db.getDataSource());
        TestSQLDatabase.assertTrue((boolean)this.db.isPopulated());
        this.db.setPlayPenDatabase(false);
        TestSQLDatabase.assertFalse((boolean)this.db.isPlayPenDatabase());
        this.db.setDataSource(this.db.getDataSource());
        TestSQLDatabase.assertFalse((boolean)this.db.isPopulated());
    }

    public void testReset() throws ArchitectException {
        SQLDatabase db1 = new SQLDatabase();
        db1.setDataSource(this.db.getDataSource());
        db1.setDataSource(this.db.getDataSource());
        TestSQLDatabase.assertFalse((boolean)db1.isPopulated());
        TestSQLDatabase.assertFalse((boolean)db1.isConnected());
    }

    public void testGetChild() throws ArchitectException {
        SQLDatabase db1 = new SQLDatabase();
        SQLTable t1 = new SQLTable(db1, "t1", "", "TABLE", true);
        SQLTable t2 = new SQLTable(db1, "t2", "", "TABLE", true);
        SQLTable t3 = new SQLTable(db1, "t3", "", "TABLE", true);
        db1.addChild(t1);
        db1.addChild(1, t2);
        TestSQLDatabase.assertEquals((Object)db1.getChild(0), (Object)t1);
        TestSQLDatabase.assertEquals((Object)db1.getChild(1), (Object)t2);
        db1.addChild(0, t3);
        TestSQLDatabase.assertEquals((Object)db1.getChild(1), (Object)t1);
        TestSQLDatabase.assertEquals((Object)db1.getChild(0), (Object)t3);
        db1.removeChild(1);
        TestSQLDatabase.assertEquals((Object)db1.getChild(1), (Object)t2);
        db1.removeChild(t3);
        TestSQLDatabase.assertEquals((Object)db1.getChild(0), (Object)t2);
    }

    public void testGetSQLObjectListeners() throws ArchitectException {
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        TestSQLColumn.TestSQLObjectListener test2 = new TestSQLColumn.TestSQLObjectListener();
        SQLDatabase s1 = new SQLDatabase();
        s1.addSQLObjectListener(test1);
        s1.addSQLObjectListener(test2);
        TestSQLDatabase.assertEquals((Object)s1.getSQLObjectListeners().get(0), (Object)test1);
        TestSQLDatabase.assertEquals((Object)s1.getSQLObjectListeners().get(1), (Object)test2);
        int i = 0;
        while (i < 5) {
            s1.addChild(new SQLTable(s1, "", "", "TABLE", true));
            ++i;
        }
        TestSQLDatabase.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLDatabase.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLDatabase.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        s1.removeSQLObjectListener(test2);
        i = 0;
        while (i < 5) {
            s1.removeChild(0);
            ++i;
        }
        TestSQLDatabase.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLDatabase.assertEquals((int)test1.getRemovedCount(), (int)5);
        TestSQLDatabase.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLDatabase.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)s1.getSQLObjectListeners().size(), (int)1);
    }

    public void testGetProgressMonitor() throws ArchitectException {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLDatabase.assertNotNull((Object)db1.getProgressMonitor());
        TestSQLDatabase.assertNotNull((Object)this.db.getProgressMonitor());
    }

    public void testFireDbChildrenInserted() throws ArchitectException {
        SQLDatabase db1 = new SQLDatabase();
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        db1.addSQLObjectListener(test1);
        TestSQLDatabase.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        db1.setDataSource(this.db.getDataSource());
        db1.setPopulated(false);
        db1.populate();
        TestSQLDatabase.assertEquals((int)test1.getInsertedCount(), (int)1);
        TestSQLDatabase.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLDatabase.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLDatabase.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        db1.setDataSource(new ArchitectDataSource());
        TestSQLDatabase.assertEquals((int)test1.getInsertedCount(), (int)1);
        TestSQLDatabase.assertEquals((int)test1.getRemovedCount(), (int)1);
        TestSQLDatabase.assertEquals((int)test1.getChangedCount(), (int)2);
        TestSQLDatabase.assertEquals((int)test1.getStructureChangedCount(), (int)0);
    }

    public void testDisconnect() throws ArchitectException {
        TestSQLDatabase.assertNotNull((Object)this.db.getChild(0));
        TestSQLDatabase.assertTrue((boolean)this.db.isConnected());
        this.db.disconnect();
        TestSQLDatabase.assertFalse((boolean)this.db.isConnected());
    }

    public void testReconnect() throws ArchitectException, SQLException {
        TestSQLDatabase.assertNotNull((Object)this.db.getChild(0));
        this.db.setDataSource(this.db.getDataSource());
        TestSQLDatabase.assertFalse((String)"db shouldn't be connected anymore", (boolean)this.db.isConnected());
        TestSQLDatabase.assertFalse((String)"db shouldn't be populated anymore", (boolean)this.db.isPopulated());
        TestSQLDatabase.assertNotNull((Object)this.db.getChild(1));
        TestSQLDatabase.assertTrue((String)"db should be repopulated", (boolean)this.db.isPopulated());
        TestSQLDatabase.assertTrue((String)"db should be reconnected", (boolean)this.db.isConnected());
        Connection con = this.db.getConnection();
        TestSQLDatabase.assertNotNull((String)"db should be reconnected", (Object)con);
        con.close();
    }

    public void testMissingDriverConnect() throws SQLException {
        ArchitectDataSource ds = this.db.getDataSource();
        ds.setDriverClass("ca.sqlpower.xxx.does.not.exist");
        SQLDatabase mydb = new SQLDatabase(ds);
        Connection con = null;
        ArchitectException exc = null;
        try {
            TestSQLDatabase.assertFalse((String)"db shouldn't have been connected yet", (boolean)this.db.isConnected());
            con = mydb.getConnection();
        }
        catch (ArchitectException e) {
            exc = e;
        }
        TestSQLDatabase.assertNotNull((String)"should have got an ArchitectException", (Object)exc);
        if (con != null) {
            con.close();
        }
        TestSQLDatabase.assertNull((String)"connection should be null", (Object)con);
    }

    public void testBadURLConnect() throws Exception {
        ArchitectDataSource ds = this.db.getDataSource();
        ds.setUrl("jdbc:bad:moo");
        SQLDatabase mydb = new SQLDatabase(ds);
        Connection con = null;
        ArchitectException exc = null;
        try {
            TestSQLDatabase.assertFalse((String)"db shouldn't have been connected yet", (boolean)this.db.isConnected());
            con = mydb.getConnection();
        }
        catch (ArchitectException e) {
            exc = e;
        }
        TestSQLDatabase.assertNotNull((String)"should have got an ArchitectException", (Object)exc);
        if (con != null) {
            con.close();
        }
        TestSQLDatabase.assertNull((String)"connection should be null", (Object)con);
    }

    public void testBadPasswordConnect() throws SQLException {
        ArchitectDataSource ds = this.db.getDataSource();
        ds.setPass("foofoofoofoofooSDFGHJK");
        SQLDatabase mydb = new SQLDatabase(ds);
        Connection con = null;
        ArchitectException exc = null;
        try {
            TestSQLDatabase.assertFalse((String)"db shouldn't have been connected yet", (boolean)this.db.isConnected());
            con = mydb.getConnection();
        }
        catch (ArchitectException e) {
            exc = e;
        }
        TestSQLDatabase.assertNotNull((String)"should have got an ArchitectException", (Object)exc);
        if (con != null) {
            con.close();
        }
        TestSQLDatabase.assertNull((String)"connection should be null", (Object)con);
    }

    public void testPropertyChange() throws Exception {
        PropertyChangeEvent e;
        try {
            e = new PropertyChangeEvent(null, null, "1", "2");
            TestSQLDatabase.fail((String)("Property change event didn't reject null source;" + e));
        }
        catch (IllegalArgumentException ile) {
            System.out.println("Caught expected exception.");
        }
        e = new PropertyChangeEvent((Object)this, null, "1", "2");
        this.db.propertyChange(e);
    }

    public void testUnpopulatedDB() {
        TestSQLDatabase.assertFalse((boolean)this.db.isPopulated());
    }

    public void testAutoPopulate() throws Exception {
        TestSQLDatabase.assertFalse((boolean)this.db.isPopulated());
        SQLObject child = this.db.getChild(0);
        TestSQLDatabase.assertTrue((boolean)this.db.isPopulated());
        TestSQLDatabase.assertFalse((boolean)child.isPopulated());
    }

    public void testConnectionsPerThreadAreUnique() throws Exception {
        ArchitectDataSource ads = new ArchitectDataSource();
        ads.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ads.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&dbmd.schemaTerm=Schema&catalogs=farm,yard,zoo&schemas.farm=cow,pig&schemas.yard=cat,robin&schemas.zoo=lion,giraffe&tables.farm.cow=moo&tables.farm.pig=oink&tables.yard.cat=meow&tables.yard.robin=tweet&tables.zoo.lion=roar&tables.zoo.giraffe=***,^%%");
        ads.setUser("fake");
        ads.setPass("fake");
        ads.setDisplayName("test");
        this.db.setDataSource(ads);
        private class ConnectionGetter
        implements Runnable {
            Connection con;

            ConnectionGetter() {
            }

            public void run() {
                try {
                    this.con = TestSQLDatabase.this.db.getConnection();
                }
                catch (ArchitectException e) {
                    e.printStackTrace();
                }
            }
        }
        ConnectionGetter cg1 = new ConnectionGetter();
        Thread t1 = new Thread(cg1);
        ConnectionGetter cg2 = new ConnectionGetter();
        Thread t2 = new Thread(cg2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (cg1.con == null) {
            TestSQLDatabase.fail((String)"cg1 didn't get a connection");
        }
        if (cg2.con == null) {
            TestSQLDatabase.fail((String)"cg2 didn't get a connection");
        }
        TestSQLDatabase.assertNotSame((String)"Both threads got the same connection!", (Object)cg1.con, (Object)cg2.con);
        cg1.con.close();
        cg2.con.close();
    }
}

