/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import ca.sqlpower.architect.TestSQLColumn;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Iterator;

public class TestSQLCatalog
extends SQLTestCase {
    private SQLCatalog c;

    public TestSQLCatalog(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.c = new SQLCatalog();
        this.c.setPopulated(true);
        this.c.setParent(new SQLDatabase());
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.c;
    }

    public void testGetName() {
        TestSQLCatalog.assertNull((Object)this.c.getName());
        this.c.setName("xxx");
        TestSQLCatalog.assertEquals((String)this.c.getName(), (String)"xxx");
        this.c.setName("yyy");
        TestSQLCatalog.assertEquals((String)this.c.getName(), (String)"yyy");
        TestSQLCatalog.assertEquals((String)this.c.getName(), (String)"yyy");
        TestSQLCatalog.assertEquals((String)this.c.getShortDisplayName(), (String)"yyy");
        TestSQLCatalog.assertEquals((String)this.c.toString(), (String)"yyy");
        SQLDatabase mydb = new SQLDatabase(this.db.getDataSource());
        this.c = new SQLCatalog(mydb, "aaa");
        TestSQLCatalog.assertEquals((String)this.c.getName(), (String)"aaa");
        TestSQLCatalog.assertEquals((String)this.c.getName(), (String)"aaa");
        TestSQLCatalog.assertEquals((String)this.c.getShortDisplayName(), (String)"aaa");
        TestSQLCatalog.assertEquals((String)this.c.toString(), (String)"aaa");
    }

    public void testGetParent() {
        SQLDatabase mydb = new SQLDatabase(this.db.getDataSource());
        this.c = new SQLCatalog(mydb, "aaa");
        TestSQLCatalog.assertEquals((Object)this.c.getParent(), (Object)mydb);
        TestSQLCatalog.assertEquals((Object)this.c.getParentDatabase(), (Object)mydb);
    }

    public void testAllowsChildren() {
        TestSQLCatalog.assertTrue((boolean)this.c.allowsChildren());
        SQLDatabase mydb = new SQLDatabase(this.db.getDataSource());
        this.c = new SQLCatalog(mydb, "aaa");
        TestSQLCatalog.assertTrue((boolean)this.c.allowsChildren());
    }

    public void testIsSchemaContainer() throws Exception {
        TestSQLCatalog.assertTrue((boolean)this.c.isSchemaContainer());
        this.c.addChild(new SQLTable());
        TestSQLCatalog.assertFalse((boolean)this.c.isSchemaContainer());
        this.c = new SQLCatalog();
        this.c.addChild(new SQLSchema(false));
        TestSQLCatalog.assertTrue((boolean)this.c.isSchemaContainer());
    }

    public void testGetNativeTerm() {
        TestSQLCatalog.assertEquals((String)this.c.getNativeTerm(), (String)"catalog");
        this.c.setNativeTerm(null);
        TestSQLCatalog.assertNull((Object)this.c.getNativeTerm());
        this.c.setNativeTerm("AAA");
        TestSQLCatalog.assertEquals((String)this.c.getNativeTerm(), (String)"aaa");
        SQLCatalog c2 = new SQLCatalog(new SQLDatabase(this.db.getDataSource()), "x");
        TestSQLCatalog.assertEquals((String)c2.getNativeTerm(), (String)"catalog");
        c2.setNativeTerm(null);
        TestSQLCatalog.assertNull((Object)c2.getNativeTerm());
        c2.setNativeTerm("AAA");
        TestSQLCatalog.assertEquals((String)c2.getNativeTerm(), (String)"aaa");
    }

    public void testGetPhysicalName() {
        TestSQLCatalog.assertNull((Object)this.c.getPhysicalName());
        this.c.setPhysicalName("aaa");
        TestSQLCatalog.assertEquals((String)this.c.getPhysicalName(), (String)"aaa");
    }

    public void testIsPopulated() throws Exception {
        this.c.setPopulated(true);
        TestSQLCatalog.assertTrue((boolean)this.c.isPopulated());
        this.c.setPopulated(false);
        TestSQLCatalog.assertFalse((boolean)this.c.isPopulated());
        this.c.setPopulated(true);
        this.c.populate();
        this.c.setPopulated(false);
        try {
            this.c.populate();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsPopulateWithCatalogs() throws Exception {
        ArchitectDataSource dataSource = this.db.getDataSource();
        Connection conn = this.db.getConnection();
        DatabaseMetaData meta = conn.getMetaData();
        conn.close();
        conn = null;
        String ct = meta.getCatalogTerm();
        if (ct == null || ct.length() == 0) {
            return;
        }
        SQLCatalog c2 = new SQLCatalog(new SQLDatabase(dataSource), "x");
        c2.setPopulated(false);
        c2.populate();
        TestSQLCatalog.assertTrue((boolean)c2.isPopulated());
        c2.setPopulated(true);
        c2.populate();
        TestSQLCatalog.assertTrue((boolean)c2.isPopulated());
    }

    public void testGetChildren() throws Exception {
        SQLCatalog c2 = new SQLCatalog();
        this.c.setPopulated(true);
        c2.setPopulated(true);
        TestSQLCatalog.assertNotNull((Object)this.c.getChildren());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)0);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)0);
        String[] name = new String[]{"name1", "name2", "name3", "name4", "name5", "name6"};
        int i = 0;
        while (i < 6) {
            SQLTable t = new SQLTable(this.c, name[i], "", "TABLE", true);
            SQLSchema s = new SQLSchema(this.c, name[i], true);
            this.c.addChild(t);
            c2.addChild(i, s);
            ++i;
        }
        TestSQLCatalog.assertNotNull((Object)this.c.getChildren());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)6);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)6);
        TestSQLCatalog.assertNotNull((Object)c2.getChildren());
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)6);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)6);
        Iterator it = this.c.getChildren().iterator();
        Iterator it2 = c2.getChildren().iterator();
        i = 0;
        while (it.hasNext() && it2.hasNext()) {
            SQLObject o = (SQLObject)it.next();
            SQLObject o2 = (SQLObject)it2.next();
            TestSQLCatalog.assertEquals((String)o.getName(), (String)name[i]);
            TestSQLCatalog.assertEquals((String)this.c.getChild(i).getName(), (String)name[i]);
            TestSQLCatalog.assertEquals((String)c2.getChild(i).getName(), (String)name[i]);
            TestSQLCatalog.assertTrue((boolean)(o instanceof SQLTable));
            TestSQLCatalog.assertTrue((boolean)(o2 instanceof SQLSchema));
            ++i;
        }
        this.c.addChild(2, new SQLTable());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)7);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)7);
        TestSQLCatalog.assertTrue((boolean)(this.c.getChild(2) instanceof SQLTable));
        this.c.addChild(new SQLTable());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)8);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)8);
        TestSQLCatalog.assertTrue((boolean)(this.c.getChild(this.c.getChildren().size() - 1) instanceof SQLTable));
        c2.addChild(2, new SQLSchema(true));
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)7);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)7);
        TestSQLCatalog.assertTrue((boolean)(c2.getChild(2) instanceof SQLSchema));
        c2.addChild(new SQLSchema(true));
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)8);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)8);
        TestSQLCatalog.assertTrue((boolean)(c2.getChild(this.c.getChildren().size() - 1) instanceof SQLSchema));
        try {
            this.c.addChild(new SQLSchema(true));
        }
        catch (ArchitectException e) {
            System.out.println("Caught expected exception.");
        }
        try {
            c2.addChild(new SQLTable());
        }
        catch (ArchitectException e) {
            System.out.println("Caught expected exception.");
        }
    }

    public void testAddChild() throws Exception {
        SQLCatalog c2 = new SQLCatalog();
        this.c.setPopulated(true);
        c2.setPopulated(true);
        TestSQLCatalog.assertNotNull((Object)this.c.getChildren());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)0);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)0);
        String[] name = new String[]{"name1", "name2", "name3", "name4", "name5", "name6"};
        int i = 0;
        while (i < 6) {
            SQLTable t = new SQLTable(this.c, name[i], "", "TABLE", true);
            SQLSchema s = new SQLSchema(this.c, name[i], true);
            this.c.addChild(i, t);
            c2.addChild(i, s);
            ++i;
        }
        TestSQLCatalog.assertNotNull((Object)this.c.getChildren());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)6);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)6);
        TestSQLCatalog.assertNotNull((Object)c2.getChildren());
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)6);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)6);
        Iterator it = this.c.getChildren().iterator();
        Iterator it2 = c2.getChildren().iterator();
        i = 0;
        while (it.hasNext() && it2.hasNext()) {
            SQLObject o = (SQLObject)it.next();
            SQLObject o2 = (SQLObject)it2.next();
            TestSQLCatalog.assertEquals((String)o.getName(), (String)name[i]);
            TestSQLCatalog.assertEquals((String)this.c.getChild(i).getName(), (String)name[i]);
            TestSQLCatalog.assertEquals((String)c2.getChild(i).getName(), (String)name[i]);
            TestSQLCatalog.assertTrue((boolean)(o instanceof SQLTable));
            TestSQLCatalog.assertTrue((boolean)(o2 instanceof SQLSchema));
            ++i;
        }
        this.c.addChild(2, new SQLTable());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)7);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)7);
        TestSQLCatalog.assertTrue((boolean)(this.c.getChild(2) instanceof SQLTable));
        this.c.addChild(new SQLTable());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)8);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)8);
        TestSQLCatalog.assertTrue((boolean)(this.c.getChild(this.c.getChildren().size() - 1) instanceof SQLTable));
        c2.addChild(2, new SQLSchema(true));
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)7);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)7);
        TestSQLCatalog.assertTrue((boolean)(c2.getChild(2) instanceof SQLSchema));
        c2.addChild(new SQLSchema(true));
        TestSQLCatalog.assertEquals((int)c2.getChildren().size(), (int)8);
        TestSQLCatalog.assertEquals((int)c2.getChildCount(), (int)8);
        TestSQLCatalog.assertTrue((boolean)(c2.getChild(this.c.getChildren().size() - 1) instanceof SQLSchema));
        try {
            this.c.addChild(new SQLSchema(true));
        }
        catch (ArchitectException e) {
            System.out.println("Caught expected exception.");
        }
        try {
            c2.addChild(new SQLTable());
        }
        catch (ArchitectException e) {
            System.out.println("Caught expected exception.");
        }
    }

    public void testRemoveChild() throws Exception {
        this.c.setPopulated(true);
        TestSQLCatalog.assertNotNull((Object)this.c.getChildren());
        TestSQLCatalog.assertEquals((int)this.c.getChildren().size(), (int)0);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)0);
        try {
            this.c.removeChild(-1);
            this.c.removeChild(0);
            this.c.removeChild(1);
            TestSQLCatalog.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        SQLTable t1 = new SQLTable(this.c, "", "", "TABLE", true);
        SQLTable t2 = new SQLTable(this.c, "", "", "TABLE", true);
        SQLTable t3 = new SQLTable(this.c, "", "", "TABLE", true);
        SQLTable t4 = new SQLTable(this.c, "", "", "TABLE", true);
        this.c.addChild(t1);
        this.c.addChild(t2);
        this.c.addChild(t3);
        this.c.addChild(t4);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)4);
        SQLTable tx = (SQLTable)this.c.removeChild(1);
        TestSQLCatalog.assertEquals((Object)tx, (Object)t2);
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)3);
        TestSQLCatalog.assertTrue((boolean)this.c.removeChild(t4));
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)2);
        TestSQLCatalog.assertFalse((boolean)this.c.removeChild(t4));
        TestSQLCatalog.assertEquals((int)this.c.getChildCount(), (int)2);
    }

    public void testGetSQLObjectListeners() throws ArchitectException {
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        TestSQLColumn.TestSQLObjectListener test2 = new TestSQLColumn.TestSQLObjectListener();
        this.c.addSQLObjectListener(test1);
        this.c.addSQLObjectListener(test2);
        TestSQLCatalog.assertEquals((Object)this.c.getSQLObjectListeners().get(0), (Object)test1);
        TestSQLCatalog.assertEquals((Object)this.c.getSQLObjectListeners().get(1), (Object)test2);
        int i = 0;
        while (i < 5) {
            this.c.addChild(new SQLTable(this.c, "", "", "TABLE", true));
            ++i;
        }
        TestSQLCatalog.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLCatalog.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLCatalog.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        this.c.removeSQLObjectListener(test2);
        i = 0;
        while (i < 5) {
            this.c.removeChild(0);
            ++i;
        }
        TestSQLCatalog.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLCatalog.assertEquals((int)test1.getRemovedCount(), (int)5);
        TestSQLCatalog.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLCatalog.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        TestSQLCatalog.assertEquals((int)this.c.getSQLObjectListeners().size(), (int)1);
    }
}

