/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.DuplicateColumnException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLIndex
extends SQLObject {
    private static final Logger logger = Logger.getLogger(SQLIndex.class);
    private SQLTable.Folder<SQLIndex> parent;
    private boolean unique;
    private String qualifier;
    private IndexType type;
    private String filterCondition;

    public SQLIndex(String name, boolean unique, String qualifier, IndexType type, String filter) {
        this();
        this.setName(name);
        this.unique = unique;
        this.qualifier = qualifier;
        this.type = type;
        this.filterCondition = filter;
    }

    public SQLIndex() {
        this.children = new ArrayList();
    }

    public SQLIndex(SQLIndex oldIndex) throws ArchitectException {
        this();
        this.setName(oldIndex.getName());
        this.unique = oldIndex.unique;
        this.parent = oldIndex.parent;
        this.populated = oldIndex.populated;
        this.type = oldIndex.type;
        this.filterCondition = oldIndex.filterCondition;
        this.qualifier = oldIndex.qualifier;
        for (Object c : oldIndex.getChildren()) {
            Column oldCol = (Column)c;
            Column newCol = new Column();
            newCol.setAscending(oldCol.ascending);
            newCol.setDescending(oldCol.descending);
            newCol.column = oldCol.column;
            newCol.setName(oldCol.getName());
            this.addChild(newCol);
        }
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return Column.class;
    }

    @Override
    public Column getChild(int index) throws ArchitectException {
        return (Column)super.getChild(index);
    }

    @Override
    public SQLTable.Folder<SQLIndex> getParent() {
        return this.parent;
    }

    public SQLTable getParentTable() {
        SQLObject parent = this.getParent();
        return ((SQLTable.Folder)parent).getParent();
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populate() throws ArchitectException {
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    @Override
    protected void setParent(SQLObject parent) {
        this.parent = (SQLTable.Folder)parent;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        String oldValue = this.filterCondition;
        this.filterCondition = filterCondition;
        this.fireDbObjectChanged("filterCondition", oldValue, filterCondition);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        String oldValue = this.qualifier;
        this.qualifier = qualifier;
        this.fireDbObjectChanged("qualifier", oldValue, qualifier);
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        IndexType oldValue = this.type;
        this.type = type;
        this.fireDbObjectChanged("type", (Object)oldValue, (Object)type);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        boolean oldValue = this.unique;
        this.unique = unique;
        this.fireDbObjectChanged("unique", oldValue, unique);
    }

    public void setParent(SQLTable.Folder<SQLIndex> parent) {
        this.parent = parent;
    }

    static void addIndicesToTable(SQLTable addTo, String catalog, String schema, String tableName) throws SQLException, DuplicateColumnException, ArchitectException {
        Connection con = null;
        ResultSet rs = null;
        try {
            con = addTo.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            logger.debug((Object)("SQLIndex.addIndicesToTable: catalog=" + catalog + "; schema=" + schema + "; tableName=" + tableName));
            SQLObject idx = null;
            rs = dbmd.getIndexInfo(catalog, schema, tableName, false, true);
            while (rs.next()) {
                Column col;
                boolean nonUnique = rs.getBoolean(4);
                String qualifier = rs.getString(5);
                String name = rs.getString(6);
                IndexType type = IndexType.forJdbcType(rs.getShort(7));
                int pos = rs.getInt(8);
                String colName = rs.getString(9);
                String ascDesc = rs.getString(10);
                boolean ascending = ascDesc != null && ascDesc.equals("A");
                boolean descending = ascDesc != null && ascDesc.equals("D");
                String filter = rs.getString(13);
                if (pos == 0) continue;
                if (pos == 1) {
                    logger.debug((Object)("Found index " + name));
                    idx = new SQLIndex(name, !nonUnique, qualifier, type, filter);
                    addTo.getIndicesFolder().children.add(idx);
                }
                logger.debug((Object)("Adding column " + colName + " to index " + idx.getName()));
                if (addTo.getColumnByName(colName, false) != null) {
                    SQLObject sQLObject = idx;
                    sQLObject.getClass();
                    col = (SQLIndex)sQLObject.new Column(addTo.getColumnByName(colName, false), ascending, descending);
                } else {
                    SQLObject sQLObject = idx;
                    sQLObject.getClass();
                    col = (SQLIndex)sQLObject.new Column(colName, ascending, descending);
                }
                ((SQLIndex)idx).children.add(col);
            }
            rs.close();
            rs = null;
            rs = dbmd.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                SQLColumn col = addTo.getColumnByName(rs.getString(4), false);
                if (col != null) {
                    col.primaryKeySeq = new Integer(rs.getInt(5));
                    addTo.setPrimaryKeyName(rs.getString(6));
                    continue;
                }
                SQLException exception = new SQLException("Column " + rs.getString(4) + " not found in " + addTo);
                throw exception;
            }
            rs.close();
            rs = null;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close result set", (Throwable)ex);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public void addIndexColumn(SQLColumn col1, boolean ascending, boolean descending) throws ArchitectException {
        Column col = new Column(col1, ascending, descending);
        this.addChild(col);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        STATISTIC(0),
        CLUSTERED(1),
        HASHED(2),
        OTHER(3);

        private short jdbcType;

        private IndexType(short jdbcType) {
            this.jdbcType = jdbcType;
        }

        public short getJdbcType() {
            return this.jdbcType;
        }

        public static IndexType forJdbcType(short jdbcType) {
            if (jdbcType == 0) {
                return STATISTIC;
            }
            if (jdbcType == 1) {
                return CLUSTERED;
            }
            if (jdbcType == 2) {
                return HASHED;
            }
            if (jdbcType == 3) {
                return OTHER;
            }
            throw new IllegalArgumentException("Unknown JDBC index type code: " + jdbcType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Column
    extends SQLObject {
        private SQLColumn column;
        private boolean ascending;
        private boolean descending;

        public Column(SQLColumn col, boolean ascending, boolean descending) {
            this(col.getName(), ascending, descending);
            this.column = col;
        }

        public Column(String name, boolean ascending, boolean descending) {
            this.children = Collections.emptyList();
            this.setName(name);
            this.ascending = ascending;
            this.descending = descending;
        }

        public Column() {
            this((String)null, false, false);
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }

        @Override
        public SQLObject getParent() {
            return SQLIndex.this;
        }

        @Override
        public String getShortDisplayName() {
            return this.getName();
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public boolean isPopulated() {
            return true;
        }

        @Override
        protected void setParent(SQLObject parent) {
            if (parent != SQLIndex.this) {
                throw new UnsupportedOperationException("You can't change an Index.Column's parent");
            }
        }

        public SQLColumn getColumn() {
            return this.column;
        }

        public void setColumn(SQLColumn column) {
            SQLColumn oldValue = this.column;
            this.column = column;
            this.fireDbObjectChanged("column", oldValue, column);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            boolean oldValue = this.ascending;
            this.ascending = ascending;
            this.fireDbObjectChanged("ascending", oldValue, ascending);
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            boolean oldValue = this.descending;
            this.descending = descending;
            this.fireDbObjectChanged("descending", oldValue, descending);
        }

        public String toString() {
            return this.getName();
        }
    }
}

