/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCatalog
extends SQLObject {
    private static Logger logger = Logger.getLogger(SQLCatalog.class);
    protected SQLObject parent;
    protected String nativeTerm;

    public SQLCatalog() {
        this(null, null, false);
    }

    public SQLCatalog(SQLDatabase parent, String name) {
        this(parent, name, false);
    }

    public SQLCatalog(SQLDatabase parent, String name, boolean startPopulated) {
        this.parent = parent;
        this.setName(name);
        this.children = new LinkedList();
        this.nativeTerm = "catalog";
        this.populated = startPopulated;
    }

    protected SQLTable getTableByName(String tableName) throws ArchitectException {
        this.populate();
        for (SQLObject child : this.children) {
            SQLTable table;
            if (!(child instanceof SQLTable ? (table = (SQLTable)child).getName().equalsIgnoreCase(tableName) : child instanceof SQLSchema && (table = ((SQLSchema)child).getTableByName(tableName)) != null)) continue;
            return table;
        }
        return null;
    }

    public SQLSchema getSchemaByName(String schemaName) throws ArchitectException {
        this.populate();
        if (!this.isSchemaContainer()) {
            return null;
        }
        for (SQLSchema schema : this.children) {
            if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
            return schema;
        }
        return null;
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(SQLObject newParent) {
        this.parent = newParent;
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void populate() throws ArchitectException {
        if (this.populated) {
            return;
        }
        SQLCatalog.logger.debug((Object)"SQLCatalog: populate starting");
        oldSize = this.children.size();
        var2_2 = this.parent;
        synchronized (var2_2) {
            block29: {
                block30: {
                    oldCatalog = null;
                    con = null;
                    rs = null;
                    try {
                        con = ((SQLDatabase)this.parent).getConnection();
                        dbmd = con.getMetaData();
                        oldCatalog = con.getCatalog();
                        try {
                            con.setCatalog(this.getName());
                        }
                        catch (SQLException ex) {
                            SQLCatalog.logger.info((Object)("populate: Could not setCatalog(" + this.getName() + "). Assuming it's a permission problem.  Stack trace:"), (Throwable)ex);
                            this.populated = true;
                            newSize = this.children.size();
                            if (newSize <= oldSize) break block29;
                            changedIndices = new int[newSize - oldSize];
                            i = 0;
                            n = newSize - oldSize;
                            if (true) ** GOTO lbl56
                        }
                        rs = dbmd.getSchemas();
                        while (true) {
                            block31: {
                                if (rs.next()) break block31;
                                rs.close();
                                rs = null;
                                if (oldSize != this.children.size()) break block30;
                                rs = dbmd.getTables(this.getName(), null, "%", new String[]{"TABLE", "VIEW"});
                                if (true) ** GOTO lbl76
                            }
                            schName = rs.getString(1);
                            schema = null;
                            if (schName == null) continue;
                            schema = new SQLSchema(this, schName, false);
                            this.children.add(schema);
                            schema.setNativeTerm(dbmd.getSchemaTerm());
                            SQLCatalog.logger.debug((Object)("Set schema term to " + schema.getNativeTerm()));
                        }
                    }
                    catch (SQLException e) {
                        throw new ArchitectException("catalog.populate.fail", e);
                    }
                    catch (Throwable var9_29) {}
                }
                do {
                    changedIndices[i] = oldSize + i;
                    ++i;
lbl56:
                    // 2 sources

                } while (i < n);
                this.fireDbChildrenInserted(changedIndices, this.children.subList(oldSize, newSize));
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                throw new ArchitectException("catalog.rs.close.fail", e2);
            }
            try {
                if (con != null) {
                    con.setCatalog(oldCatalog);
                    con.close();
                }
            }
            catch (SQLException e2) {
                throw new ArchitectException("Couldn't close connection", e2);
            }
            return;
            do {
                this.children.add(new SQLTable(this, rs.getString(3), rs.getString(5), rs.getString(4), false));
lbl76:
                // 2 sources

            } while (rs.next());
            rs.close();
            rs = null;
        }
    }

    public SQLDatabase getParentDatabase() {
        return (SQLDatabase)this.parent;
    }

    public String getNativeTerm() {
        return this.nativeTerm;
    }

    public void setNativeTerm(String argNativeTerm) {
        if (argNativeTerm != null) {
            argNativeTerm = argNativeTerm.toLowerCase();
        }
        String oldValue = this.nativeTerm;
        this.nativeTerm = argNativeTerm;
        this.fireDbObjectChanged("nativeTerm", oldValue, this.nativeTerm);
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        if (this.children.size() == 0) {
            return null;
        }
        return ((SQLObject)this.children.get(0)).getClass();
    }

    public boolean isSchemaContainer() throws ArchitectException {
        if (this.getParent() != null) {
            this.populate();
        }
        if (this.children.size() == 0) {
            return true;
        }
        return this.children.get(0) instanceof SQLSchema;
    }
}

