/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.DatabaseListChangeEvent;
import ca.sqlpower.architect.DatabaseListChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlDotIni
implements DataSourceCollection {
    private boolean dontAutoSave;
    List<DatabaseListChangeListener> listeners;
    DatabaseListChangeListener saver = new DatabaseListChangeListener(){

        public void databaseAdded(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        public void databaseRemoved(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        private void saveIfFileKnown() {
            if (PlDotIni.this.dontAutoSave) {
                return;
            }
            if (PlDotIni.this.lastFileAccessed != null) {
                try {
                    PlDotIni.this.write(PlDotIni.this.lastFileAccessed);
                }
                catch (IOException e) {
                    logger.error((Object)"Error auto-saving PL.INI file", (Throwable)e);
                }
            }
        }
    };
    private static final Logger logger = Logger.getLogger(PlDotIni.class);
    private final List fileSections = new ArrayList();
    private long fileTime;
    boolean shuttingDown = false;
    int WAIT_TIME = 30;
    Thread monitor = new Thread(){

        public void run() {
            while (!PlDotIni.this.shuttingDown) {
                try {
                    long newFileTime;
                    Thread.sleep(PlDotIni.this.WAIT_TIME * 1000);
                    if (PlDotIni.this.lastFileAccessed == null || (newFileTime = PlDotIni.this.lastFileAccessed.lastModified()) == PlDotIni.this.fileTime) continue;
                    PlDotIni.this.read(PlDotIni.this.lastFileAccessed);
                    PlDotIni.this.fileTime = newFileTime;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    File lastFileAccessed;

    public PlDotIni() {
        this.listeners = new ArrayList<DatabaseListChangeListener>();
        this.listeners.add(this.saver);
    }

    @Override
    public void read(File location) throws IOException {
        boolean MODE_READ_DS = false;
        boolean MODE_READ_GENERIC = true;
        boolean mode = true;
        try {
            this.dontAutoSave = true;
            if (!location.canRead()) {
                throw new IllegalArgumentException("pl.ini file cannot be read: " + location.getAbsolutePath());
            }
            this.lastFileAccessed = location;
            ArchitectDataSource currentDS = null;
            Section currentSection = new Section(null);
            this.fileSections.add(currentSection);
            this.fileTime = location.lastModified();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));
            byte[] lineBytes = null;
            while ((lineBytes = this.readLine(in)) != null) {
                String value;
                String key;
                String line = new String(lineBytes);
                logger.debug((Object)("Read in new line: " + line));
                if (line.startsWith("[Databases_")) {
                    logger.debug((Object)"It's a new database connection spec!");
                    currentDS = new ArchitectDataSource();
                    this.add(currentDS);
                    mode = false;
                    continue;
                }
                if (line.startsWith("[")) {
                    logger.debug((Object)"It's a new generic section!");
                    currentSection = new Section(line.substring(1, line.length() - 1));
                    this.fileSections.add(currentSection);
                    mode = true;
                    continue;
                }
                int equalsIdx = line.indexOf(61);
                if (equalsIdx > 0) {
                    key = line.substring(0, equalsIdx);
                    value = line.substring(equalsIdx + 1, line.length());
                } else {
                    key = line;
                    value = null;
                }
                logger.debug((Object)("key=" + key + ",val=" + value));
                if (!mode) {
                    if (key.equals("PWD") && value != null) {
                        byte[] cypherBytes = new byte[lineBytes.length - equalsIdx - 1];
                        System.arraycopy(lineBytes, equalsIdx + 1, cypherBytes, 0, cypherBytes.length);
                        value = PlDotIni.decryptPassword(9, cypherBytes);
                    }
                    currentDS.put(key, value);
                    continue;
                }
                if (!mode) continue;
                currentSection.put(key, value);
            }
            in.close();
        }
        finally {
            this.dontAutoSave = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finished reading file. Parsed contents:\n" + this.toString()));
        }
    }

    private byte[] readLine(BufferedInputStream in) throws IOException {
        int ch;
        int MAX_LINE_LENGTH = 10000;
        byte[] buffer = new byte[10000];
        int lineSize = 0;
        while ((ch = in.read()) != -1 && lineSize < 10000) {
            buffer[lineSize] = (byte)ch;
            if (++lineSize < 2 || buffer[lineSize - 2] != 13 || buffer[lineSize - 1] != 10) continue;
            lineSize -= 2;
            break;
        }
        if (ch == -1 && lineSize == 0) {
            return null;
        }
        if (lineSize == 10000) {
            logger.error((Object)"Maximum line size exceeded while reading pl.ini.  Line will be split up.");
        }
        byte[] chopBuffer = new byte[lineSize];
        System.arraycopy(buffer, 0, chopBuffer, 0, lineSize);
        return chopBuffer;
    }

    @Override
    public void write() throws IOException {
        if (this.lastFileAccessed == null) {
            throw new IllegalStateException("Can't determine location for saving");
        }
        this.write(this.lastFileAccessed);
    }

    @Override
    public void write(File location) throws IOException {
        try {
            this.dontAutoSave = true;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));
            this.write(out);
            ((OutputStream)out).close();
            this.lastFileAccessed = location;
            this.fileTime = location.lastModified();
        }
        finally {
            this.dontAutoSave = false;
        }
    }

    private void write(OutputStream out) throws IOException {
        int dbNum = 1;
        for (Object next : this.fileSections) {
            if (next instanceof Section) {
                this.writeSection(out, ((Section)next).getName(), ((Section)next).getPropertiesMap());
                continue;
            }
            if (next instanceof ArchitectDataSource) {
                this.writeSection(out, "Databases_" + dbNum, ((ArchitectDataSource)next).getPropertiesMap());
                ++dbNum;
                continue;
            }
            if (next == null) {
                logger.error((Object)"write: Null section");
                continue;
            }
            logger.error((Object)("write: Unknown section type: " + next.getClass().getName()));
        }
    }

    private void writeSection(OutputStream out, String name, Map properties) throws IOException {
        if (name != null) {
            String sectionHeading = "[" + name + "]" + "\r\n";
            out.write(sectionHeading.getBytes());
        }
        String s = null;
        s = (String)properties.get("Logical");
        if (s != null) {
            out.write("Logical".getBytes());
            out.write("=".getBytes());
            out.write(s.getBytes());
            out.write("\r\n".getBytes());
        }
        for (Map.Entry ent : properties.entrySet()) {
            if (ent.getKey().equals("Logical")) continue;
            out.write(((String)ent.getKey()).getBytes());
            if (ent.getValue() != null) {
                byte[] val = ent.getKey().equals("PWD") ? this.encryptPassword(9, (String)ent.getValue()) : ((String)ent.getValue()).getBytes();
                out.write("=".getBytes());
                out.write(val);
            }
            out.write("\r\n".getBytes());
        }
    }

    @Override
    public ArchitectDataSource getDataSource(String name) {
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSource)) continue;
            ArchitectDataSource ds = (ArchitectDataSource)next;
            logger.debug((Object)("Checking if data source " + ds + " is PL Logical connection " + name));
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    @Override
    public List<ArchitectDataSource> getConnections() {
        ArrayList<ArchitectDataSource> connections = new ArrayList<ArchitectDataSource>();
        for (Object next : this.fileSections) {
            if (!(next instanceof ArchitectDataSource)) continue;
            connections.add((ArchitectDataSource)next);
        }
        Collections.sort(connections, new ArchitectDataSource.DefaultComparator());
        return connections;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            return "PlDotIni: toString: Couldn't create string description: " + e.getMessage();
        }
        return ((Object)out).toString();
    }

    private byte[] encryptPassword(int key, String plaintext) {
        byte[] cyphertext = new byte[plaintext.length()];
        int i = 0;
        while (i < plaintext.length()) {
            int temp = plaintext.charAt(i);
            temp = i % 2 == 1 ? (temp -= key) : (temp += key);
            cyphertext[i] = (byte)(temp ^= 10 - key);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            int i2 = 0;
            while (i2 < cyphertext.length) {
                nums.append(cyphertext[i2]);
                nums.append(' ');
                ++i2;
            }
            logger.debug((Object)("Encrypt: Plaintext: \"" + plaintext + "\"; cyphertext=(" + nums + ")"));
        }
        return cyphertext;
    }

    public static String decryptPassword(int number, byte[] cyphertext) {
        StringBuffer plaintext = new StringBuffer(cyphertext.length);
        int i = 0;
        int n = cyphertext.length;
        while (i < n) {
            int temp = cyphertext[i] & 0xFF ^ 10 - number;
            temp = i % 2 == 1 ? (temp += number) : (temp -= number);
            plaintext.append((char)temp);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            int i2 = 0;
            while (i2 < cyphertext.length) {
                nums.append(cyphertext[i2]);
                nums.append(' ');
                ++i2;
            }
            logger.debug((Object)("Decrypt: cyphertext=(" + nums + "); Plaintext: \"" + plaintext + "\""));
        }
        return plaintext.toString();
    }

    @Override
    public void addDataSource(ArchitectDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            ArchitectDataSource oneDbcs;
            if (!(o instanceof ArchitectDataSource) || !newName.equalsIgnoreCase((oneDbcs = (ArchitectDataSource)o).getDisplayName())) continue;
            throw new IllegalArgumentException("There is already a datasource with the name " + newName);
        }
        this.add(dbcs);
    }

    @Override
    public void mergeDataSource(ArchitectDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            ArchitectDataSource oneDbcs;
            if (!(o instanceof ArchitectDataSource) || !newName.equalsIgnoreCase((oneDbcs = (ArchitectDataSource)o).getDisplayName())) continue;
            try {
                BeanUtils.copyProperties((Object)oneDbcs, (Object)dbcs);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't merge DBCS: " + e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Can't merge DBCS: " + e);
            }
        }
        this.add(dbcs);
    }

    @Override
    public void removeDataSource(ArchitectDataSource dbcs) {
        int where = 0;
        while (where < this.fileSections.size()) {
            Object o = this.fileSections.get(where);
            if (o instanceof ArchitectDataSource && o.equals(dbcs)) {
                this.fileSections.remove(where);
                this.fireRemoveEvent(where, dbcs);
                return;
            }
            ++where;
        }
        throw new IllegalArgumentException("dbcs not in list");
    }

    private void add(ArchitectDataSource dbcs) {
        this.fileSections.add(dbcs);
        this.fireAddEvent(dbcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddEvent(ArchitectDataSource dbcs) {
        int index = this.fileSections.size() - 1;
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, index, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseAdded(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveEvent(int i, ArchitectDataSource dbcs) {
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, i, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private static class Section {
        private String name;
        private Map properties;

        public Section(String name) {
            this.name = name;
            this.properties = new HashMap();
        }

        public Object put(String key, String value) {
            return this.properties.put(key, value);
        }

        public Map getPropertiesMap() {
            return this.properties;
        }

        public String getName() {
            return this.name;
        }
    }
}

