/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.MockJDBCStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockJDBCResultSet
implements ResultSet {
    private MockJDBCStatement statement;
    private int columnCount;
    private String[] columnNames;
    private List<Object[]> rows;
    private int currentRow;
    private boolean wasNull;

    MockJDBCResultSet(MockJDBCStatement statement, int columnCount) {
        this.statement = statement;
        this.columnCount = columnCount;
        this.columnNames = new String[columnCount];
        this.rows = new ArrayList<Object[]>();
    }

    private Object getRowCol(int columnIndex) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new SQLException("Not on a valid row (current=" + this.currentRow + ", rows=" + this.rows.size() + ")");
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw new SQLException("Column index " + columnIndex + " out of range (columnCount=" + this.columnCount + ")");
        }
        Object val = this.rows.get(this.currentRow - 1)[columnIndex - 1];
        this.wasNull = val == null;
        return val;
    }

    void addRow() {
        this.rows.add(new Object[this.columnCount]);
        this.last();
    }

    public void addRow(Object[] row) {
        this.rows.add(row);
    }

    public void setColumnName(int columnIndex, String name) {
        this.columnNames[columnIndex - 1] = name.toLowerCase();
    }

    public void setColumnCount(int columns) {
        this.columnCount = columns;
        this.columnNames = new String[columns];
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object val = this.getRowCol(columnIndex);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object val = this.getRowCol(columnIndex);
        if (val == null) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentRow == 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.currentRow == this.rows.size() + 1;
    }

    @Override
    public boolean isFirst() {
        return this.currentRow == 1;
    }

    @Override
    public boolean isLast() {
        return this.currentRow == this.rows.size();
    }

    @Override
    public void beforeFirst() {
        if (this.rows.size() > 0) {
            this.absolute(0);
        }
    }

    @Override
    public void afterLast() {
        if (this.rows.size() > 0) {
            this.absolute(this.rows.size() + 1);
        }
    }

    @Override
    public boolean first() {
        return this.absolute(1);
    }

    @Override
    public boolean last() {
        return this.absolute(-1);
    }

    @Override
    public int getRow() {
        return this.currentRow;
    }

    @Override
    public boolean absolute(int row) {
        if (row == 0) {
            this.currentRow = 0;
            return false;
        }
        if (row < 0) {
            int newRow = this.rows.size() + row + 1;
            if (newRow < 1) {
                this.currentRow = 0;
                return false;
            }
            this.currentRow = newRow;
            return true;
        }
        if (row > this.rows.size()) {
            this.currentRow = this.rows.size() + 1;
            return false;
        }
        this.currentRow = row;
        return true;
    }

    @Override
    public boolean relative(int nrows) {
        this.currentRow += nrows;
        if (this.currentRow < 1) {
            this.currentRow = 0;
            return false;
        }
        if (this.currentRow > this.rows.size()) {
            this.currentRow = this.rows.size() + 1;
            return false;
        }
        return true;
    }

    @Override
    public boolean previous() {
        return this.relative(-1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getType() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.rows.get((int)(this.currentRow - 1))[columnIndex - 1] = x;
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getRowCol(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return Arrays.asList(this.columnNames).indexOf(columnName.toLowerCase()) + 1;
    }
}

