/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.ConfigFile;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.PlDotIni;
import ca.sqlpower.architect.PrintUserSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.DDLUserSettings;
import ca.sqlpower.architect.etl.ETLUserSettings;
import ca.sqlpower.architect.qfa.QFAUserSettings;
import ca.sqlpower.architect.swingui.SwingUserSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUserSettings {
    private static final Logger logger = Logger.getLogger(ConfigFile.class);
    protected DataSourceCollection plDotIni;
    protected String plDotIniPath;
    protected PrintUserSettings printUserSettings = new PrintUserSettings();
    protected UserSettings swingSettings = new SwingUserSettings();
    protected ETLUserSettings etlUserSettings = new ETLUserSettings();
    protected DDLUserSettings ddlUserSettings = new DDLUserSettings();
    protected QFAUserSettings qfaUserSettings = new QFAUserSettings();

    public void setPrintUserSettings(PrintUserSettings printUserSettings) {
        this.printUserSettings = printUserSettings;
    }

    public PrintUserSettings getPrintUserSettings() {
        return this.printUserSettings;
    }

    public UserSettings getSwingSettings() {
        return this.swingSettings;
    }

    public void setSwingSettings(UserSettings sprefs) {
        this.swingSettings = sprefs;
    }

    public ETLUserSettings getETLUserSettings() {
        return this.etlUserSettings;
    }

    public void setETLUserSettings(ETLUserSettings v) {
        this.etlUserSettings = v;
    }

    public QFAUserSettings getQfaUserSettings() {
        return this.qfaUserSettings;
    }

    public void setQfaUserSettings(QFAUserSettings qfaUserSettings) {
        this.qfaUserSettings = qfaUserSettings;
    }

    public DDLUserSettings getDDLUserSettings() {
        return this.ddlUserSettings;
    }

    public void setDDLUserSettings(DDLUserSettings v) {
        this.ddlUserSettings = v;
    }

    public void addDriverJarPath(String path) {
        ArchitectSessionImpl.getInstance().addDriverJar(path);
    }

    public boolean isPlDotIniPathValid() {
        logger.debug((Object)("Checking pl.ini path: " + this.getPlDotIniPath()));
        String path = this.getPlDotIniPath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.canRead() && f.isFile();
    }

    public DataSourceCollection getPlDotIni() {
        String path = this.getPlDotIniPath();
        if (path == null) {
            return null;
        }
        if (this.plDotIni == null) {
            this.plDotIni = new PlDotIni();
            try {
                this.plDotIni.read(new File(path));
            }
            catch (IOException e) {
                logger.error((Object)("Failed to read pl.ini at \"" + this.getPlDotIniPath() + "\""), (Throwable)e);
                this.plDotIni = null;
            }
        }
        return this.plDotIni;
    }

    public void setPlDotIni(DataSourceCollection ini) {
        this.plDotIni = ini;
    }

    public String getPlDotIniPath() {
        return this.plDotIniPath;
    }

    public void setPlDotIniPath(String plDotIniPath) {
        this.plDotIniPath = plDotIniPath;
        this.plDotIni = null;
    }

    public List<ArchitectDataSource> getConnections() {
        return this.getPlDotIni().getConnections();
    }
}

