/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectDataSource {
    private Map<String, String> properties;
    public static final String DBCS_DRIVER_CLASS = "JDBC Driver Class";
    public static final String DBCS_URL = "JDBC URL";
    public static final String PL_LOGICAL = "Logical";
    public static final String PL_TYPE = "Type";
    public static final String PL_DSN = "DSN";
    public static final String PL_SCHEMA_OWNER = "PL Schema Owner";
    public static final String PL_UID = "UID";
    public static final String PL_PWD = "PWD";
    public static final String PL_TNS = "TNS Name";
    public static final String PL_DATABASE_NAME = "Database Name";
    public static final String PL_IP = "IP";
    public static final String PL_PORT = "PORT";
    private transient PropertyChangeSupport pcs;

    public void diff(ArchitectDataSource o2) {
        Map<String, String> p2 = o2.properties;
        this.dump(this.properties, p2, DBCS_DRIVER_CLASS);
        this.dump(this.properties, p2, DBCS_URL);
        this.dump(this.properties, p2, PL_LOGICAL);
        this.dump(this.properties, p2, PL_TYPE);
        this.dump(this.properties, p2, PL_DSN);
        this.dump(this.properties, p2, PL_SCHEMA_OWNER);
        this.dump(this.properties, p2, PL_UID);
        this.dump(this.properties, p2, PL_PWD);
        this.dump(this.properties, p2, PL_TNS);
        this.dump(this.properties, p2, PL_DATABASE_NAME);
        this.dump(this.properties, p2, PL_IP);
        this.dump(this.properties, p2, PL_PORT);
        Iterator<String> iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            System.out.print(String.valueOf(iter.next()) + ", ");
        }
        System.out.println();
        Iterator<String> iter2 = p2.keySet().iterator();
        while (iter2.hasNext()) {
            System.out.print(String.valueOf(iter2.next()) + ", ");
        }
        System.out.println();
    }

    private void dump(Map<String, String> myMap, Map<String, String> otherMap, String key) {
        String val1 = myMap.get(key);
        String val2 = otherMap.get(key);
        System.out.print("Property=" + key + "; me=" + val1 + "; other=" + val2 + ';');
        if (val1 != null && val2 != null && !val1.equals(val2)) {
            System.out.print(" <-- DIFFERENT");
        }
        System.out.println();
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public ArchitectDataSource() {
        this.properties = new HashMap<String, String>();
    }

    public ArchitectDataSource(ArchitectDataSource copyMe) {
        this.properties = new HashMap<String, String>(copyMe.properties);
    }

    private String putImpl(String key, String value, String propertyName) {
        String oldValue = this.get(key);
        this.properties.put(key, value);
        this.getPcs().firePropertyChange(propertyName, oldValue, value);
        return oldValue;
    }

    public String put(String key, String value) {
        return this.putImpl(key, value, key);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getPropertiesMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        ArchitectDataSource other = (ArchitectDataSource)o;
        return this.properties.equals(other.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().removePropertyChangeListener(l);
    }

    public List getPropertyChangeListeners() {
        return Collections.unmodifiableList(Arrays.asList(this.pcs.getPropertyChangeListeners()));
    }

    public String getName() {
        return this.get(PL_LOGICAL);
    }

    public void setName(String argName) {
        this.putImpl(PL_LOGICAL, argName, "name");
    }

    public String getDisplayName() {
        return this.get(PL_LOGICAL);
    }

    public void setDisplayName(String argDisplayName) {
        this.putImpl(PL_LOGICAL, argDisplayName, "name");
    }

    public String getUrl() {
        return this.get(DBCS_URL);
    }

    public void setUrl(String argUrl) {
        this.putImpl(DBCS_URL, argUrl, "url");
    }

    public String getDriverClass() {
        return this.get(DBCS_DRIVER_CLASS);
    }

    public void setDriverClass(String argDriverClass) {
        this.putImpl(DBCS_DRIVER_CLASS, argDriverClass, "driverClass");
    }

    public String getUser() {
        return this.get(PL_UID);
    }

    public void setUser(String argUser) {
        this.putImpl(PL_UID, argUser, "user");
    }

    public String getPass() {
        return this.get(PL_PWD);
    }

    public void setPass(String argPass) {
        this.putImpl(PL_PWD, argPass, "pass");
    }

    public String getPlSchema() {
        return this.properties.get(PL_SCHEMA_OWNER);
    }

    public void setPlSchema(String schema) {
        this.putImpl(PL_SCHEMA_OWNER, schema, "plSchema");
    }

    public String getPlDbType() {
        return this.properties.get(PL_TYPE);
    }

    public void setPlDbType(String type) {
        this.putImpl(PL_TYPE, type, "plDbType");
    }

    public String getOdbcDsn() {
        return this.properties.get(PL_DSN);
    }

    public void setOdbcDsn(String dsn) {
        this.putImpl(PL_DSN, dsn, "odbcDsn");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComparator
    implements Comparator<ArchitectDataSource> {
        @Override
        public int compare(ArchitectDataSource ds1, ArchitectDataSource ds2) {
            if (ds1 == ds2) {
                return 0;
            }
            String v1 = ds1.getName();
            String v2 = ds2.getName();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            int tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getUrl();
            v2 = ds2.getUrl();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getDriverClass();
            v2 = ds2.getDriverClass();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getUser();
            v2 = ds2.getUser();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getPass();
            v2 = ds2.getPass();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            return 0;
        }
    }
}

