# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class BucketsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """BucketsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_buckets_id(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a bucket.

        Deletes a bucket and all associated records.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one bucket can be deleted per request.  #### Related Guides  - [Delete a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/delete-bucket/#delete-a-bucket-in-the-influxdb-ui)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a bucket.

        Deletes a bucket and all associated records.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one bucket can be deleted per request.  #### Related Guides  - [Delete a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/delete-bucket/#delete-a-bucket-in-the-influxdb-ui)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_prepare(bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_buckets_id_async(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a bucket.

        Deletes a bucket and all associated records.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one bucket can be deleted per request.  #### Related Guides  - [Delete a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/delete-bucket/#delete-a-bucket-in-the-influxdb-ui)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_prepare(bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_buckets_id_prepare(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_buckets_id', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_buckets_id_labels_id(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_labels_id(bucket_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_labels_id_with_http_info(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_labels_id_prepare(bucket_id, label_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_buckets_id_labels_id_async(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a bucket.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_labels_id_prepare(bucket_id, label_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_buckets_id_labels_id_prepare(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_buckets_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_buckets_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_buckets_id_members_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        Removes a member from a bucket.  Use this endpoint to remove a user's member privileges from a bucket. This removes the user's `read` and `write` permissions for the bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str bucket_id: The ID of the bucket to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_members_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        Removes a member from a bucket.  Use this endpoint to remove a user's member privileges from a bucket. This removes the user's `read` and `write` permissions for the bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str bucket_id: The ID of the bucket to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_members_id_prepare(user_id, bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_buckets_id_members_id_async(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        Removes a member from a bucket.  Use this endpoint to remove a user's member privileges from a bucket. This removes the user's `read` and `write` permissions for the bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str bucket_id: The ID of the bucket to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_members_id_prepare(user_id, bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_buckets_id_members_id_prepare(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_buckets_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_members_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_buckets_id_owners_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        Removes an owner from a bucket.  Use this endpoint to remove a user's `owner` role for a bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The ID of the bucket to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_owners_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        Removes an owner from a bucket.  Use this endpoint to remove a user's `owner` role for a bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The ID of the bucket to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_owners_id_prepare(user_id, bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_buckets_id_owners_id_async(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        Removes an owner from a bucket.  Use this endpoint to remove a user's `owner` role for a bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The ID of the bucket to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_buckets_id_owners_id_prepare(user_id, bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_buckets_id_owners_id_prepare(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_buckets_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_buckets(self, **kwargs):  # noqa: E501,D401,D403
        """List buckets.

        Lists [buckets](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket).  InfluxDB retrieves buckets owned by the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) associated with the authorization ([API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)). To limit which buckets are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all buckets up to the default `limit`.  #### InfluxDB OSS  - If you use an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_   to authenticate your request, InfluxDB retrieves resources for _all   organizations_ in the instance.   To retrieve resources for only a specific organization, use the   `org` parameter or the `orgID` parameter to specify the organization.  #### Required permissions  | Action                    | Permission required | |:--------------------------|:--------------------| | Retrieve _user buckets_   | `read-buckets`      | | Retrieve [_system buckets_](https://docs.influxdata.com/influxdb/latest/reference/internals/system-buckets/) | `read-orgs`         |  #### Related Guides  - [Manage buckets](https://docs.influxdata.com/influxdb/latest/organizations/buckets/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str org: An organization name.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Lists buckets for the specified organization.
        :param str org_id: An organization ID.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either the `org` parameter or `orgID` parameter. - Lists buckets for the specified organization.
        :param str name: A bucket name. Only returns buckets with the specified name.
        :param str id: A bucket ID. Only returns the bucket with the specified ID.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_buckets_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List buckets.

        Lists [buckets](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket).  InfluxDB retrieves buckets owned by the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) associated with the authorization ([API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)). To limit which buckets are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all buckets up to the default `limit`.  #### InfluxDB OSS  - If you use an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_   to authenticate your request, InfluxDB retrieves resources for _all   organizations_ in the instance.   To retrieve resources for only a specific organization, use the   `org` parameter or the `orgID` parameter to specify the organization.  #### Required permissions  | Action                    | Permission required | |:--------------------------|:--------------------| | Retrieve _user buckets_   | `read-buckets`      | | Retrieve [_system buckets_](https://docs.influxdata.com/influxdb/latest/reference/internals/system-buckets/) | `read-orgs`         |  #### Related Guides  - [Manage buckets](https://docs.influxdata.com/influxdb/latest/organizations/buckets/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str org: An organization name.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Lists buckets for the specified organization.
        :param str org_id: An organization ID.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either the `org` parameter or `orgID` parameter. - Lists buckets for the specified organization.
        :param str name: A bucket name. Only returns buckets with the specified name.
        :param str id: A bucket ID. Only returns the bucket with the specified ID.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_buckets_async(self, **kwargs):  # noqa: E501,D401,D403
        """List buckets.

        Lists [buckets](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket).  InfluxDB retrieves buckets owned by the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) associated with the authorization ([API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)). To limit which buckets are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all buckets up to the default `limit`.  #### InfluxDB OSS  - If you use an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_   to authenticate your request, InfluxDB retrieves resources for _all   organizations_ in the instance.   To retrieve resources for only a specific organization, use the   `org` parameter or the `orgID` parameter to specify the organization.  #### Required permissions  | Action                    | Permission required | |:--------------------------|:--------------------| | Retrieve _user buckets_   | `read-buckets`      | | Retrieve [_system buckets_](https://docs.influxdata.com/influxdb/latest/reference/internals/system-buckets/) | `read-orgs`         |  #### Related Guides  - [Manage buckets](https://docs.influxdata.com/influxdb/latest/organizations/buckets/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str org: An organization name.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Lists buckets for the specified organization.
        :param str org_id: An organization ID.  #### InfluxDB Cloud  - Doesn't use the `org` parameter or `orgID` parameter. - Lists buckets for the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either the `org` parameter or `orgID` parameter. - Lists buckets for the specified organization.
        :param str name: A bucket name. Only returns buckets with the specified name.
        :param str id: A bucket ID. Only returns the bucket with the specified ID.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_buckets_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'after', 'org', 'org_id', 'name', 'id']  # noqa: E501
        self._check_operation_params('get_buckets', all_params, local_var_params)

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_buckets`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_buckets`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_buckets`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_buckets_id(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a bucket.

        Retrieves a bucket.  Use this endpoint to retrieve information for a specific bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a bucket.

        Retrieves a bucket.  Use this endpoint to retrieve information for a specific bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_prepare(bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_buckets_id_async(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a bucket.

        Retrieves a bucket.  Use this endpoint to retrieve information for a specific bucket.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_prepare(bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_buckets_id_prepare(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_buckets_id', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_buckets_id_labels(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a bucket.

        Lists all labels for a bucket.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering InfluxDB resources. Labels are also capable of grouping across different resources--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_labels(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_labels_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_labels_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_labels_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a bucket.

        Lists all labels for a bucket.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering InfluxDB resources. Labels are also capable of grouping across different resources--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_labels_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_labels_prepare(bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_buckets_id_labels_async(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a bucket.

        Lists all labels for a bucket.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering InfluxDB resources. Labels are also capable of grouping across different resources--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_labels_prepare(bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_buckets_id_labels_prepare(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_buckets_id_labels', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_labels`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_buckets_id_members(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        Lists all users for a bucket.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization with access to the specified resource.  Use this endpoint to retrieve all users with access to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_members_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        Lists all users for a bucket.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization with access to the specified resource.  Use this endpoint to retrieve all users with access to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_members_prepare(bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_buckets_id_members_async(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        Lists all users for a bucket.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization with access to the specified resource.  Use this endpoint to retrieve all users with access to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_members_prepare(bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_buckets_id_members_prepare(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_buckets_id_members', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_members`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_buckets_id_owners(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        Lists all [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) of a bucket.  Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_owners_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        Lists all [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) of a bucket.  Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_owners_prepare(bucket_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_buckets_id_owners_async(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        Lists all [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) of a bucket.  Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_buckets_id_owners_prepare(bucket_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_buckets_id_owners_prepare(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_buckets_id_owners', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_owners`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_sources_id_buckets(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def get_sources_id_buckets_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_buckets_prepare(source_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_sources_id_buckets_async(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_buckets_prepare(source_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_sources_id_buckets_prepare(self, source_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span', 'org']  # noqa: E501
        self._check_operation_params('get_sources_id_buckets', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `get_sources_id_buckets`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_buckets_id(self, bucket_id, patch_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Update a bucket.

        Updates a bucket.  Use this endpoint to update properties (`name`, `description`, and `retentionRules`) of a bucket.  #### InfluxDB Cloud  - Requires the `retentionRules` property in the request body. If you don't provide `retentionRules`, InfluxDB responds with an HTTP `403` status code.  #### InfluxDB OSS  - Doesn't require `retentionRules`.  #### Related Guides  - [Update a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/update-bucket/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_buckets_id(bucket_id, patch_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param PatchBucketRequest patch_bucket_request: The bucket update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_buckets_id_with_http_info(bucket_id, patch_bucket_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_buckets_id_with_http_info(bucket_id, patch_bucket_request, **kwargs)  # noqa: E501
            return data

    def patch_buckets_id_with_http_info(self, bucket_id, patch_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Update a bucket.

        Updates a bucket.  Use this endpoint to update properties (`name`, `description`, and `retentionRules`) of a bucket.  #### InfluxDB Cloud  - Requires the `retentionRules` property in the request body. If you don't provide `retentionRules`, InfluxDB responds with an HTTP `403` status code.  #### InfluxDB OSS  - Doesn't require `retentionRules`.  #### Related Guides  - [Update a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/update-bucket/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_buckets_id_with_http_info(bucket_id, patch_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param PatchBucketRequest patch_bucket_request: The bucket update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_buckets_id_prepare(bucket_id, patch_bucket_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_buckets_id_async(self, bucket_id, patch_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Update a bucket.

        Updates a bucket.  Use this endpoint to update properties (`name`, `description`, and `retentionRules`) of a bucket.  #### InfluxDB Cloud  - Requires the `retentionRules` property in the request body. If you don't provide `retentionRules`, InfluxDB responds with an HTTP `403` status code.  #### InfluxDB OSS  - Doesn't require `retentionRules`.  #### Related Guides  - [Update a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/update-bucket/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param PatchBucketRequest patch_bucket_request: The bucket update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_buckets_id_prepare(bucket_id, patch_bucket_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_buckets_id_prepare(self, bucket_id, patch_bucket_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'patch_bucket_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_buckets_id', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `patch_buckets_id`")  # noqa: E501
        # verify the required parameter 'patch_bucket_request' is set
        if ('patch_bucket_request' not in local_var_params or
                local_var_params['patch_bucket_request'] is None):
            raise ValueError("Missing the required parameter `patch_bucket_request` when calling `patch_buckets_id`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'patch_bucket_request' in local_var_params:
            body_params = local_var_params['patch_bucket_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_buckets(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Create a bucket.

        Creates a [bucket](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket) and returns the bucket resource. The default data [retention period](https://docs.influxdata.com/influxdb/latest/reference/glossary/#retention-period) is 30 days.  #### InfluxDB OSS  - A single InfluxDB OSS instance supports active writes or queries for approximately 20 buckets across all organizations at a given time. Reading or writing to more than 20 buckets at a time can adversely affect performance.  #### Limitations  - InfluxDB Cloud Free Plan allows users to create up to two buckets. Exceeding the bucket quota will result in an HTTP `403` status code. For additional information regarding InfluxDB Cloud offerings, see [InfluxDB Cloud Pricing](https://www.influxdata.com/influxdb-cloud-pricing/).  #### Related Guides  - [Create a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/create-bucket/) - [Create bucket CLI reference](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/bucket/create)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets(post_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostBucketRequest post_bucket_request: The bucket to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_with_http_info(post_bucket_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_with_http_info(post_bucket_request, **kwargs)  # noqa: E501
            return data

    def post_buckets_with_http_info(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Create a bucket.

        Creates a [bucket](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket) and returns the bucket resource. The default data [retention period](https://docs.influxdata.com/influxdb/latest/reference/glossary/#retention-period) is 30 days.  #### InfluxDB OSS  - A single InfluxDB OSS instance supports active writes or queries for approximately 20 buckets across all organizations at a given time. Reading or writing to more than 20 buckets at a time can adversely affect performance.  #### Limitations  - InfluxDB Cloud Free Plan allows users to create up to two buckets. Exceeding the bucket quota will result in an HTTP `403` status code. For additional information regarding InfluxDB Cloud offerings, see [InfluxDB Cloud Pricing](https://www.influxdata.com/influxdb-cloud-pricing/).  #### Related Guides  - [Create a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/create-bucket/) - [Create bucket CLI reference](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/bucket/create)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_with_http_info(post_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostBucketRequest post_bucket_request: The bucket to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_prepare(post_bucket_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_buckets_async(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Create a bucket.

        Creates a [bucket](https://docs.influxdata.com/influxdb/latest/reference/glossary/#bucket) and returns the bucket resource. The default data [retention period](https://docs.influxdata.com/influxdb/latest/reference/glossary/#retention-period) is 30 days.  #### InfluxDB OSS  - A single InfluxDB OSS instance supports active writes or queries for approximately 20 buckets across all organizations at a given time. Reading or writing to more than 20 buckets at a time can adversely affect performance.  #### Limitations  - InfluxDB Cloud Free Plan allows users to create up to two buckets. Exceeding the bucket quota will result in an HTTP `403` status code. For additional information regarding InfluxDB Cloud offerings, see [InfluxDB Cloud Pricing](https://www.influxdata.com/influxdb-cloud-pricing/).  #### Related Guides  - [Create a bucket](https://docs.influxdata.com/influxdb/latest/organizations/buckets/create-bucket/) - [Create bucket CLI reference](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/bucket/create)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PostBucketRequest post_bucket_request: The bucket to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_prepare(post_bucket_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Bucket',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_buckets_prepare(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['post_bucket_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_buckets', all_params, local_var_params)
        # verify the required parameter 'post_bucket_request' is set
        if ('post_bucket_request' not in local_var_params or
                local_var_params['post_bucket_request'] is None):
            raise ValueError("Missing the required parameter `post_bucket_request` when calling `post_buckets`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'post_bucket_request' in local_var_params:
            body_params = local_var_params['post_bucket_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_buckets_id_labels(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a bucket.

        Adds a label to a bucket and returns the new label information.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering across one or more kinds of **resources**--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Limitations  - Before adding a label to a bucket, you must create the label if you   haven't already. To create a label with the InfluxDB API, send a `POST`   request to the [`/api/v2/labels` endpoint](#operation/PostLabels)).  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_labels(bucket_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_labels_with_http_info(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a bucket.

        Adds a label to a bucket and returns the new label information.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering across one or more kinds of **resources**--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Limitations  - Before adding a label to a bucket, you must create the label if you   haven't already. To create a label with the InfluxDB API, send a `POST`   request to the [`/api/v2/labels` endpoint](#operation/PostLabels)).  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_labels_prepare(bucket_id, label_mapping, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_buckets_id_labels_async(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a bucket.

        Adds a label to a bucket and returns the new label information.  Labels are objects that contain `labelID`, `name`, `description`, and `color` key-value pairs. They may be used for grouping and filtering across one or more kinds of **resources**--for example, you can apply a label named `air_sensor` to a bucket and a task to quickly organize resources.  #### Limitations  - Before adding a label to a bucket, you must create the label if you   haven't already. To create a label with the InfluxDB API, send a `POST`   request to the [`/api/v2/labels` endpoint](#operation/PostLabels)).  #### Related guides  - Use the [`/api/v2/labels` InfluxDB API endpoint](#tag/Labels) to retrieve and manage labels. - [Manage labels in the InfluxDB UI](https://docs.influxdata.com/influxdb/latest/visualize-data/labels/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: Bucket ID. The ID of the bucket to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_labels_prepare(bucket_id, label_mapping, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_buckets_id_labels_prepare(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_buckets_id_labels', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_buckets_id_labels`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_buckets_id_members(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        Add a user to a bucket and return the new user information.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization.  Use this endpoint to give a user member privileges to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_members_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        Add a user to a bucket and return the new user information.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization.  Use this endpoint to give a user member privileges to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_members_prepare(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_buckets_id_members_async(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        Add a user to a bucket and return the new user information.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users in an organization.  Use this endpoint to give a user member privileges to a bucket.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to retrieve users for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member to the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_members_prepare(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_buckets_id_members_prepare(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_buckets_id_members', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_members`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_buckets_id_owners(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        Adds an owner to a bucket and returns the [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) with role and user detail.  Use this endpoint to create a _resource owner_ for the bucket. Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID` *`INFLUX_ORG_ID`* is the ID of the organization that you want to add   an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner for the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_owners_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        Adds an owner to a bucket and returns the [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) with role and user detail.  Use this endpoint to create a _resource owner_ for the bucket. Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID` *`INFLUX_ORG_ID`* is the ID of the organization that you want to add   an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner for the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_owners_prepare(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_buckets_id_owners_async(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        Adds an owner to a bucket and returns the [owners](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) with role and user detail.  Use this endpoint to create a _resource owner_ for the bucket. Bucket owners have permission to delete buckets and remove user and member permissions from the bucket.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID` *`INFLUX_ORG_ID`* is the ID of the organization that you want to add   an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The ID of the bucket to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner for the bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_buckets_id_owners_prepare(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_buckets_id_owners_prepare(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_buckets_id_owners', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_owners`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
