/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.util.completer;

import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.utils.Config;

class FileCompleterGenerator {
    FileCompleterGenerator() {
    }

    String generateCompleterFile(CommandLineParser<CommandInvocation> command) {
        StringBuilder out = new StringBuilder();
        out.append(this.generateHeader(command.getProcessedCommand().name()));
        if (command.isGroupCommand()) {
            out.append(this.generateArrContains());
        }
        out.append(this.generateMainCompletion(command));
        out.append(this.generateCommand(command));
        if (command.isGroupCommand()) {
            for (CommandLineParser<CommandInvocation> child : command.getAllChildParsers()) {
                out.append(this.generateCommand(child));
            }
        }
        out.append(this.generateFooter(command.getProcessedCommand().name()));
        return out.toString();
    }

    private String generateMainCompletion(CommandLineParser<CommandInvocation> command) {
        StringBuilder main = new StringBuilder();
        main.append("function _complete_").append(command.getProcessedCommand().name().toLowerCase()).append(" {").append(Config.getLineSeparator());
        if (command.isGroupCommand()) {
            int i;
            for (i = 0; i < command.getAllChildParsers().size(); ++i) {
                main.append("  CHILD").append(i).append("=(").append(command.getAllChildParsers().get(i).getProcessedCommand().name().toLowerCase()).append(")").append(Config.getLineSeparator());
            }
            for (i = 0; i < command.getAllChildParsers().size(); ++i) {
                main.append("  ArrContains COMP_WORDS CHILD").append(i).append(" && { _command_").append(command.getAllChildParsers().get(i).getProcessedCommand().name().toLowerCase()).append("; return $?; }").append(Config.getLineSeparator());
            }
            main.append(Config.getLineSeparator());
        }
        main.append("  _command_").append(command.getProcessedCommand().name().toLowerCase()).append("; return $?;").append(Config.getLineSeparator());
        main.append("}").append(Config.getLineSeparator()).append(Config.getLineSeparator()).append(Config.getLineSeparator());
        return main.toString();
    }

    private String generateCommand(CommandLineParser<CommandInvocation> command) {
        StringBuilder builder = new StringBuilder();
        builder.append("function _command_").append(command.getProcessedCommand().name().toLowerCase()).append(" {").append(Config.getLineSeparator());
        builder.append(this.generateDefaultCompletionVariables());
        builder.append("  CHILD_COMMANDS=\"");
        if (command.isGroupCommand()) {
            for (CommandLineParser<CommandInvocation> child : command.getAllChildParsers()) {
                builder.append(child.getProcessedCommand().name().toLowerCase()).append(" ");
            }
        }
        builder.append("\";").append(Config.getLineSeparator());
        StringBuilder noValueOptions = new StringBuilder();
        noValueOptions.append("  NO_VALUE_OPTIONS=\"");
        StringBuilder valueOptions = new StringBuilder();
        valueOptions.append("  VALUE_OPTIONS=\"");
        for (ProcessedOption option : command.getProcessedCommand().getOptions()) {
            StringBuilder b = option.hasValue() ? valueOptions : noValueOptions;
            b.append("--").append(option.name()).append(" ");
            if (option.shortName() == null) continue;
            b.append("-").append(option.shortName()).append(" ");
        }
        noValueOptions.append("\"").append(Config.getLineSeparator());
        valueOptions.append("\"").append(Config.getLineSeparator());
        builder.append(noValueOptions.toString());
        builder.append(valueOptions.toString());
        builder.append(this.generateCompletionValues(command));
        builder.append("  COMPREPLY=( $(compgen -W \"${NO_VALUE_OPTIONS} ${VALUE_OPTIONS} ${CHILD_COMMANDS}\" -- ${CURR_WORD}) )").append(Config.getLineSeparator());
        builder.append("}").append(Config.getLineSeparator()).append(Config.getLineSeparator()).append(Config.getLineSeparator());
        return builder.toString();
    }

    private String generateCompletionValues(CommandLineParser<CommandInvocation> command) {
        StringBuilder builder = new StringBuilder();
        for (ProcessedOption option : command.getProcessedCommand().getOptions()) {
            if (!option.hasValue()) continue;
            builder.append("  ").append(option.name().toUpperCase()).append("_VALUES=\"");
            for (String value : option.getDefaultValues()) {
                builder.append(value).append(" ");
            }
            if (option.type().getName().equalsIgnoreCase("boolean")) {
                builder.append("true false");
            }
            builder.append("\"").append(Config.getLineSeparator());
        }
        if (builder.length() > 0) {
            builder.append(Config.getLineSeparator());
            builder.append("  case ${CURR_WORD} in").append(Config.getLineSeparator());
            for (ProcessedOption option : command.getProcessedCommand().getOptions()) {
                if (!option.hasValue()) continue;
                builder.append("    --").append(option.name().toLowerCase());
                if (option.shortName() != null) {
                    builder.append("|-").append(option.shortName());
                }
                builder.append(")").append(Config.getLineSeparator());
                builder.append("      COMPREPLY=( $( compgen -W \"${").append(option.name().toUpperCase()).append("_VALUES}\" -- \"\" ) )").append(Config.getLineSeparator());
                builder.append("      return $?").append(Config.getLineSeparator()).append("      ;;").append(Config.getLineSeparator());
            }
            builder.append("    *)").append(Config.getLineSeparator());
            builder.append("    case ${PREV_WORD} in").append(Config.getLineSeparator());
            for (ProcessedOption option : command.getProcessedCommand().getOptions()) {
                if (!option.hasValue()) continue;
                builder.append("    --").append(option.name().toLowerCase());
                if (option.shortName() != null) {
                    builder.append("|-").append(option.shortName());
                }
                builder.append(")").append(Config.getLineSeparator());
                builder.append("      COMPREPLY=( $( compgen -W \"${").append(option.name().toUpperCase()).append("_VALUES}\" -- $CURR_WORD ) )").append(Config.getLineSeparator());
                builder.append("      return $?").append(Config.getLineSeparator()).append("      ;;").append(Config.getLineSeparator());
            }
            builder.append("    esac").append(Config.getLineSeparator()).append("  esac").append(Config.getLineSeparator()).append(Config.getLineSeparator());
        }
        return builder.toString();
    }

    private String generateHeader(String name) {
        return "#!/usr/bin/env bash" + Config.getLineSeparator() + Config.getLineSeparator() + "#------------------------------------------" + Config.getLineSeparator() + "# Completion support for " + name + " generated by Aesh." + Config.getLineSeparator() + "#------------------------------------------" + Config.getLineSeparator() + Config.getLineSeparator() + "if [ -n \"$BASH_VERSION\" ]; then" + Config.getLineSeparator() + "  shopt -s progcomp" + Config.getLineSeparator() + "elif [ -n \"$ZSH_VERSION\" ]; then" + Config.getLineSeparator() + "  setopt COMPLETE_ALIASES" + Config.getLineSeparator() + "  alias compopt=complete" + Config.getLineSeparator() + "fi" + Config.getLineSeparator() + Config.getLineSeparator();
    }

    private String generateFooter(String name) {
        return "complete -F _complete_" + name + " -o default " + name + " " + name + ".sh";
    }

    private String generateArrContains() {
        return "function ArrContains() {" + Config.getLineSeparator() + "  local lArr1 lArr2" + Config.getLineSeparator() + "  declare -A tmp" + Config.getLineSeparator() + "  eval lArr1=(\"\\\"\\${$1[@]}\\\"\")" + Config.getLineSeparator() + "  eval lArr2=(\"\\\"\\${$2[@]}\\\"\")" + Config.getLineSeparator() + "  for i in \"${lArr1[@]}\";{ [ -n \"$i\" ] && ((++tmp[$i]));}" + Config.getLineSeparator() + "  for i in \"${lArr2[@]}\";{ [ -n \"$i\" ] && [ -z \"${tmp[$i]}\" ] && return 1;}" + Config.getLineSeparator() + "  return 0" + Config.getLineSeparator() + "}" + Config.getLineSeparator() + Config.getLineSeparator();
    }

    private String generateDefaultCompletionVariables() {
        return "# Specify current and previous word" + Config.getLineSeparator() + "  CURR_WORD=${COMP_WORDS[COMP_CWORD]}" + Config.getLineSeparator() + "  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}" + Config.getLineSeparator();
    }
}

