/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.model;

import de.rub.nds.asn1.model.Asn1RawField;
import de.rub.nds.asn1.serializer.Asn1FieldSerializer;
import de.rub.nds.asn1.serializer.Asn1Serializer;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bool.BooleanExplicitValueModification;
import de.rub.nds.modifiablevariable.bool.ModifiableBoolean;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.IntegerExplicitValueModification;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Asn1Field
extends Asn1RawField {
    @XmlElement(name="tagClass")
    private ModifiableInteger tagClass = new ModifiableInteger();
    @XmlElement(name="tagConstructed")
    private ModifiableBoolean tagConstructed = new ModifiableBoolean();
    @XmlElement(name="longTagNumberBytes")
    private int longTagNumberBytes = 0;
    @XmlElement(name="tagNumber")
    private ModifiableInteger tagNumber = new ModifiableInteger();
    @XmlElement(name="longLengthBytes")
    private int longLengthBytes = 0;
    @XmlElement(name="length")
    private ModifiableBigInteger length = new ModifiableBigInteger();
    @XmlElement(name="content")
    private ModifiableByteArray content = new ModifiableByteArray();

    public Asn1Field() {
        this(0, false, 0);
    }

    public Asn1Field(int tagClass, boolean tagConstructed, int tagNumber) {
        this.tagClass.setOriginalValue(Integer.valueOf(tagClass));
        this.tagConstructed.setOriginalValue(Boolean.valueOf(tagConstructed));
        this.tagNumber.setOriginalValue(Integer.valueOf(tagNumber));
        this.length.setOriginalValue(BigInteger.ZERO);
        this.content.setOriginalValue(new byte[0]);
    }

    public ModifiableInteger getTagClass() {
        return this.tagClass;
    }

    public void setTagClass(ModifiableInteger tagClass) {
        this.tagClass = tagClass;
    }

    public void setTagClass(int tagClass) {
        this.tagClass = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.tagClass, (Integer)tagClass);
    }

    public void setTagClassModification(int tagClass) {
        this.tagClass.setModification((VariableModification)new IntegerExplicitValueModification(Integer.valueOf(tagClass)));
    }

    public ModifiableBoolean getTagConstructed() {
        return this.tagConstructed;
    }

    public void setTagConstructed(ModifiableBoolean tagConstructed) {
        this.tagConstructed = tagConstructed;
    }

    public void setTagConstructed(boolean tagConstructed) {
        this.tagConstructed = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.tagConstructed, (Boolean)tagConstructed);
    }

    public void setTagConstructedModification(boolean tagConstructed) {
        this.tagConstructed.setModification((VariableModification)new BooleanExplicitValueModification(tagConstructed));
    }

    public int getLongTagNumberBytes() {
        return this.longTagNumberBytes;
    }

    public void setLongTagNumberBytes(int longTagNumberBytes) {
        this.longTagNumberBytes = longTagNumberBytes;
    }

    public ModifiableInteger getTagNumber() {
        return this.tagNumber;
    }

    public void setTagNumber(ModifiableInteger tagNumber) {
        this.tagNumber = tagNumber;
    }

    public void setTagNumber(int tagNumber) {
        this.tagNumber = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.tagNumber, (Integer)tagNumber);
    }

    public void setTagNumberModification(int tagNumber) {
        this.tagNumber.setModification((VariableModification)new IntegerExplicitValueModification(Integer.valueOf(tagNumber)));
    }

    public int getLongLengthBytes() {
        return this.longLengthBytes;
    }

    public void setLongLengthBytes(int longLengthBytes) {
        this.longLengthBytes = longLengthBytes;
    }

    public ModifiableBigInteger getLength() {
        return this.length;
    }

    public void setLength(ModifiableBigInteger length) {
        this.length = length;
    }

    public void setLength(BigInteger length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.length, (BigInteger)length);
    }

    public ModifiableByteArray getContent() {
        return this.content;
    }

    public void setContent(ModifiableByteArray content) {
        this.content = content;
    }

    public void setContent(byte[] content) {
        this.content = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.content, (byte[])content);
    }

    @Override
    public Asn1Serializer getSerializer() {
        return new Asn1FieldSerializer(this);
    }
}

