/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.l10n;

import au.com.trgtd.tr.l10n.Config;
import au.com.trgtd.tr.l10n.Locale;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;

public class L10nUtils {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.l10n");
    private static final String UC_ID = "tr-l10n-uc";
    private static final String UC_DISPLAY = "ThinkingRock %locale_display% Update Center";
    private static final String UC_URL = "http://www.trgtd.com.au/autoupdate/2.2/l10n/%locale_code%/updates.xml";
    private static L10nUtils instance;

    public static L10nUtils getDefault() {
        if (instance == null) {
            instance = new L10nUtils();
        }
        return instance;
    }

    private L10nUtils() {
    }

    public void setLocale(Locale locale) {
        if (locale == null || locale == Locale.none) {
            this.removeUpdateCenter();
            Config.getDefault().removeLocale();
        } else {
            UpdateUnitProvider uup = this.getUpdateCenter();
            if (uup == null) {
                this.createUpdateCenter(locale);
            } else {
                uup.setDisplayName(this.getDisplayName(locale));
                uup.setProviderURL(this.getURL(locale));
            }
            Config.getDefault().setLocale(locale.language, locale.country);
        }
    }

    private URL getURL(Locale locale) {
        assert (locale != null && locale != Locale.none);
        String urlString = UC_URL.replace("%locale_code%", locale.name());
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ex) {
            LOG.severe("MalformedURLException for: " + urlString);
            return null;
        }
    }

    private String getDisplayName(Locale locale) {
        assert (locale != null && locale != Locale.none);
        return UC_DISPLAY.replace("%locale_display%", locale.display);
    }

    private UpdateUnitProvider getUpdateCenter() {
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getName().equals(UC_ID)) continue;
            return uup;
        }
        return null;
    }

    private UpdateUnitProvider createUpdateCenter(Locale locale) {
        LOG.info("Creating TR update center created for: " + this.getDisplayName(locale));
        return UpdateUnitProviderFactory.getDefault().create(UC_ID, this.getDisplayName(locale), this.getURL(locale));
    }

    private void removeUpdateCenter() {
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getName().equals(UC_ID)) continue;
            f.remove(uup);
            LOG.info("TR language update center removed.");
            break;
        }
    }
}

