/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_POINTER_ATTRIBUTE_P2P_TOKENS
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int P2PTOKEN;
    public static final int VASPACETOKEN;

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long p2pToken() {
        return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address());
    }

    @NativeType(value="unsigned int")
    public int vaSpaceToken() {
        return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address());
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS p2pToken(@NativeType(value="unsigned long long") long value) {
        CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address(), value);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS vaSpaceToken(@NativeType(value="unsigned int") int value) {
        CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address(), value);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS set(long p2pToken, int vaSpaceToken) {
        this.p2pToken(p2pToken);
        this.vaSpaceToken(vaSpaceToken);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS set(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS malloc() {
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS calloc() {
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS create(long address) {
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)address);
    }

    @Nullable
    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS createSafe(long address) {
        return address == 0L ? null : (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS malloc(MemoryStack stack) {
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS calloc(MemoryStack stack) {
        return (CUDA_POINTER_ATTRIBUTE_P2P_TOKENS)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long np2pToken(long struct) {
        return UNSAFE.getLong(null, struct + (long)P2PTOKEN);
    }

    public static int nvaSpaceToken(long struct) {
        return UNSAFE.getInt(null, struct + (long)VASPACETOKEN);
    }

    public static void np2pToken(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)P2PTOKEN, value);
    }

    public static void nvaSpaceToken(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VASPACETOKEN, value);
    }

    static {
        Struct.Layout layout = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__struct((Struct.Member[])new Struct.Member[]{CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__member((int)8), CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        P2PTOKEN = layout.offsetof(0);
        VASPACETOKEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUDA_POINTER_ATTRIBUTE_P2P_TOKENS, Buffer>
    implements NativeResource {
        private static final CUDA_POINTER_ATTRIBUTE_P2P_TOKENS ELEMENT_FACTORY = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_POINTER_ATTRIBUTE_P2P_TOKENS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long p2pToken() {
            return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address());
        }

        @NativeType(value="unsigned int")
        public int vaSpaceToken() {
            return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address());
        }

        public Buffer p2pToken(@NativeType(value="unsigned long long") long value) {
            CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address(), value);
            return this;
        }

        public Buffer vaSpaceToken(@NativeType(value="unsigned int") int value) {
            CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address(), value);
            return this;
        }
    }
}

