/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class FloatingPointExponent
extends AbstractDatatype {
    public static final FloatingPointExponent THE_INSTANCE = new FloatingPointExponent();

    protected FloatingPointExponent() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        block20: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (c == '-') {
                        state = State.AT_START_MINUS_SEEN;
                        continue block20;
                    }
                    if (this.isCSS() && c == '+') {
                        state = State.AT_START_PLUS_SEEN;
                        continue block20;
                    }
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block20;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign or a digit but saw ", c, " instead.");
                }
                case 1: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case 2: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case 3: {
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block20;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block20;
                    }
                    if (this.isAsciiDigit(c)) continue block20;
                    throw this.newDatatypeException(i, "Expected a decimal point, \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case 4: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_DECIMAL_PART_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit after the decimal point but saw ", c, " instead.");
                }
                case 6: {
                    if (this.isAsciiDigit(c)) continue block20;
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case 5: {
                    if (c == '-' || c == '+') {
                        state = State.IN_EXPONENT_SIGN_SEEN;
                        continue block20;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign, a plus sign or a digit but saw ", c, " instead.");
                }
                case 7: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case 8: {
                    if (this.isAsciiDigit(c)) continue block20;
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
            }
        }
        switch (state.ordinal()) {
            case 3: 
            case 6: 
            case 8: {
                return;
            }
            case 0: {
                throw this.newDatatypeException("The empty string is not a valid " + this.getName() + ".");
            }
            case 1: {
                throw this.newDatatypeException("The minus sign alone is not a valid " + this.getName() + ".");
            }
            case 2: {
                throw this.newDatatypeException("The plus sign alone is not a valid " + this.getName() + ".");
            }
            case 4: {
                throw this.newDatatypeException("A " + this.getName() + " must not end with the decimal point.");
            }
            case 5: {
                throw this.newDatatypeException("A " + this.getName() + " must not end with the exponent \u201ce\u201d.");
            }
            case 7: {
                throw this.newDatatypeException("A " + this.getName() + " must not end with only a sign in the exponent.");
            }
        }
    }

    protected boolean isCSS() {
        return false;
    }

    @Override
    public String getName() {
        return "floating point number";
    }

    private static enum State {
        AT_START,
        AT_START_MINUS_SEEN,
        AT_START_PLUS_SEEN,
        IN_INTEGER_PART_DIGITS_SEEN,
        DOT_SEEN,
        E_SEEN,
        IN_DECIMAL_PART_DIGITS_SEEN,
        IN_EXPONENT_SIGN_SEEN,
        IN_EXPONENT_DIGITS_SEEN;

    }
}

