# @(#) $Header: /home/cvs/TclTutor3/balloon.tcl,v 1.1 2007/09/21 18:24:06 clif Exp $
#
##############################################################################
# balloon.tcl - procedures used by balloon help
#
# Copyright (C) 1996-1997 Stewart Allen
# 
# This is part of vtcl source code
# Adapted for general purpose by 
# Daniel Roche <dan@lectra.com>
# version 1.1 ( Dec 02 1998 ) 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

##############################################################################
#

set release(balloon.tcl) {$Header: /home/cvs/TclTutor3/balloon.tcl,v 1.1 2007/09/21 18:24:06 clif Exp $}

bind Bulle <Enter> {
    set Bulle(set) 0
    set Bulle(first) 1
    set Bulle(id) [after 250 {balloon %W $Bulle(%W) %X %Y}]
}

bind Bulle <Button> {
    set Bulle(first) 0
    kill_balloon
}

bind Bulle <Leave> {
    set Bulle(first) 0
    kill_balloon
}

bind Bulle <Destroy> {
    if {[info exists Bulle(target)] && "%W"==$Bulle(target)} {
        kill_balloon
    }
}

bind Bulle <Motion> {
    if {$Bulle(set) == 0} {
        after cancel $Bulle(id)
        set Bulle(id) [after 250 {balloon %W $Bulle(%W) %X %Y}]
    }
}

proc set_balloon {target message} {
    global Bulle
    set Bulle($target) $message
    bindtags $target "[bindtags $target] Bulle"
}

proc kill_balloon {} {
    global Bulle
    after cancel $Bulle(id)
    if {[winfo exists .balloon] == 1} {
        destroy .balloon
    }
    set Bulle(set) 0
}

proc OLDballoon {target message {cx 0} {cy 0} } {
    global Bulle
    # puts "Target: $target MSG: $message x/y: $cx/$cy"

    if {$message==""} return
    if {$Bulle(first) == 1 } {
        set Bulle(first) 2
	if { $cx == 0 && $cy == 0 } {
	    set x [expr [winfo rootx $target] + ([winfo width $target]/2)]
	    set y [expr [winfo rooty $target] + [winfo height $target] + 4]
	} else {
	    set x [expr $cx + 4]
	    set y [expr $cy + 4]
	}
        catch {destroy .balloon}
        toplevel .balloon -bg black
        label .balloon.l -justify left \
            -text $message -relief flat \
            -bg #ffffaa -fg black -padx 2 -pady 0 -anchor w
        pack .balloon.l -side left -padx 1 -pady 1


        set sw [winfo screenwidth .balloon]
        set sh [winfo screenheight .balloon]
        wm geometry .balloon +${sw}+${sh}
        wm overrideredirect .balloon 1
        update idletasks
        if {![winfo exists .balloon]} return
        set width [winfo reqwidth .balloon]
        set height [winfo reqheight .balloon]
        if {$x+$width>$sw} {set x [expr {$cx - ($width+4)}]}
        if {$y>$sh*0.75} {set y [expr {$cy - ($height+4)}]}
        wm geometry .balloon +${x}+${y}
        set Bulle(set) 1
        set Bulle(target) $target
	raise .balloon
#       puts "DONE test"
    }
}

proc balloon {target message {cx 0} {cy 0} } {
    global Bulle
    global tcl_platform
    
    switch $tcl_platform(platform) {
      unix {
         set ystep 10
      }
      windows {
         set ystep 20
      }
      default {
         set ystep 10
      }
    }

    if {$message==""} return
    if {$Bulle(first) == 1 } {
        set Bulle(first) 2
	if { $cx == 0 && $cy == 0 } {
	    set x [expr [winfo rootx $target] + ([winfo width $target]/2)]
	    set y [expr [winfo rooty $target] + [winfo height $target] + $ystep]
	} else {
	    set x [expr $cx + 4]
	    set y [expr $cy + $ystep]
	}
        catch {destroy .balloon}
        toplevel .balloon -bg black
	wm withdraw .balloon
        label .balloon.l -justify left \
            -text $message -relief flat \
            -bg #ffffaa -fg black -padx 2 -pady 0 -anchor w
        grid .balloon.l -padx 1 -pady 1
        wm overrideredirect .balloon 1
        update idletasks
        if {![winfo exists .balloon]} return

        set sw [winfo screenwidth .balloon]
        set sh [winfo screenheight .balloon]
        set width [winfo reqwidth .balloon]
        set height [winfo reqheight .balloon]
        if {$x+$width>$sw} {set x [expr {$cx - ($width+4)}]}
        if {$y>$sh*0.75} {set y [expr {$cy - ($height+4)}]}
        wm geometry .balloon +${x}+${y}
        set Bulle(set) 1
        set Bulle(target) $target
	wm deiconify .balloon
	raise .balloon
       # puts "DONE test"
    }
}

