/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public final class GeoUrlToBounds {
    public static final Pattern PATTERN = Pattern.compile("geo:(?<lat>[+-]?[0-9.]+),(?<lon>[+-]?[0-9.]+)(\\?z=(?<zoom>[0-9]+))?");

    private GeoUrlToBounds() {
    }

    public static Bounds parse(String url) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        Matcher m = PATTERN.matcher(url);
        if (m.matches()) {
            int zoom;
            double lon;
            double lat;
            try {
                lat = Double.parseDouble(m.group("lat"));
            }
            catch (NumberFormatException e) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), e);
                return null;
            }
            try {
                lon = Double.parseDouble(m.group("lon"));
            }
            catch (NumberFormatException e) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), e);
                return null;
            }
            try {
                zoom = m.group("zoom") != null ? Integer.parseInt(m.group("zoom")) : 18;
            }
            catch (NumberFormatException e) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), e);
                return null;
            }
            return OsmUrlToBounds.positionToBounds(lat, lon, zoom);
        }
        return null;
    }
}

