/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.annotations;

import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import java.util.ArrayList;
import java.util.List;

public class EncodedValueParser {
    private static final int ENCODED_BYTE = 0;
    private static final int ENCODED_SHORT = 2;
    private static final int ENCODED_CHAR = 3;
    private static final int ENCODED_INT = 4;
    private static final int ENCODED_LONG = 6;
    private static final int ENCODED_FLOAT = 16;
    private static final int ENCODED_DOUBLE = 17;
    private static final int ENCODED_METHOD_TYPE = 21;
    private static final int ENCODED_METHOD_HANDLE = 22;
    private static final int ENCODED_STRING = 23;
    private static final int ENCODED_TYPE = 24;
    private static final int ENCODED_FIELD = 25;
    private static final int ENCODED_ENUM = 27;
    private static final int ENCODED_METHOD = 26;
    private static final int ENCODED_ARRAY = 28;
    private static final int ENCODED_ANNOTATION = 29;
    private static final int ENCODED_NULL = 30;
    private static final int ENCODED_BOOLEAN = 31;

    static EncodedValue parseValue(SectionReader in, SectionReader ext) {
        int argAndType = in.readUByte();
        int type = argAndType & 0x1F;
        int arg = (argAndType & 0xE0) >> 5;
        int size = arg + 1;
        switch (type) {
            case 30: {
                return EncodedValue.NULL;
            }
            case 31: {
                return new EncodedValue(EncodedType.ENCODED_BOOLEAN, (Object)(arg == 1 ? 1 : 0));
            }
            case 0: {
                return new EncodedValue(EncodedType.ENCODED_BYTE, (Object)in.readByte());
            }
            case 2: {
                return new EncodedValue(EncodedType.ENCODED_SHORT, (Object)((short)EncodedValueParser.parseNumber(in, size, true)));
            }
            case 3: {
                return new EncodedValue(EncodedType.ENCODED_CHAR, (Object)Character.valueOf((char)EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 4: {
                return new EncodedValue(EncodedType.ENCODED_INT, (Object)((int)EncodedValueParser.parseNumber(in, size, true)));
            }
            case 6: {
                return new EncodedValue(EncodedType.ENCODED_LONG, (Object)EncodedValueParser.parseNumber(in, size, true));
            }
            case 16: {
                return new EncodedValue(EncodedType.ENCODED_FLOAT, (Object)Float.valueOf(Float.intBitsToFloat((int)EncodedValueParser.parseNumber(in, size, false, 4))));
            }
            case 17: {
                return new EncodedValue(EncodedType.ENCODED_DOUBLE, (Object)Double.longBitsToDouble(EncodedValueParser.parseNumber(in, size, false, 8)));
            }
            case 23: {
                return new EncodedValue(EncodedType.ENCODED_STRING, (Object)ext.getString(EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 24: {
                return new EncodedValue(EncodedType.ENCODED_TYPE, (Object)ext.getType(EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 25: 
            case 27: {
                return new EncodedValue(EncodedType.ENCODED_FIELD, (Object)ext.getFieldRef(EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 28: {
                return new EncodedValue(EncodedType.ENCODED_ARRAY, EncodedValueParser.parseEncodedArray(in, ext));
            }
            case 29: {
                return new EncodedValue(EncodedType.ENCODED_ANNOTATION, (Object)AnnotationsParser.readAnnotation(in, ext, false));
            }
            case 26: {
                return new EncodedValue(EncodedType.ENCODED_METHOD, (Object)ext.getMethodRef(EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 21: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_TYPE, (Object)ext.getMethodProto(EncodedValueParser.parseUnsignedInt(in, size)));
            }
            case 22: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_HANDLE, (Object)ext.getMethodHandle(EncodedValueParser.parseUnsignedInt(in, size)));
            }
        }
        throw new DexException("Unknown encoded value type: 0x" + Integer.toHexString(type));
    }

    public static List<EncodedValue> parseEncodedArray(SectionReader in, SectionReader ext) {
        int count = in.readUleb128();
        ArrayList<EncodedValue> values = new ArrayList<EncodedValue>(count);
        for (int i = 0; i < count; ++i) {
            values.add(EncodedValueParser.parseValue(in, ext));
        }
        return values;
    }

    private static int parseUnsignedInt(SectionReader in, int byteCount) {
        return (int)EncodedValueParser.parseNumber(in, byteCount, false, 0);
    }

    private static long parseNumber(SectionReader in, int byteCount, boolean isSignExtended) {
        return EncodedValueParser.parseNumber(in, byteCount, isSignExtended, 0);
    }

    private static long parseNumber(SectionReader in, int byteCount, boolean isSignExtended, int fillOnRight) {
        long result;
        block4: {
            int i;
            long last;
            block3: {
                result = 0L;
                last = 0L;
                for (i = 0; i < byteCount; ++i) {
                    last = in.readUByte();
                    result |= last << i * 8;
                }
                if (fillOnRight == 0) break block3;
                for (i = byteCount; i < fillOnRight; ++i) {
                    result <<= 8;
                }
                break block4;
            }
            if (!isSignExtended || (last & 0x80L) == 0L) break block4;
            for (i = byteCount; i < 8; ++i) {
                result |= 255L << i * 8;
            }
        }
        return result;
    }
}

