/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.cmd.FPLocationCompleter;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class AbstractPluginsCommand
extends AbstractDynamicCommand
implements CommandWithInstallationDirectory {
    public AbstractPluginsCommand(PmSession pmSession) {
        super(pmSession, true);
    }

    public boolean isVerbose() {
        return this.contains("verbose");
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't be called");
    }

    protected abstract void runCommand(PmCommandInvocation var1, Map<String, String> var2, FeaturePackLocation var3) throws CommandExecutionException;

    protected OptionActivator getArgumentActivator() {
        return null;
    }

    protected String getId(PmSession session) throws CommandExecutionException {
        return this.getFeaturePackLocation(session);
    }

    public String getFeaturePackLocation(PmSession session) throws CommandExecutionException {
        String streamName = (String)this.getValue("");
        if (streamName == null) {
            streamName = this.getArgumentValue();
        }
        return streamName;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String fpl = this.getId(this.pmSession);
        if (fpl == null) {
            throw new CommandExecutionException("Missing feature-pack");
        }
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("").hasValue(true).description("Feature pack location").type(String.class).required(true).optionType(OptionType.ARGUMENT).activator(this.getArgumentActivator()).completer(FPLocationCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        return Collections.emptyList();
    }

    protected String getStreamName(PmSession session) throws CommandExecutionException {
        String streamName = (String)this.getValue("");
        if (streamName == null) {
            streamName = this.getArgumentValue();
        }
        return streamName;
    }
}

