/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReportingErrorHandler
implements ErrorHandler {
    private final ValidationContext context;
    private final Report report;
    private final boolean normative;

    public ReportingErrorHandler(ValidationContext context) {
        this(context, true);
    }

    public ReportingErrorHandler(ValidationContext context, boolean normative) {
        this.context = context;
        this.report = context.report;
        this.normative = normative;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.report.message(this.normative ? MessageId.RSC_017 : MessageId.RSC_024, EPUBLocation.of(this.context).at(ex.getLineNumber(), ex.getColumnNumber()), ex.getMessage());
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        String message = ex.getMessage().trim();
        if (message != null && message.startsWith("WARNING:")) {
            this.report.message(this.normative ? MessageId.RSC_017 : MessageId.RSC_024, EPUBLocation.of(this.context).at(ex.getLineNumber(), ex.getColumnNumber()), message.substring(9, message.length()));
        } else {
            this.report.message(this.normative ? MessageId.RSC_005 : MessageId.RSC_025, EPUBLocation.of(this.context).at(ex.getLineNumber(), ex.getColumnNumber()), message);
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.report.message(MessageId.RSC_016, EPUBLocation.of(this.context).at(ex.getLineNumber(), ex.getColumnNumber()), ex.getMessage());
    }
}

