/* quantis_lkm.c */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/device.h>
#include <sys/lkm.h>

extern struct cfattach quantis_ca;
extern struct cfdriver quantis_cd;
extern struct cdevsw   quantis_cdevsw;

static int pciloc[] = { -1, -1 }; /* device, function */
static struct cfparent pciparent = {
	"pci", "pci", DVUNIT_ANY
};
static struct cfdata quantis_cfdata[] = {
	{"quantis", "quantis", 0, FSTATE_STAR, pciloc, 0, &pciparent, 0},
	{ 0 }
};

static struct cfdriver *quantis_cfdrivers[] = {
	&quantis_cd,
	NULL
};
static struct cfattach *quantis_cfattachs[] = {
	&quantis_ca,
	NULL
};
static const struct cfattachlkminit quantis_cfattachinit[] = {
	{ "quantis", quantis_cfattachs },
	{ NULL }
};

int quantis_lkmentry(struct lkm_table *, int, int);

MOD_DRV("quantis", quantis_cfdrivers, quantis_cfattachinit,
	quantis_cfdata);

int
quantis_lkmentry(struct lkm_table *lkmtp, int cmd, int ver)
{

	DISPATCH(lkmtp, cmd, ver, lkm_nofunc, lkm_nofunc, lkm_nofunc);
}
