/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vtrace.h,v 1.3 2003/02/16 15:32:34 bad Exp $
 * **********************************************************/

/*
 * vtrace.h --
 *
 *      Visual trace mechanism
 */

#ifndef _VTRACE_H_
#define _VTRACE_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MONITOR
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"


#ifdef SUPPORT_VTRACE
/*
 * Functions
 */

#ifdef USERLEVEL
EXTERN Bool VTrace_Init(void);
EXTERN void VTrace_Exit(void);
EXTERN void VTrace_Enable(Bool enable);

#elif defined(MONITOR)
EXTERN void VTrace_Init(VM *vm);

#elif defined(MODULE)
EXTERN void VTrace_Init(VMDriver *vm);
EXTERN void VTrace_FreeAllResources(void);
#endif

EXTERN void VTrace_Set(int index, uint32 value);

#define VTRACE_ENABLE(_enable) VTrace_Enable(_enable)
#define VTRACE_SET(_indx,_value) VTrace_Set(_indx,_value)

#else 

#define VTRACE_ENABLE(_enable)
#define VTRACE_SET(_indx,_value)

#ifdef MODULE
#define VTrace_Init(vm)
#define VTrace_FreeAllResources()
#endif

#endif /* SUPPORT_VTRACE */
#endif
