#ifndef __COMPAT_UACCESS_H__
#   define __COMPAT_UACCESS_H__


/* User space access functions moved in 2.1.7 to asm/uaccess.h --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 1, 7)
#   include <asm/uaccess.h>
#else
#   include <asm/segment.h>
#endif


/* get_user() API modified in 2.1.4 to take 2 arguments --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 1, 4)
#   define compat_get_user get_user
#   define compat_put_user put_user
#else
/*
 * We assign 0 to the variable in case of failure to prevent "`_var' might be
 * used uninitialized in this function" compiler warnings. I think it is OK,
 * because the hardware-based version in newer kernels probably has the same
 * semantics and does not guarantuee that the value of _var will not be
 * modified, should the access fail --hpreg
 */
#   define compat_get_user(_var, _uvAddr) ({                        \
   int _status;                                                     \
                                                                    \
   _status = verify_area(VERIFY_READ, _uvAddr, sizeof(*(_uvAddr))); \
   if (_status >= 0) {                                              \
      (_var) = get_user(_uvAddr);                                   \
   } else {                                                         \
      (_var) = 0;                                                   \
   }                                                                \
   _status;                                                         \
})
#   define compat_put_user(_var, _uvAddr) ({                         \
   int _status;                                                      \
                                                                     \
   _status = verify_area(VERIFY_WRITE, _uvAddr, sizeof(*(_uvAddr))); \
   if (_status >= 0) {                                               \
      put_user(_var, _uvAddr);                                       \
   }                                                                 \
   _status;                                                          \
})
#endif


/* Appeared in 2.1.4 --hpreg */
#ifndef copy_from_user
#   define copy_from_user memcpy_fromfs
#   define copy_to_user memcpy_tofs
#endif


#endif /* __COMPAT_UACCESS_H__ */
