#ifndef __COMPAT_SPINLOCK_H__
#   define __COMPAT_SPINLOCK_H__


/*
 * The spin_lock() API appeared in 2.1.25 in asm/smp_lock.h
 * It moved in 2.1.30 to asm/spinlock.h
 * It moved again in 2.3.18 to linux/spinlock.h
 *
 *   --hpreg
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 3, 18)
#   if LINUX_VERSION_CODE < KERNEL_VERSION(2, 1, 30)
typedef struct {} spinlock_t;
#      define spin_lock_init(lock)
#      define spin_lock(lock)
/* Fool the compiler to avoid an unused variable --hpreg */
#      define spin_lock_irqsave(lock, flags) do { \
   (void)(flags);                                 \
} while (0)
#      define spin_unlock(lock)
#      define spin_unlock_irqrestore(lock, flags)
#   else
#      include <asm/spinlock.h>
#   endif
#   ifndef spin_lock_bh
#      define spin_lock_bh(lock) do { \
                 start_bh_atomic(); \
                 spin_lock(lock); \
} while (0)
#   endif // spin_lock_bh
#   ifndef spin_unlock_bh
#      define spin_unlock_bh(lock) do { \
                 spin_unlock(lock); \
                 end_bh_atomic(); \
} while (0)
#   endif //spin_unlock_bh
#else
#   include <linux/spinlock.h>
#endif


#endif /* __COMPAT_SPINLOCK_H__ */
