/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

#ifndef __DRIVER_H__
#define __DRIVER_H__

#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include <linux/sched.h>
#include <linux/miscdevice.h>

#include "x86.h"
#include "vm_types.h"
#include "vm_time.h"
#include "compat_spinlock.h"
#include "compat_wait.h"


/*
 * Per-instance driver state
 */

struct VMDriver;


/* Range of memory pages --hpreg */
typedef struct MemRange {
   /* Next item in the list --hpreg */
   struct MemRange *next;

   /* Kernel virtual address of the beginning of the range --hpreg */
   VA kAddr;

   /* Physical address of the beginning of the range --hpreg */
   PA pAddr;

   /* Number of allocated pages --hpreg */
   unsigned long numPages;
} MemRange;


typedef struct VMLinux {
   struct VMLinux *next;
   struct VMDriver *vm;

   /*
    * for LinuxDriver_Select()
    */

   Bool selectWaiting;
   wait_queue_head_t selectQueue;
   struct timer_list selectTimer;
   spinlock_t selectLock;

   /*
    * Singly linked list of ranges of allocated memory pages whose physical
    * address is < 4 GB. The lock protect accesses to any field of any item in
    * the list --hpreg
    */
   MemRange list4Gb;
   spinlock_t lock4Gb;
} VMLinux;


/*
 * Static driver state.
 */

#define DEVICE_NAME_SIZE 32
#define LINUXLOG_BUFFER_SIZE  1024

typedef struct VMXLinuxState {
   int major;
   int minor;
   struct miscdevice misc;
   VmTimeStart startTime;	/* Used to compute Mhz estimate */
   char deviceName[DEVICE_NAME_SIZE];
   char buf[LINUXLOG_BUFFER_SIZE];
   VMLinux *head;
} VMXLinuxState;

extern VMXLinuxState linuxState;


#endif
