/*
 * Seperately defined ioctl calls for VMware 'hub' LKM.
 */
#define LINUX_VMWARE_SIOCSKEEP	(LINUX_SIOCDEVPRIVATE+0) /* unused */
#define LINUX_VMWARE_SIOCGKEEP	(LINUX_SIOCDEVPRIVATE+1) /* unused */
#define LINUX_VMWARE_SIOCSLADRF	(LINUX_SIOCDEVPRIVATE+2) /* set mcast filter */
#define LINUX_VMWARE_SIOCPORT	(LINUX_SIOCDEVPRIVATE+3) /* allocate port */
#define LINUX_VMWARE_SIOCBRIDGE (LINUX_SIOCDEVPRIVATE+4) /* enable bridging */
#define LINUX_VMWARE_SIOCNETIF	(LINUX_SIOCDEVPRIVATE+5) /* init real iface */
#define LINUX_VMWARE_SETMACADDR	(LINUX_SIOCDEVPRIVATE+6) /* set mac addr */
#define LINUX_VMWARE_SWITCHMAP      (LINUX_SIOCDEVPRIVATE+7) /* set vlan map */
#define LINUX_VMWARE_SETNOTIFY	    (LINUX_SIOCDEVPRIVATE+8) /* notify on rx */
#define LINUX_VMWARE_UNSETNOTIFY    (LINUX_SIOCDEVPRIVATE+9) /* reset above */
#define LINUX_VMWARE_SETCLUSTERSIZE (LINUX_SIOCDEVPRIVATE+10) /* notify thresh*/

/*
 * Others that it uses, but unfortunately overloads to take different
 * arguments as their 'real' counterparts; they do not use an ifreq
 * structure, and can only come in through the device ioctl entry point.
 * The bridging ones are currently not supported.
 *
 * SIOCGIFADDR   - get ethernet address
 * SIOCSIFADDR   - set ethernet address
 * SIOCGIFFLAGS  - get interface flags
 * SIOCSIFFLAGS  - set interface flags
 * SIOCGIFBR     - get bridging options
 * SIOCSIFBR     - set bridging options
 *
 */

/*
 * Argument for LINUX_VMWARE_SETMACADDR
 */
struct linux_vmware_setmacaddr_args {
	int version;
	unsigned char addr[6];
	unsigned flags;
};

/*
 * Argument for LINUX_VMWARE_SWITCHMAP
 */
struct linux_vmware_switchmap_args {
	int trunk;
	int vlan;
	int connect;
	int vnet;
};

/*
 * VMware's ethernet OUI, first 3 bytes of mac addresses used.
 */
#define VMX86_OUI0 0x00
#define VMX86_OUI1 0x50
#define VMX86_OUI2 0x56

#define VMX86_MAC_PREFIX	0xc0
#define VMX86_MAC_FIXED		0x00
#define VMX86_MAC_RESERVED	0x40
#define VMX86_MAC_IPBASED	0x80
#define VMX86_MAC_RANDOM	0xc0
#define VMX86_MAC_BITS		  22
