#! /bin/sh
#
# This is the post-install script called by modload after it has loaded
# the module.
#
# Sample modload commandline:
#
#	modload netbsd_post.sh if_hub.o
# 
if [ $# -lt 3 ]; then
    echo "$0: should be called by modload(8) with at least 3 arguments"
    exit 1
fi

rm -f /dev/vmnet0 /dev/vmnet1 /dev/vmnet2 /dev/vmnet3
mknod /dev/vmnet0 c $3 0
mknod /dev/vmnet1 c $3 16
mknod /dev/vmnet2 c $3 32
mknod /dev/vmnet3 c $3 48
chmod 600 /dev/vmnet0 /dev/vmnet1 /dev/vmnet2 /dev/vmnet3
exit 0
