#include "args.h"
#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/usage.c,v 1.1 2005/05/28 22:27:54 beebe Exp $";
#endif

#include "args.h"
#include "config.h"
#include "osfiles.h"
#include "compat.h"
#include <pwd.h>
#include <grp.h>
#include <sys/times.h>

extern char *whoami ARGS((void));

static time_t u_begtime= -1, u_endtime= -1;
static time_t cpu_time = 0;

static char *grpnam ARGS((int gid));
static char *pbtime ARGS((time_t t));
static char *petime ARGS((time_t t));
static char *pxtime ARGS((time_t t));
static char *usertype ARGS((char *uname));

void
#if HAVE_STDC
usage_start(void)
#else /* K&R style */
usage_start(VOID)
#endif /* HAVE_STDC */
{
    u_begtime = time(0);
}

void
#if HAVE_STDC
usage_stop(const char *logfile)
#else /* K&R style */
usage_stop(logfile)
const char *logfile;
#endif /* HAVE_STDC */
{
    FILE *fp;
    struct tms buffer;
    time_t new_time;

    if (u_begtime == -1)
	return;
    fp = fopen(logfile, "a");
    if (fp == NULL)
	return;
    u_endtime = time(0);
    times(&buffer);			/* get cpu usage */
    new_time = buffer.tms_utime + buffer.tms_stime;
    fprintf(fp, "%-8s %-8s (pid %5d) %s -- %s (%s) [%0.1fs]\n", whoami(),
	    usertype(whoami()), (int)getpid(),
	    pbtime(u_begtime), petime(u_endtime), pxtime(u_endtime-u_begtime),
	    (float) (new_time - cpu_time)/60);
    cpu_time = new_time;		/* save the most recent one */
    fclose(fp);
}

static char*
#if HAVE_STDC
usertype(char *uname)
#else /* K&R style */
usertype(uname)
char *uname;
#endif /* HAVE_STDC */
{
    struct passwd *p;

    p = getpwnam(uname);
    if (p == NULL) return(grpnam(getgid()));
    return(grpnam(p->pw_gid));
}

static char *
#if HAVE_STDC
grpnam(int gid)
#else /* K&R style */
grpnam(gid)
int gid;
#endif /* HAVE_STDC */
{
    struct group *g;
    static char buf[20];
    g = getgrgid(gid);
    if (g != NULL)
	return(g->gr_name);
    sprintf(buf,"%d", gid);
    return(buf);
}

static char *
#if HAVE_STDC
pbtime(time_t t)
#else /* K&R style */
pbtime(t)
time_t t;
#endif /* HAVE_STDC */
{
    static char buf[26];

    strcpy (buf,ctime(&t));
    buf[16] = '\0';
    return(buf);
}

static char *
#if HAVE_STDC
petime(time_t t)
#else /* K&R style */
petime(t)
time_t t;
#endif /* HAVE_STDC */
{
    static char buf[26];

    strcpy (buf,ctime(&t));
    buf[16] = '\0';
    return(buf+11);
}

static char *
#if HAVE_STDC
pxtime(time_t t)
#else /* K&R style */
pxtime(t)
time_t t;
#endif /* HAVE_STDC */
{
    static char buf[20];
    int hr, min, sec;
    hr = t/3600;
    min = (t % 3600)/60;
    sec = t % 60;
    sprintf(buf,"%d:%02d:%02d", hr, min, sec);
    return(buf);
}
