#include "args.h"
#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/pop3.c,v 1.1 2005/05/28 22:27:52 beebe Exp $";
#endif

/* pop3.c: read Columbia's special pop-3 format remote mail */

#include "mm.h"				/* need defn of FILE */

int
#if HAVE_STDC
pop3_open (msgvec *mail)
#else /* K&R style */
pop3_open (mail)
msgvec *mail;
#endif /* HAVE_STDC */
{
    printf ("pop2 format not supported yet\n");
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
pop3_close (FILE *fp)
#else /* K&R style */
pop3_close (fp)
FILE *fp;
#endif /* HAVE_STDC */
{
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
pop3_rdmsg (void)
#else /* K&R style */
pop3_rdmsg (VOID)
#endif /* HAVE_STDC */
{
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
pop3_wrmsg (void)
#else /* K&R style */
pop3_wrmsg (VOID)
#endif /* HAVE_STDC */
{
    return(false);			/* let them know we failed */
}

/*
 * probe file to see if it's in pop3 format
 * I don't know what this means yet...
 */
int
#if HAVE_STDC
pop3_probe (const char *file)
#else /* K&R style */
pop3_probe (file)
const char *file;
#endif /* HAVE_STDC */
{
    return (false);			/* naah... */
}
