#ifndef PARSE_H_
#define PARSE_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *parse_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/parse.h,v 1.1 2005/05/28 22:27:52 beebe Exp $";
#endif
#endif /* RCSID */

/*
 * parse.h - various definitions needed by modules which do command parsing
 */

#include "keytab.h"

/*
 * cmseter() and cmsetrp() are redefined to return non-zero whenever the
 * associated longjmps have been taken, making them a little more useful.
 * also, a the error handler for hard errors is redefined so we can catch
 * EOF specially -- cmseteof() must be called at a higher-level than the
 * first call to cmseter!
 */

#undef cmseter
#define cmseter() \
  ((cmcsb._cmerh = (int(*) ARGS((int, ...)))ccmd_error), setjmp(cmerjb))

#undef cmsetrp
#define cmsetrp() \
  ((cmcsb._cmrph = cmrpjmp), setjmp(cmrpjb))

/*
 * cmseteof() must be called before cmseter(), since we replace ccmd's
 * default error handler with our own, and ours does a longjmp through
 * eofjmpb when EOF is encountered.
 */
extern jmp_buf eofjmpb;
#define cmseteof() \
  setjmp(eofjmpb)

/* global variables declared in mm.c */
extern pval pv;
extern fdb *used;
extern buffer atmbuf;

/* function descriptor blocks declared in cmds.c */
extern fdb mm_top_fdb_abbr, mm_top_fdb_inv, mm_top_fdb_1, mm_top_fdb_2,
  mm_top_fdb_3, mm_top_fdb_4, mm_top_fdb_5, mm_top_fdb_6, mm_top_fdb_7,
  mm_send_fdb_abbr, mm_send_fdb_inv, mm_send_fdb_1, mm_send_fdb_2,
  mm_send_fdb_3, mm_send_fdb_4, mm_send_fdb_5,
  mm_read_fdb_abbr, mm_read_fdb_inv, mm_read_fdb_1, mm_read_fdb_2,
  mm_read_fdb_3, mm_read_fdb_4, mm_read_fdb_5, mm_read_fdb_6, mm_read_fdb_7,
  hdr_cmd_fdb, disp_cmd_fdb, erase_cmd_fdb, reply_to_fdb, include_fdb;

/* fdbs declared in set.c */
extern fdb set_cmd_fdb;

/* fdbs declared in parse.c */
extern fdb shell_fdb, cfm_fdb;

/* fdbs declared in seq.c */
extern fdb seq_fdb;

/* fdbs declared in parsemsg.c */
extern fdb header_fbd;

/*
 * routines declared in ccmd package
 */

extern int cmargs ARGS((int argc_, char **argv_));
extern void noise ARGS((const char *nw_));
extern void confirm ARGS((void));

/*
 * other external declarations
 */

extern void (*mm_cmds[]) ARGS((int n_));

/*
 * some useful macros
 */

#define interactive	(cmcsb._cmflg | CM_TTY)

/* save_parse_context
 *
 * this macro must be invoked as the last storage declaration in the
 * enclosing procedure; it declares and initializes jmp_bufs used to save
 * the caller's parsing context, so restore_parse_context() can restore
 * them before returning
 */

#define save_parse_context() \
    jmp_buf erhjmp, rphjmp; \
    bcopy(cmerjb,erhjmp,sizeof(erhjmp)), bcopy(cmrpjb,rphjmp,sizeof(rphjmp))

#define restore_parse_context() \
    bcopy(erhjmp,cmerjb,sizeof(erhjmp)), bcopy(rphjmp,cmrpjb,sizeof(rphjmp))

extern keytab formattab;

typedef struct Setkey {
    keytab *the_keytab;
    string current;
} Setkey;

extern Setkey default_mail_type;

#define NOVICE 0
#define EXPERT 1

#endif /* PARSE_H_ */
