#include "args.h"
#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/mailrc.c,v 1.1 2005/05/28 22:27:51 beebe Exp $";
#endif

#include "mm.h"
#include "address.h"

static char *egets ARGS((char *s, int n, FILE *stream));
static char *gettoken ARGS((char **cp));
static void rdmailrc ARGS((FILE *fp));

void
#if HAVE_STDC
mailrc(void)
#else /* K&R style */
mailrc(VOID)
#endif /* HAVE_STDC */
{
    FILE *fp;
    char fname[BUFSIZ];

    sprintf(fname, "%s/.mailrc", HOME);
    if  ((fp = fopen(fname, "r")) == NULL)
	return;
    rdmailrc(fp);
    fclose(fp);
}

static void
#if HAVE_STDC
rdmailrc(FILE *fp)
#else /* K&R style */
rdmailrc(fp)
FILE *fp;
#endif /* HAVE_STDC */
{
    char line[BUFSIZ];
    char alias[40];
    addresslist al;
    char *cp, *cp1;
    addresslist *a;

    while(egets(line, BUFSIZ-1, fp) != NULL) {
	al.first = al.last = nil;
	line[BUFSIZ-1] = '\0';
	cp = line;

	cp1 = gettoken(&cp);
	if (cp1 == nil)
	    continue;
	if (ustrncmp(cp1,"alias",5))
	    continue;

	cp1 = gettoken(&cp);
	if (cp1 == nil)
	    continue;
	strcpy(alias, cp1);
	while ((cp1 = gettoken(&cp), cp1)) {
	    if ((a = lookup_alias(cp1), a))
		merge_addresses(&al, a);
	    else
		add_addresslist(&al, cp1, ADR_ADDRESS);
	}
	if (al.first)
	    set_alias(safe_strcpy(alias), &al, MA_MAILRC);
    }
}


/*
 * get a "token" -- a "word" or a quoted string
 */

static char *
#if HAVE_STDC
gettoken(char **cp)
#else /* K&R style */
gettoken(cp)
char **cp;
#endif /* HAVE_STDC */
{
    static char buf[BUFSIZ];
    char *cp1;

    for(cp1 = *cp; isspace(*cp1) && *cp1 != '\0'; cp1++);
    *cp = cp1;
    if (*cp1 == '"') {			/* quoted string */
	for(cp1 = *cp+1; *cp1 != '"' && *cp1 != '\0'; cp1++)
	    if ((*cp1 == '\\') && *(cp1+1) != '\0')
		cp1++;			/* ignore " if it's next */
	cp1++;				/* include " */
    }
    else
	for(cp1 = *cp; !isspace(*cp1) && *cp1 != '\0'; cp1++);
    if (*cp == cp1)
	return(nil);
    strncpy(buf,*cp, cp1- *cp);
    buf[cp1- *cp] = '\0';
    *cp = cp1;
    return(buf);
}

/*
 * egets:
 * like fgets, but if line ends in "\", get next line
 */

static char *
#if HAVE_STDC
egets (char *s, int n, FILE *stream)
      					/* max length */
#else /* K&R style */
egets (s, n, stream)
char *s;
int n;					/* max length */
FILE *stream;
#endif /* HAVE_STDC */
{
    int left, len;
    char *str;

    left = n; str = s;			/* haven't read anything yet */

    while (true) {
	if (fgets (str, left, stream) == NULL)
	    return (NULL);		/* -sigh- */
	len = strlen (str);
	if ((len < 2) ||		/* didn't get backslash-lf */
	    (str[len - 1] != '\n') ||	/* no lf -- out of space so done */
	    (str[len - 2] != '\\'))	/* not continued */
	    return (s);
	str[len - 2] = ' ';		/* translate backslash-lf to space */
	str[len - 1] = '\0';		/* just in case... */
	str = &(str[len-1]);		/* continue after the space */
    }
}
