#ifndef CONFIG_H_
#define CONFIG_H_
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

/*
 * Configuration file for us
 */

#define BUGSTO "bug-mm"

#ifdef S_FILE
#include S_FILE
#else
#include "s-sun50.h"
#endif

/*
 *  Let's let sendmail do it's thing with From:, To:, Sender: headers.
 */

#define DONT_EMIT_FROM_HEADERS

/* Site-specific configurations start here */

#ifdef COLUMBIA

/* If DONT_EMIT_FROM_HEADERS is defined REMAIL doesn't work right */
/* See display.c */
#ifdef DONT_EMIT_FROM_HEADERS
#undef DONT_EMIT_FROM_HEADERS
#endif	/* DONT_EMIT_FROM_HEADERS */

#define FORWARD_FILE ".forward"		/* .forward file name if used */
#define GNUEMACS "emacs"		/* name of GNU Emacs if present */
#undef HAVE_YP				/* use yp? */
#define HAVE_NFS			/* NFS used for some mail files? */
#undef HAVE_QUOTAS			/* have and use quota support? */

#ifndef HAVE_F_SETLK			/* We need file locking via fcntl() */
#define HAVE_F_SETLK
#endif /* HAVE_F_SETLK */
#undef HAVE_LOCKF
#undef HAVE_FLOCK

#ifndef LIBDIR
#define LIBDIR		"/opt/ACISmm/lib/"
#endif
#ifndef SYSINIT
#define SYSINIT		"/opt/ACISmm/lib/mm.conf"
#endif
#ifndef HELPFILE
#define HELPFILE	"/opt/ACISmm/lib/mm.help"
#endif
#ifndef HELPDIR
#define HELPDIR		"/opt/ACISmm/lib/help"
#endif
#ifndef MMAIL_PATH
#define MMAIL_PATH	"/opt/ACISmm/lib/mmail.el"
#endif
#ifndef MOVEMAIL
#define MOVEMAIL	"/opt/ACISmm/lib/movemail"
#endif

#else  /* !COLUMBIA */

#ifdef MM_PANIX
#undef DONT_EMIT_FROM_HEADERS

#define GNUEMACS "emacs"		/* name of GNU Emacs if present */
#undef HAVE_YP				/* use yp? */
#define HAVE_NFS			/* NFS used for some mail files? */
#undef HAVE_QUOTAS			/* have and use quota support? */

#ifndef HAVE_F_SETLK			/* We need file locking via fcntl() */
#define HAVE_F_SETLK
#endif /* HAVE_F_SETLK */
#undef HAVE_LOCKF
#undef HAVE_FLOCK

#ifndef LIBDIR
#define LIBDIR		"/usr/local/bin"
#endif

#ifndef SYSINIT
#define SYSINIT		"/usr/local/libdata/mm-0.91/mm.conf"
#endif

#ifndef HELPFILE
#define HELPFILE	"/pkg/mm-0.91p1/libdata/mm-0.91/mm.help"
#endif

#ifndef HELPDIR
#define HELPDIR		"/pkg/mm-0.91p1/libdata/mm-0.91/help"
#endif

#ifndef MMAIL_PATH
#define MMAIL_PATH	"/pkg/mm-0.91p1/libdata/mm-0.91/mmail.el"
#endif

#ifndef MOVEMAIL
#define MOVEMAIL	"/usr/local/bin/mdmovemail"
#endif

#endif /* MM_PANIX */
#endif /* COLUMBIA */

#endif /* CONFIG_H_ */
