#include "args.h"
#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

/*
 * cmds.c - top level command tables for mm
 *
 * THIS FILE IS EDITED BY HAND - NOT GENERATED BY MACHINE.
 * Every time a new command is added, this file needs to be resync'd
 * with with values in cmds.h which is generated from cmds.hh.
 *
 * All of the top-level command tables for mm are declared here.
 */

#include "mm.h"
#include "parse.h"
#include "cmds.h"
#include "rd.h"

#define MAXCOL 16
#define CMKEYTAB(t,k) keytab t = { (sizeof(k)/sizeof(keywrd)), k, MAXCOL }

void nocmd ARGS((int n_));

/*
 * mm top level commands
 */


keywrd mm_top_keys_1[] = {
    { "exit", 0, (keyval) CMD_EXIT },
    { "help", 0, (keyval) CMD_HELP },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "quit", 0, (keyval) CMD_QUIT },
    { "read", 0, (keyval) CMD_READ },
    { "review", 0, (keyval) CMD_REVIEW },
    { "send", 0, (keyval) CMD_SEND },
    { "suspend", 0, (keyval) CMD_SUSPEND },
};
CMKEYTAB(mm_top_keytab_1,mm_top_keys_1);
fdb mm_top_fdb_1 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_1,
			 "\n  BASIC command, ",
			 NULL, NULL, NULL };


keywrd mm_top_keys_2[] = {
    { "answer",   0, (keyval) CMD_ANSWER },
    { "delete",   0, (keyval) CMD_DELETE },
    { "download", 0, (keyval) CMD_DOWNLOAD },
    { "forward",  0, (keyval) CMD_FORWARD },
    { "print",    0, (keyval) CMD_PRINT },
    { "qd",       KEY_INV, (keyval) CMD_DELETE },
    { "remail",   0, (keyval) CMD_REMAIL },
    { "reply",    0, (keyval) CMD_REPLY },
    { "type",     0, (keyval) CMD_TYPE },
    { "undelete", 0, (keyval) CMD_UNDELETE },
};
CMKEYTAB(mm_top_keytab_2,mm_top_keys_2);
fdb mm_top_fdb_2 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_2,
			 "MESSAGE-HANDLING command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_3[] = {
    { "flag", 0, (keyval) CMD_FLAG },
    { "keyword", 0, (keyval) CMD_KEYWORD },
    { "mark", 0, (keyval) CMD_MARK },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unkeyword", 0, (keyval) CMD_UNKEYWORD },
    { "unmark", 0, (keyval) CMD_UNMARK },
};
CMKEYTAB(mm_top_keytab_3,mm_top_keys_3);
fdb mm_top_fdb_3 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_3,
			 "MESSAGE-TAGGING command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_4[] = {
    { "copy", 0, (keyval) CMD_COPY },
    { "examine", 0, (keyval) CMD_EXAMINE },
    { "expunge", 0, (keyval) CMD_EXPUNGE },
    { "get", 0, (keyval) CMD_GET },
    { "move", 0, (keyval) CMD_MOVE },
    { "restore-draft", 0, (keyval) CMD_RESTORE_DRAFT },
    { "sort", 0, (keyval) CMD_SORT },
    { "write", 0, (keyval) CMD_WRITE },
};
CMKEYTAB(mm_top_keytab_4,mm_top_keys_4);
fdb mm_top_fdb_4 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_4,
			 "FILING command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_5[] = {
    { "define", 0, (keyval) CMD_DEFINE },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "save-init", 0, (keyval) CMD_CREATE_INIT },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
};
CMKEYTAB(mm_top_keytab_5,mm_top_keys_5);
fdb mm_top_fdb_5 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_5,
			 "CUSTOMIZATION command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_6[] = {
    { "check", 0, (keyval) CMD_CHECK },
    { "count", 0, (keyval) CMD_COUNT },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "finger", 0, (keyval) CMD_FINGER },
    { "pwd", 0, (keyval) CMD_PWD },
    { "status", 0, (keyval) CMD_STATUS },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
};
CMKEYTAB(mm_top_keytab_6,mm_top_keys_6);
fdb mm_top_fdb_6 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_6,
			  "INFORMATION command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_7[] = {
    { "backtrack", 0, (keyval) CMD_BACKTRACK },
    { "blank", 0, (keyval) CMD_BLANK },
    { "browse", 0, (keyval) CMD_BROWSE },
    { "bug", 0, (keyval) CMD_BUG },
    { "bye", 0, (keyval) CMD_QQUIT },
    { "cd", 0, (keyval) CMD_CD },
    { "continue", 0, (keyval) CMD_CONTINUE },
    { "echo", 0, (keyval) CMD_ECHO },
    { "edit", 0, (keyval) CMD_EDIT },
    { "follow", 0, (keyval) CMD_FOLLOW },
    { "jump", 0, (keyval) CMD_JUMP },
    { "list", 0, (keyval) CMD_LIST },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "next", 0, (keyval) CMD_NEXT },
    { "previous", 0, (keyval) CMD_PREVIOUS },
    { "push", 0, (keyval) CMD_PUSH },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "smail", KEY_INV, (keyval) CMD_SMAIL },
    { "spell", 0, (keyval) CMD_SPELL },
    { "take", 0, (keyval) CMD_TAKE },
};
CMKEYTAB(mm_top_keytab_7,mm_top_keys_7);
fdb mm_top_fdb_7 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			 (pdat)&mm_top_keytab_7,
			 "some OTHER command, ",
			 NULL, NULL, NULL };

keywrd mm_top_keys_abbr[] = {
    { "delete", KEY_INV, (keyval) CMD_DELETE },
    { "headers", KEY_INV, (keyval) CMD_HEADERS },
    { "literal", KEY_INV, (keyval) CMD_LITERAL },
    { "previous", KEY_INV, (keyval) CMD_PREVIOUS },
    { "quit", KEY_INV, (keyval) CMD_QUIT },
    { "read", KEY_INV, (keyval) CMD_READ },
    { "send", KEY_INV, (keyval) CMD_SEND },
    { "type", KEY_INV, (keyval) CMD_TYPE },
    { "undelete", KEY_INV, (keyval) CMD_UNDELETE },
};
CMKEYTAB(mm_top_keytab_abbr,mm_top_keys_abbr);
fdb mm_top_fdb_abbr = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			    (pdat)&mm_top_keytab_abbr, NULL,
			    NULL, NULL, "Invalid command" };

keywrd mm_top_keys_inv[] = {
    { "alias", 0, (keyval) CMD_ALIAS },
    { "create-init", KEY_INV, (keyval) CMD_CREATE_INIT },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, CMD_MEMDEBUG },
    { "mail", 0, (keyval) CMD_SEND },
    { "qquit", 0, (keyval) CMD_QQUIT },
    { "z", KEY_INV, (keyval) CMD_Z },
};
CMKEYTAB(mm_top_keytab_inv,mm_top_keys_inv);
fdb mm_top_fdb_inv = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			   (pdat)&mm_top_keytab_inv, NULL,
			   NULL, NULL, NULL };



/*
 * mm send mode commands (send + answer modes)
 */

keywrd mm_send_keys_1[] = {
    { "display",    0, (keyval) CMD_DISPLAY },
    { "edit",       0, (keyval) CMD_EDIT },
    { "header",     0, (keyval) CMD_HEADERS },
    { "help",       0, (keyval) CMD_HELP },
    { "insert",     0, (keyval) CMD_INSERT },
    { "quit",       0, (keyval) CMD_QUIT },
    { "save-draft", 0, (keyval) CMD_SAVE_DRAFT },
    { "send",       0, (keyval) CMD_SEND },
    { "suspend",    0, (keyval) CMD_SUSPEND },
    { "text",       0, (keyval) CMD_TEXT },
    { "type",       0, (keyval) CMD_TYPE },
};
CMKEYTAB(mm_send_keytab_1,mm_send_keys_1);
fdb mm_send_fdb_1 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_send_keytab_1,
			  "\n  BASIC send-mode command, ",
			  NULL, NULL, NULL };

keywrd mm_send_keys_2[] = {
    { "bcc",               0, (keyval) CMD_BCC },
    { "cc",                0, (keyval) CMD_CC },
    { "content-type",      0, (keyval) CMD_CONTENT_TYPE },
    { "erase",             0, (keyval) CMD_ERASE },
    { "fcc",               0, (keyval) CMD_FCC },
    { "from",              0, (keyval) CMD_FROM },
    { "keyword",           0, (keyval) CMD_KEYWORD },
    { "in-reply-to",       0, (keyval) CMD_IN_REPLY_TO },
    { "mime-version",      0, (keyval) CMD_MIME_VERSION },
    { "remove",            0, (keyval) CMD_REMOVE },
    { "reply-to",          0, (keyval) CMD_REPLY_TO },
    { "subject",           0, (keyval) CMD_SUBJECT },
    { "to",                0, (keyval) CMD_TO },
    { "transfer-encoding", 0, (keyval) CMD_TRANSFER_ENCODING },
    { "unkeyword",         0, (keyval) CMD_UNKEYWORD },
    { "user-header",       0, (keyval) CMD_USER_HEADER },
};
CMKEYTAB(mm_send_keytab_2,mm_send_keys_2);
fdb mm_send_fdb_2 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_send_keytab_2,
			  "HEADER-FIELD command, ",
			  NULL, NULL, NULL };

keywrd mm_send_keys_3[] = {
    { "define", 0, (keyval) CMD_DEFINE },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "save-init", 0, (keyval) CMD_CREATE_INIT },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
};
CMKEYTAB(mm_send_keytab_3,mm_send_keys_3);
fdb mm_send_fdb_3 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_send_keytab_3,
			  "CUSTOMIZATION command, ",
			  NULL, NULL, NULL };

keywrd mm_send_keys_4[] = {
    { "check", 0, (keyval) CMD_CHECK },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "finger", 0, (keyval) CMD_FINGER },
    { "pwd", 0, (keyval) CMD_PWD },
    { "status", 0, (keyval) CMD_STATUS },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
};
CMKEYTAB(mm_send_keytab_4,mm_send_keys_4);
fdb mm_send_fdb_4 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_send_keytab_4,
			  "INFORMATION command, ",
			  NULL, NULL, NULL };

keywrd mm_send_keys_5[] = {
    { "blank", 0, (keyval) CMD_BLANK },
    { "cd", 0, (keyval) CMD_CD },
    { "echo", 0, (keyval) CMD_ECHO },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "push", 0, (keyval) CMD_PUSH },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "spell", 0, (keyval) CMD_SPELL },
    { "take", 0, (keyval) CMD_TAKE },
};
CMKEYTAB(mm_send_keytab_5,mm_send_keys_5);
fdb mm_send_fdb_5 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_send_keytab_5,
			  "some OTHER command, ",
			  NULL, NULL, NULL };

keywrd mm_send_keys_abbr[] = {
    { "display", KEY_INV, (keyval) CMD_DISPLAY },
    { "edit", KEY_INV, (keyval) CMD_EDIT },
    { "headers", KEY_INV, (keyval) CMD_HEADERS },
    { "literal", KEY_INV, (keyval) CMD_LITERAL },
    { "remove", KEY_INV, (keyval) CMD_REMOVE },
    { "send", KEY_INV, (keyval) CMD_SEND },
    { "type", KEY_INV, (keyval) CMD_TYPE },
};
CMKEYTAB(mm_send_keytab_abbr,mm_send_keys_abbr);
fdb mm_send_fdb_abbr = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			     (pdat)&mm_send_keytab_abbr,
			     NULL, NULL, NULL, "Invalid command" };

keywrd mm_send_keys_inv[] = {
    { "copy", 0, (keyval) CMD_COPY },
    { "create-init", 0, (keyval) CMD_CREATE_INIT },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, (keyval) CMD_MEMDEBUG },
    { "download", 0, (keyval) CMD_DOWNLOAD },
    { "flag", 0, (keyval) CMD_FLAG },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "list", 0, (keyval) CMD_LIST },
    { "mail", 0, (keyval) CMD_SEND },
    { "mark", 0, (keyval) CMD_MARK },
    { "move", 0, (keyval) CMD_MOVE },
    { "print", 0, (keyval) CMD_PRINT },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unmark", 0, (keyval) CMD_UNMARK },
    { "write", 0, (keyval) CMD_WRITE },
    { "z", KEY_INV, (keyval) CMD_Z },
};
CMKEYTAB(mm_send_keytab_inv,mm_send_keys_inv);
fdb mm_send_fdb_inv = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			    (pdat)&mm_send_keytab_inv,
			    NULL, NULL, NULL, NULL };



/*
 * mm read mode commands
 */

keywrd mm_read_keys_1[] = {
    { "backtrack", 0, (keyval) CMD_BACKTRACK },
    { "browse", 0, (keyval) CMD_BROWSE },
    { "follow", 0, (keyval) CMD_FOLLOW },
    { "header", 0, (keyval) CMD_HEADERS },
    { "help", 0, (keyval) CMD_HELP },
    { "next", 0, (keyval) CMD_NEXT },
    { "previous", 0, (keyval) CMD_PREVIOUS },
    { "quit", 0, (keyval) CMD_QUIT },
    { "suspend", 0, (keyval) CMD_SUSPEND },
    { "type", 0, (keyval) CMD_TYPE },
};
CMKEYTAB(mm_read_keytab_1,mm_read_keys_1);
fdb mm_read_fdb_1 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_1,
			  "\n  BASIC read-mode command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_2[] = {
    { "answer", 0, (keyval) CMD_ANSWER },
    { "delete", 0, (keyval) CMD_DELETE },
    { "download", 0, (keyval) CMD_DOWNLOAD },
    { "forward", 0, (keyval) CMD_FORWARD },
    { "kill", 0, (keyval) CMD_KILL },
    { "print", 0, (keyval) CMD_PRINT },
    { "qd", KEY_INV, (keyval) CMD_DELETE },
    { "remail", 0, (keyval) CMD_REMAIL },
    { "reply", 0, (keyval) CMD_REPLY },
    { "undelete", 0, (keyval) CMD_UNDELETE },
};
CMKEYTAB(mm_read_keytab_2,mm_read_keys_2);
fdb mm_read_fdb_2 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_2,
			  "MESSAGE-HANDLING command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_3[] = {
    { "flag", 0, (keyval) CMD_FLAG },
    { "keyword", 0, (keyval) CMD_KEYWORD },
    { "mark", 0, (keyval) CMD_MARK },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unkeyword", 0, (keyval) CMD_UNKEYWORD },
    { "unmark", 0, (keyval) CMD_UNMARK },
};
CMKEYTAB(mm_read_keytab_3,mm_read_keys_3);
fdb mm_read_fdb_3 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_3,
			  "MESSAGE-TAGGING command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_4[] = {
    { "copy", 0, (keyval) CMD_COPY },
    { "move", 0, (keyval) CMD_MOVE },
    { "restore-draft", 0, (keyval) CMD_RESTORE_DRAFT },
    { "write", 0, (keyval) CMD_WRITE },
};
CMKEYTAB(mm_read_keytab_4,mm_read_keys_4);
fdb mm_read_fdb_4 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_4,
			  "FILING command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_5[] = {
    { "define", 0, (keyval) CMD_DEFINE },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "save-init", 0, (keyval) CMD_CREATE_INIT },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
};
CMKEYTAB(mm_read_keytab_5,mm_read_keys_5);
fdb mm_read_fdb_5 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_5,
			  "CUSTOMIZATION command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_6[] = {
    { "check", 0, (keyval) CMD_CHECK },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "finger", 0, (keyval) CMD_FINGER },
    { "pwd", 0, (keyval) CMD_PWD },
    { "status", 0, (keyval) CMD_STATUS },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
};
CMKEYTAB(mm_read_keytab_6,mm_read_keys_6);
fdb mm_read_fdb_6 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_6,
			  "INFORMATION command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_7[] = {
    { "blank", 0, (keyval) CMD_BLANK },
    { "bug", 0, (keyval) CMD_BUG },
    { "cd", 0, (keyval) CMD_CD },
    { "continue", 0, (keyval) CMD_CONTINUE },
    { "echo", 0, (keyval) CMD_ECHO },
    { "edit", 0, (keyval) CMD_EDIT },
    { "jump", 0, (keyval) CMD_JUMP },
    { "list", 0, (keyval) CMD_LIST },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "push", 0, (keyval) CMD_PUSH },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "send", 0, (keyval) CMD_SEND },
    { "spell", 0, (keyval) CMD_SPELL },
    { "take", 0, (keyval) CMD_TAKE },
};
CMKEYTAB(mm_read_keytab_7,mm_read_keys_7);
fdb mm_read_fdb_7 = { _CMKEY, CM_NLH|KEY_PTR|KEY_WID, NULL,
			  (pdat)&mm_read_keytab_7,
			  "some OTHER command, ",
			  NULL, NULL, NULL };

keywrd mm_read_keys_abbr[] = {
    { "delete", KEY_INV, (keyval) CMD_DELETE },
    { "headers", KEY_INV, (keyval) CMD_HEADERS },
    { "kill", KEY_INV, (keyval) CMD_KILL },
    { "literal", KEY_INV, (keyval) CMD_LITERAL },
    { "move", KEY_INV, (keyval) CMD_MOVE },
    { "previous", KEY_INV, (keyval) CMD_PREVIOUS },
    { "reply", KEY_INV, (keyval) CMD_REPLY },
    { "send", KEY_INV, (keyval) CMD_SEND },
    { "type", KEY_INV, (keyval) CMD_TYPE },
    { "undelete", KEY_INV, (keyval) CMD_UNDELETE },
};
CMKEYTAB(mm_read_keytab_abbr,mm_read_keys_abbr);
fdb mm_read_fdb_abbr = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			     (pdat)&mm_read_keytab_abbr,
			     NULL, NULL, NULL, "Invalid command" };

keywrd mm_read_keys_inv[] = {
    { "create-init", 0, (keyval) CMD_CREATE_INIT },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, (keyval) CMD_MEMDEBUG },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "mail", 0, (keyval) CMD_SEND },
    { "z", KEY_INV, (keyval) CMD_Z },
};
CMKEYTAB(mm_read_keytab_inv,mm_read_keys_inv);
fdb mm_read_fdb_inv = { _CMKEY, CM_NLH|CM_SDH|KEY_PTR|KEY_WID, NULL,
			    (pdat)&mm_read_keytab_inv,
			    NULL, NULL, NULL, NULL };

/*
 * Keyword table for displaying header fields
 * (note: transfer-encoding is really content-transfer-encoding)
 */

keywrd hdr_keys[] = {
    { "bcc",               0, (keyval) CMD_BCC },
    { "cc",                0, (keyval) CMD_CC },
    { "content-type",      0, (keyval) CMD_CONTENT_TYPE },
    { "fcc",               0, (keyval) CMD_FCC },
    { "from",              0, (keyval) CMD_FROM },
    { "in-reply-to",       0, (keyval) CMD_IN_REPLY_TO },
    { "mime-version",      0, (keyval) CMD_MIME_VERSION },
    { "reply-to",          0, (keyval) CMD_REPLY_TO },
    { "subject",           0, (keyval) CMD_SUBJECT },
    { "text",              0, (keyval) CMD_TEXT },
    { "to",                0, (keyval) CMD_TO },
    { "transfer-encoding", 0, (keyval) CMD_TRANSFER_ENCODING },
    { "user-header",       0, (keyval) CMD_USER_HEADER }
};

keytab hdr_keytab = { sizeof (hdr_keys) / sizeof (keywrd), hdr_keys };
fdb hdr_cmd_fdb = { _CMKEY, 0, nil, (pdat) &hdr_keytab, "header field, " };


keywrd disp_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
    { "header", 0, (keyval) CMD_HEADER },
};

keytab disp_keytab = { sizeof (disp_keys) / sizeof (keywrd), disp_keys};
fdb disp_cmd_fdb = { _CMKEY, 0, nil, (pdat) &disp_keytab, NULL, "all" };

keywrd erase_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
};
keytab erase_keytab = { sizeof (erase_keys) / sizeof (keywrd), erase_keys};
fdb erase_cmd_fdb = { _CMKEY, 0, nil, (pdat) &erase_keytab, NULL, "text" };

keywrd reply_to_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
    { "none", 0, (keyval) CMD_QUIT },	/* temporary way to abort */
    { "sender", 0, (keyval) CMD_SENDER },
};
keytab reply_to_keytab = { sizeof(reply_to_keys)/sizeof(keywrd),
			       reply_to_keys};
fdb reply_to_fdb = { _CMKEY, 0, nil,  (pdat) &reply_to_keytab, NULL, "sender"};

keywrd include_keys[] = {
    { "including", 0, (keyval) CMD_INCLUDE },
    { "not-including", 0, (keyval) CMD_NOINCLUDE },
};
keytab include_keytab = { sizeof(include_keys)/sizeof(keywrd),
			       include_keys};
fdb include_fdb = { _CMKEY, 0, nil,  (pdat) &include_keytab, NULL,
			"not-including"};

void
#if HAVE_STDC
nocmd(int n)
#else /* K&R style */
nocmd(n)
int n;
#endif /* HAVE_STDC */
{
    confirm ();
    printf ("Sorry, this command is not yet implemented.\n");
}

/*
 * This array is indexed by the main parse loop to dispatch to the
 * appropriate handler routine for each routine.
 */

#if 0		/* no longer used: full declarations now in extern.h */
void nocmd (),
    cmd_alias(),
    cmd_bcc (),
    cmd_blank (),
    cmd_browse (),
    cmd_bug (),
    cmd_cc (),
    cmd_cd (),
    cmd_check (),
    cmd_transfer_encoding(),
    cmd_content_type(),
    cmd_continue(),
    cmd_copy(),
    cmd_count(),
    cmd_create_init(),
    cmd_next(),
    cmd_daytime (),
    cmd_debug (),
    cmd_debug_memory (),
    cmd_define (),
    cmd_display (),
    cmd_download (),
    cmd_echo (),
    cmd_edit(),
    cmd_erase(),
    cmd_exit (),
    cmd_expunge (),
    cmd_fcc(),
    cmd_finger(),
    cmd_forward(),
    cmd_from (),
    cmd_get (),
    cmd_headers (),
    cmd_help(),
    cmd_in_reply_to(),
    cmd_insert(),
    cmd_jump(),
    cmd_keyword(),
    cmd_list(),
    cmd_literal(),
    cmd_mark (),
    cmd_mime_version (),
    cmd_next (),
    cmd_previous (),
    cmd_print(),
    cmd_profile (),
    cmd_push (),
    cmd_pwd(),
    cmd_quit (),
    cmd_read (),
    cmd_remail(),
    cmd_remove (),
    cmd_reply(),
    cmd_reply_to(),
    cmd_restore_draft(),
    cmd_route(),
    cmd_save_draft(),
    cmd_send (),
    cmd_set (),
    cmd_show (),
    cmd_sort (),
    cmd_smail(),
    cmd_spell (),
    cmd_status (),
    cmd_subject (),
    cmd_suspend (),
    cmd_take (),
    cmd_text (),
    cmd_to (),
    cmd_type (),
    cmd_unkeyword (),
    cmd_user_header (),
    cmd_version (),
    cmd_who(),
    cmd_write();
#endif

#define T void (*) ARGS((int))	/* NB: don't use variable name here--SGI
				IRIX 4.0.x cc compiler complains */

/* THIS TABLE CAREFULLY SYNC'D BY HAND WITH cmds.h */

void (*mm_cmds[]) ARGS((int n_)) = {
    cmd_alias,				/* 00 CMD_ALIAS */
    cmd_reply,				/* 01 CMD_ANSWER */
    nocmd,				/* 02 CMD_BACKTRACK */
    cmd_bcc,				/* 03 CMD_BCC */
    cmd_blank,				/* 04 CMD_BLANK */
    cmd_browse,				/* 05 CMD_BROWSE */
    cmd_bug,				/* 06 CMD_BUG */
    cmd_cc,				/* 07 CMD_CC */
    cmd_cd,				/* 08 CMD_CD */
    cmd_check,				/* 09 CMD_CHECK */
    cmd_content_type,			/* 10 CMD_CONTENT_TYPE */
    cmd_continue,			/* 11 CMD_CONTINUE */
 (T)cmd_copy,				/* 12 CMD_COPY */
    cmd_count,				/* 13 CMD_COUNT */
    cmd_create_init,			/* 14 CMD_CREATE_INIT */
    cmd_daytime,			/* 15 CMD_DAYTIME */
    cmd_debug,				/* 16 CMD_DEBUG */
    cmd_debug_memory,			/* 17 CMD_MEMDEBUG */
    cmd_define,				/* 18 CMD_DEFINE */
    cmd_mark,				/* 19 CMD_DELETE */
    cmd_display,			/* 20 CMD_DISPLAY */
    cmd_download,			/* 21 CMD_DOWNOAD */
 (T)cmd_echo,				/* 22 CMD_ECHO */
 (T)cmd_edit,				/* 23 CMD_EDIT */
 (T)cmd_erase,				/* 24 CMD_ERASE */
 (T)cmd_get,				/* 25 CMD_EXAMINE */
 (T)cmd_exit,				/* 26 CMD_EXIT */
 (T)cmd_expunge,			/* 27 CMD_EXPUNGE */
    cmd_fcc,				/* 28 CMD_FCC */
    cmd_finger,				/* 29 CMD_FINGER */
    cmd_mark,				/* 30 CMD_FLAG */
    nocmd,				/* 31 CMD_FOLLOW */
    cmd_forward,			/* 32 CMD_FORWARD */
    cmd_from,				/* 33 CMD_FROM */
 (T)cmd_get,				/* 34 CMD_GET */
    cmd_headers,			/* 35 CMD_HEADERS */
 (T)cmd_help,				/* 36 CMD_HELP */
    cmd_insert,				/* 37 CMD_INSERT */
    cmd_in_reply_to,			/* 38 CMD_IN_REPLY_TO */
    cmd_jump,				/* 39 CMD_JUMP */
    cmd_keyword,			/* 40 CMD_KEYWORD */
 (T)cmd_next,				/* 41 CMD_KILL */
 (T)cmd_list,				/* 42 CMD_LIST */
    cmd_literal,			/* 43 CMD_LITERAL */
    cmd_mark,				/* 44 CMD_MARK */
    cmd_mime_version,			/* 45 CMD_MIME_VERSION */
 (T)cmd_copy,				/* 46 CMD_MOVE */
 (T)cmd_next,				/* 47 CMD_NEXT */
 (T)cmd_previous,			/* 48 CMD_PREVIOUS */
 (T)cmd_print,				/* 49 CMD_PRINT */
    cmd_profile,			/* 50 CMD_PROFILE */
 (T)cmd_push,				/* 51 CMD_PUSH */
    cmd_pwd,				/* 52 CMD_PWD */
    cmd_mark,     			/* 53 CMD_DELETE (QD) */
 (T)cmd_quit,				/* 54 CMD_QUIT */
 (T)cmd_quit,				/* 55 CMD_QQUIT */
 (T)cmd_read,				/* 56 CMD_READ */
    cmd_remail,				/* 57 CMD_REMAIL */
    cmd_remove,				/* 58 CMD_REMOVE */
    cmd_reply,				/* 59 CMD_REPLY */
    cmd_reply_to,			/* 60 CMD_REPLY_TO */
    cmd_restore_draft,			/* 61 CMD_RESTORE_DRAFT */
 (T)cmd_read,				/* 62 CMD_REVIEW */
    cmd_route,				/* 63 CMD_ROUTE */
    cmd_save_draft,			/* 64 CMD_SAVE_DRAFT */
    cmd_send,				/* 65 CMD_SEND */
 (T)cmd_set,				/* 66 CMD_SET */
 (T)cmd_show,				/* 67 CMD_SHOW */
    cmd_smail,				/* 68 CMD_SMAIL */
    cmd_sort,				/* 69 CMD_SORT */
    cmd_spell,				/* 70 CMD_SPELL */
    cmd_status,				/* 71 CMD_STATUS */
    cmd_subject,			/* 72 CMD_SUBJECT */
    cmd_suspend,			/* 73 CMD_SUSPEND */
    cmd_take,				/* 74 CMD_TAKE */
    cmd_text,				/* 75 CMD_TEXT */
    cmd_to,				/* 76 CMD_TO */
    cmd_transfer_encoding,		/* 77 CMD_TRANSFER_ENCODING */
    cmd_type,				/* 78 CMD_TYPE */
    cmd_mark,				/* 79 CMD_UNANSWER */
    cmd_mark,				/* 80 CMD_UNDELETE */
    cmd_mark,				/* 81 CMD_UNFLAG */
    cmd_unkeyword,			/* 82 CMD_UNKEYWORD */
    cmd_mark,				/* 83 CMD_UNMARK */
    cmd_user_header,			/* 84 CMD_USER_HEADER */
    cmd_version,			/* 85 CMD_VERSION */
 (T)cmd_who,				/* 86 CMD_WHO */
    cmd_write,				/* 87 CMD_WRITE */
    cmd_suspend,			/* 88 CMD_Z */
};
#undef T
