#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

 Author: Howie Kaye
*/

#include "args.h"
#include <stdio.h>

#if HAVE_STDC
#include <string.h>
#include <stdlib.h>
#include <time.h>
#else
#if defined(__hpux) || defined(sgi) || defined(ultrix) || defined(sun)
#define time_t long	/* no time_t in pre-Standard C environment */
#endif
extern time_t time ARGS((time_t *));
extern char *ctime ARGS((time_t *));
#endif /* HAVE_STDC */

int main ARGS((int argc, char **argv));

#define MAJSTRING "#define MAJORVERSION"
#define MINSTRING "#define MINORVERSION"
#define DATSTRING "#define VERSIONDATE"

int
#if HAVE_STDC
main(int argc, char **argv)
#else /* K&R style */
main(argc, argv)
int argc;
char **argv;
#endif /* HAVE_STDC */
{
  int maj_len, min_len, dat_len;
  char line[100];

  maj_len = strlen(MAJSTRING);
  min_len = strlen(MINSTRING);
  dat_len = strlen(DATSTRING);

  while(fgets(line, 100, stdin) != NULL) {
    if (strncmp(line,MINSTRING,maj_len) == 0) {
      int newversion = atoi(&line[min_len]) + 1;
      fprintf(stdout, "#define MINORVERSION %d\n",newversion);
    }
    else if (strncmp(line,DATSTRING,dat_len) == 0) {
      time_t t = time(0);
      char *cp = ctime(&t);
      cp[strlen(cp)-1] = '\0';

      fprintf(stdout, "#define VERSIONDATE \"%s\"\n", cp);
    }
    else
      fprintf(stdout,"%s",line);
  }
  return (0);
}
