#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <err.h>

#define BYTESPER (1024 * 1024)

int
main(int argc, char **argv)
{
    int fd, cnt, i;
    u_int32_t crc;
    char *textdata, *bindata;

    if (argc != 2) errx(1, "iteration count required");

    cnt = atoi(argv[1]);

    textdata = malloc(BYTESPER);
    bindata  = malloc(BYTESPER);

    if (!textdata || !bindata) err(2, "Can't allocate %d bytes", BYTESPER);

    fd = open("textdata", O_RDONLY, (mode_t)0);
    if (fd == -1) err(3, "Can't open text data for crc32");

    if (read(fd, textdata, BYTESPER) != BYTESPER) {
	err(4, "Can't read text data for crc32");
    }
    close(fd);

    fd = open("bindata", O_RDONLY, (mode_t)0);
    if (fd == -1) err(3, "Can't open binary data for crc32");

    if (read(fd, bindata, BYTESPER) != BYTESPER) {
	err(4, "Can't read binary data for crc32");
    }
    close(fd);

    for(i = 0; i < cnt; i++) {
	crc = crc32((u_int32_t)0, textdata, BYTESPER);
	crc = crc32((u_int32_t)0, bindata, BYTESPER);
    }
}
