# $Id: meta.autodep.mk,v 1.16 2011/06/24 21:11:15 sjg Exp $

#
#	@(#) Copyright (c) 2010, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

_this ?= ${.PARSEFILE}
.if !target(__${_this}__)
__${_this}__:

.-include "local.autodep.mk"

.if make(gendirdeps)
# you are supposed to know what you are doing!
UPDATE_DEPENDFILE = yes
.elif !empty(.TARGETS) && !make(all)
# do not update the *depend* files 
# unless we are building the entire directory or the default target.
# NO means don't update .depend - or Makefile.depend*
# no means update .depend but not Makefile.depend*
UPDATE_DEPENDFILE = NO
.elif ${.MAKEFLAGS:M-k} != ""
# it is a bad idea to update anything
UPDATE_DEPENDFILE = NO
.endif

_CURDIR ?= ${.CURDIR}
_DEPENDFILE := ${_CURDIR}/${.MAKE.DEPENDFILE:T}

.if ${.MAKE.LEVEL} == 0
.if ${BUILD_AT_LEVEL0:Uyes:tl} == "no"
UPDATE_DEPENDFILE = NO
.endif
.endif
.if !exists(${_DEPENDFILE})
_bootstrap_direps = yes
.endif
_bootstrap_direps ?= no
UPDATE_DEPENDFILE ?= yes

# sometimes we want .meta files generated to aid debugging/error detection
# but do not want to consider them for dependencies
# for example the result of running configure
# just make sure this is not empty
META_FILE_FILTER ?= N.meta

.if ${UPDATE_DEPENDFILE} != "NO" || ${_bootstrap_direps} == "yes"
.if !empty(DPADD)
# if we have any non-libs in DPADD, 
# they probably need to be paid attention to
.if !empty(DPLIBS)
FORCE_DPADD = ${DPADD:${DPLIBS:${M_ListToSkip}}:${DPADD_LAST:${M_ListToSkip}}}
.else
_nonlibs := ${DPADD:T:Nlib*:N*include}
.if !empty(_nonlibs)
FORCE_DPADD += ${_nonlibs:@x@${DPADD:M*/$x}@}
.endif
.endif
.endif

.if ${_bootstrap_direps} == "yes" || !empty(SRCS) || !empty(INCS) || !empty(META_XTRAS) || !empty(FORCE_DPADD)
.if ${.MAKE.MODE:Mmeta*} == "" || ${.MAKE.MODE:M*read*} != ""
UPDATE_DEPENDFILE = no
.endif

.if ${UPDATE_DEPENDFILE:tl} == "yes"
.END:	gendirdeps
.endif

.if !target(.depend)
# some makefiles and/or targets contain
# circular dependencies if you dig too deep 
# (as meta mode is apt to do) 
# so we provide a means of supressing them.
# the input to the loop below is target: dependency
# with just one dependency per line.
# Also some targets are not really local, or use random names.
# Use local.autodep.mk to provide local additions!
SUPPRESS_DEPEND += \
	${SB:S,/,_,g}* \
	*:y.tab.c \
	*.c:*.c \
	*.h:*.h

.NOPATH:	.depend
# we use ${.MAKE.META.CREATED} to trigger an update but
# we process using ${.MAKE.META.FILES}
# the double $$ defers initial evaluation
# if necessary, we fake .po dependencies, just so the result 
# in Makefile.depend* is stable
.depend: .NOMETA $${.MAKE.META.CREATED}
	@echo "Updating $@: ${.OODATE:T:[1..8]}"
	@egrep '^R [0-9]* (\./)*[^/]*\.[ch]$$' /dev/null ${.MAKE.META.FILES:T:O:u:${META_FILE_FILTER:ts:}} | \
	sed 's, \./, ,;s,^\([^/][^/]*\).meta...[0-9]* ,\1: ,' | \
	sort -u | \
	while read t d; do \
		case "$$d:" in $$t) continue;; esac; \
		case "$$t$$d" in ${SUPPRESS_DEPEND:U.:O:u:ts|}) continue;; esac; \
		echo $$t $$d; \
	done > $@.${.MAKE.PID}
	case "${.MAKE.META.FILES:T:M*.po.*}" in \
	*.po.*) mv $@.${.MAKE.PID} $@;; \
	*) { cat $@.${.MAKE.PID}; \
	sed 's,\.So:,.o:,;s,\.o:,.po:,' $@.${.MAKE.PID}; } | sort -u > $@; \
	rm -f $@.${.MAKE.PID};; \
	esac
.else
# do _not_ assume that .depend is in a fit state for us to use
CAT_DEPEND = /dev/null
.export CAT_DEPEND
# so use this to trigger update
DEPENDFILE_DEPENDS = $${.MAKE.META.CREATED}
.endif

gendirdeps:	${_DEPENDFILE}

.if !target(${_DEPENDFILE})
.if ${_bootstrap_direps} == "yes"
# We are boot-strapping a new directory
# Use DPADD to seed DIRDEPS
.if !empty(DPADD)
# anything which matches ${_OBJROOT}* but not ${_OBJTOP}*
# needs to be qualified in DIRDEPS
# The pseudo machine "host" is used for HOST_TARGET
DIRDEPS = \
	${DPADD:M${_OBJTOP}*:H:C,${_OBJTOP}[^/]*/,,:N.:O:u} \
	${DPADD:M${_OBJROOT}*:N${_OBJTOP}*:H:S,${_OBJROOT},,:C,^([^/]+)/(.*),\2.\1,:S,${HOST_TARGET}$,host,:N.*:O:u}

.endif
.endif

_gendirdeps_mutex =
.if defined(NEED_GENDIRDEPS_MUTEX)
# If a src dir gets built with multiple object dirs,
# we need a mutex.  Obviously, this is best avoided.
# Note if .MAKE.DEPENDFILE is common for all ${MACHINE}
# you either need to mutex, or ensure only one machine builds at a time!
# lockf is an example of a suitable tool
LOCKF ?= /usr/bin/lockf
.if exists(${LOCKF})
GENDIRDEPS_MUTEXER ?= ${LOCKF} -k
.endif
.if empty(GENDIRDEPS_MUTEXER)
.error NEED_GENDIRDEPS_MUTEX defined, but GENDIRDEPS_MUTEXER not set
.else
_gendirdeps_mutex = ${GENDIRDEPS_MUTEXER} ${GENDIRDEPS_MUTEX:U${_CURDIR}/Makefile}
.endif
.endif

.if make(gendirdeps)
META_FILES = *.meta
.elif ${OPTIMIZE_OBJECT_META_FILES:Uno:tl} == "no"
META_FILES = ${.MAKE.META.FILES:T:N.depend*:O:u}
.else
# if we have 1000's of .o.meta, .So.meta etc we need only look at one set
# it is left as an exercise for the reader to work out what this does
META_FILES = ${.MAKE.META.FILES:T:N.depend*:N*o.meta:O:u} \
	${.MAKE.META.FILES:T:M*.${.MAKE.META.FILES:M*o.meta:R:E:O:u:[1]}.meta:O:u}
.endif

# what triggers us to update _DEPENDFILE?
DEPENDFILE_DEPENDS ?= .depend
${_DEPENDFILE}: ${DEPENDFILE_DEPENDS} ${.PARSEDIR}/gendirdeps.mk ${.PARSEDIR}/meta2deps.sh
	@echo Checking $@: ${.OODATE:T:[1..8]}
	@(cd ${.TARGET:H} && \
	SKIP_GENDIRDEPS='${SKIP_GENDIRDEPS:O:u}' \
	DPADD='${FORCE_DPADD:O:u}' ${_gendirdeps_mutex} \
	${.MAKE} __objdir=${_OBJDIR} -f gendirdeps.mk \
	META_FILES='${META_XTRAS:T:O:u} ${META_FILES:T:O:u:${META_FILE_FILTER:ts:}}')
	test -s $@ && touch $@; :
.endif

.endif
.endif
.if ${_bootstrap_direps} == "yes"
# make sure this is included at least once
.include <dirdeps.mk>
.endif

CLEANFILES += *.meta filemon.* *.db
.endif
