/* $NetBSD: $ */

/*-
 * Copyright (c) 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _POWERPC_MPC5200_PSCVAR_H_
#define _POWERPC_MPC5200_PSCVAR_H_

#include "rnd.h"
#include "opt_kgdb.h"

#if NRND > 0 && defined(RND_PSC)
#include <sys/rnd.h>
#endif

#include <sys/callout.h>
#include <sys/timepps.h>
#include <sys/mutex.h>

int psccnattach(bus_space_tag_t, bus_addr_t, int, int, tcflag_t);

#ifdef KGDB
int psc_kgdb_attach(bus_space_tag_t, bus_addr_t, int, int, tcflag_t);
#endif

/* Hardware flag masks */
#define	PSC_HW_NOIEN	0x01
#define	PSC_HW_FIFO	0x02
		/*	0x04	free for use */
#define	PSC_HW_FLOW	0x08
#define	PSC_HW_DEV_OK	0x20
#define	PSC_HW_CONSOLE	0x40
#define	PSC_HW_KGDB	0x80
#define	PSC_HW_TXFIFO_DISABLE	0x100
#define	PSC_HW_NO_TXPRELOAD	0x200

/* Buffer size for character buffer */
#ifndef PSC_RING_SIZE
#define	PSC_RING_SIZE	2048
#endif

struct psc_softc {
	device_t		sc_dev;
	bus_space_tag_t		sc_iot;
	bus_space_handle_t	sc_ioh;

	void			*sc_si;
	struct tty		*sc_tty;

	struct callout sc_diag_callout;

	void			*sc_ih;
	int			sc_irq;

	int sc_frequency;

	u_int sc_overflows,
	      sc_floods,
	      sc_errors;

	int sc_hwflags,
	    sc_swflags;

	u_int sc_r_hiwat,
	      sc_r_lowat;
	u_char *volatile sc_rbget,
	       *volatile sc_rbput;
 	volatile u_int sc_rbavail;
	u_char *sc_rbuf,
	       *sc_ebuf;

 	u_char *sc_tba;
 	u_int sc_tbc,
	      sc_heldtbc;

	volatile u_char sc_rx_flags,
#define	RX_TTY_BLOCKED		0x01
#define	RX_TTY_OVERFLOWED	0x02
#define	RX_IBUF_BLOCKED		0x04
#define	RX_IBUF_OVERFLOWED	0x08
#define	RX_ANY_BLOCK		0x0f
			sc_tx_busy,
			sc_tx_done,
			sc_tx_stopped,
			sc_st_check,
			sc_rx_ready;

	volatile u_char sc_heldchange;
	volatile uint8_t sc_mr1, sc_mr2, sc_cr, sc_ipcr;
	volatile uint16_t sc_imr, sc_sr;
	uint8_t sc_ipcr_dcd, sc_ipcr_cts, sc_ipcr_mask;

	/* power management hooks */
	int (*enable)(struct psc_softc *);
	void (*disable)(struct psc_softc *);
	int enabled;

	int sc_of_flags;

	struct pps_state sc_pps_state;	/* pps state */

#if NRND > 0 && defined(RND_COM)
	rndsource_element_t  sc_rnd_source;
#endif
	kmutex_t		sc_lock;
};

int pscintr(void *);
int psc_detach(device_t, int);
bool psc_resume(device_t, const pmf_qual_t *);
bool psc_cleanup(device_t, int);
bool psc_suspend(device_t, const pmf_qual_t *);

#ifndef IPL_SERIAL
#define	IPL_SERIAL	IPL_TTY
#define	splserial()	spltty()
#endif

#endif /* _POWERPC_MPC5200_PSCVAR_H_ */
