/*	$NetBSD: $	*/

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _POWERPC_MPC5200_FECREG_H_
#define _POWERPC_MPC5200_FECREG_H_

#define	FEC_ID			0x000
#define	FEC_IEVENT		0x004
#define	FEC_IMASK		0x008
#define	FEC_R_DES_ACTIVE	0x010
#define	FEC_X_DEX_ACTIVE	0x014
#define FEC_ECNTRL		0x024
#define	FEC_MII_DATA		0x040
#define	FEC_MII_SPEED		0x044
#define	FEC_MIB_CONTROL		0x064
#define	FEC_R_CNTRL		0x084
#define	FEC_R_HASH		0x088
#define	FEC_X_CNTRL		0x0c4
#define	FEC_PADDR1		0x0e4
#define	FEC_PADDR2		0x0e8
#define	FEC_OP_PAUSE		0x0ec
#define	FEC_IADDR1		0x118
#define	FEC_IADDR2		0x11c
#define	FEC_GADDR1		0x120
#define	FEC_GADDR2		0x124
#define	FEC_X_WMRK		0x144
#define	FEC_RFIFO_DATA		0x184
#define	FEC_RFIFO_STATUS	0x188
#define	FEC_RFIFO_CONTROL	0x18c
#define	FEC_RFIFO_LRF_PTR	0x190
#define	FEC_RFIFO_LWF_PTR	0x194
#define	FEC_RFIFO_ALARM		0x198
#define	FEC_RFIFO_RDPTR		0x19c
#define	FEC_RFIFO_WRPTR		0x1a0
#define	FEC_TFIFO_DATA		0x1a4
#define	FEC_TFIFO_STATUS	0x1a8
#define	FEC_TFIFO_CONTROL	0x1ac
#define	FEC_TFIFO_LRF_PTR	0x1b0
#define	FEC_TFIFO_LWF_PTR	0x1b4
#define	FEC_TFIFO_ALARM		0x1b8
#define	FEC_TFIFO_RDPTR		0x1bc
#define	FEC_TFIFO_WRPTR		0x1c0
#define	FEC_RESET_CNTRL		0x1c4
#define	FEC_XMIT_FSM		0x1c8

#define	FEC_INT_HBERR		(1 << 31)
#define	FEC_INT_BABR		(1 << 30)
#define	FEC_INT_BABT		(1 << 29)
#define	FEC_INT_GRA		(1 << 28)
#define	FEC_INT_TFINT		(1 << 27)
#define	FEC_INT_MII		(1 << 23)
#define	FEC_INT_LATE_COLL	(1 << 21)
#define	FEC_INT_COL_RETRY_LIM	(1 << 20)
#define	FEC_INT_XFIFO_UN	(1 << 19)
#define	FEC_INT_XFIFO_ERROR	(1 << 18)
#define	FEC_INT_RFIFO_ERROR	(1 << 17)

#define	FEC_ECNTRL_ETHER_EN	(1 << 1)
#define	FEC_ECNTRL_RESET	(1 << 0)

#define	FEC_PHY_TIMEOUT		10000 /* msec */

#define	FEC_MII_START		(1 << 30)
#define	FEC_MII_OP_READ		(2 << 28)
#define	FEC_MII_OP_WRITE	(1 << 28)
#define	FEC_MII_PHYADDR(pa)	((pa) << 23)
#define FEC_MII_REGADDR(ra)	((ra) << 18)
#define FEC_MII_TA		(2 << 16)
#define	FEC_MII_VAL(dv)		((dv) & 0xffff)

#define FEC_MII_READ(p, a) \
	(FEC_MII_START | FEC_MII_OP_READ | \
	 FEC_MII_PHYADDR((p)) | FEC_MII_REGADDR((a)) | FEC_MII_TA)

#define	FEC_MII_WRITE(p, a, v) \
	(FEC_MII_START | FEC_MII_OP_WRITE | \
	 FEC_MII_PHYADDR((p)) | FEC_MII_REGADDR((a)) | \
	 FEC_MII_TA | FEC_MII_VAL((v)))

#define	FEC_FIFO_SIZE		1024

#endif /* _POWERPC_MPC5200_FECREG_H_ */
