/*	$NetBSD: $	*/

/*-
 * Copyright (c) 2023 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_IO_PGTABLE_H_
#define _LINUX_IO_PGTABLE_H_

enum io_pgtable_fmt {
	ARM_MALI_LPAE,
	IO_PGTABLE_NUM_FMTS,
};

struct iommu_flush_ops {
	void (*tlb_flush_all)(void *);
	void (*tlb_flush_walk)(uint64_t, size_t, size_t, void *);
	void (*tlb_flush_leaf)(uint64_t, size_t, size_t, void *);
};
	
struct io_pgtable_cfg {
	struct device			*iommu_dev;
	uint32_t			pgsize_bitmap;
	uint32_t			ias;
	uint32_t			oas;
	const struct iommu_flush_ops	*tlb;
	union {
		struct {
			uint64_t transtab;
			uint64_t memattr;
		} arm_mali_lpae_cfg;
	};
};

struct io_pgtable_ops {
	int (*map)(struct io_pgtable_ops *, unsigned long,
	    bus_addr_t, size_t, int);
	size_t (*unmap)(struct io_pgtable_ops *, uint64_t, size_t, void *);
	bus_addr_t (*iova_to_phys)(struct io_pgtable_ops *, uint64_t);
};

struct io_pgtable {
	enum io_pgtable_fmt	fmt;
	void			*data;
	struct io_pgtable_cfg	cfg;
	struct io_pgtable_ops	ops;
};

#define io_pgtable_ops_to_pgtable(x) container_of((x), struct io_pgtable, ops)

struct io_pgtable_ops *alloc_io_pgtable_ops(enum io_pgtable_fmt,
		struct io_pgtable_cfg *, void *);
void free_io_pgtable_ops(struct io_pgtable_ops *);

#endif  /* _LINUX_IO_PGTABLE_H_ */
