/* $NetBSD$ */
#ifndef _SYS_DEV_VAUDIODEV_H_
#define _SYS_DEV_VAUDIODEV_H_
typedef struct vaudiodev_softc {
	device_t	sc_dev;

	struct audio_encoding_set *sc_encodings;
	void		(*sc_intr)(void *);
	void		*sc_intrarg;

	void		(*sc_recintr)(void *);
	void		*sc_recintrarg;

	kcondvar_t	sc_condvar;
	kcondvar_t	sc_reccondvar;
	kmutex_t	sc_lock;
	kmutex_t	sc_intr_lock;

	struct vaudio_softc *sc_audiodev;
	size_t		sc_blksize;

#define VAUDIO_BLKSIZE	1024
#define VAUDIO_BUFSIZE	65536
	uint8_t		sc_audiobuf[VAUDIO_BUFSIZE];
	uint32_t	sc_buflen;
	uint32_t	sc_rpos, sc_wpos;

	uint8_t		sc_recaudiobuf[VAUDIO_BUFSIZE];
	uint32_t	sc_recbuflen;
	uint32_t	sc_recrpos, sc_recwpos;

	struct timeval	sc_last;
	size_t		sc_bytes_count;

	struct timeval	sc_reclast;
	size_t		sc_recbytes_count;
} vaudiodev_softc_t;

#endif /* !_SYS_DEV_VAUDIODEV_H_ */
